/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.score.stream.drools.bi;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.ToIntBiFunction;
import java.util.function.ToLongBiFunction;
import java.util.function.UnaryOperator;
import org.drools.model.DSL;
import org.drools.model.Drools;
import org.drools.model.Global;
import org.drools.model.PatternDSL;
import org.drools.model.RuleItemBuilder;
import org.drools.model.Variable;
import org.drools.model.consequences.ConsequenceBuilder;
import org.drools.model.functions.Block4;
import org.drools.model.functions.Function2;
import org.drools.model.functions.Predicate3;
import org.drools.model.functions.Predicate4;
import org.optaplanner.core.api.function.TriPredicate;
import org.optaplanner.core.api.score.holder.AbstractScoreHolder;
import org.optaplanner.core.api.score.stream.bi.BiConstraintCollector;
import org.optaplanner.core.api.score.stream.tri.TriJoiner;
import org.optaplanner.core.impl.score.stream.drools.bi.DroolsBiAccumulateFunctionBridge;
import org.optaplanner.core.impl.score.stream.drools.bi.DroolsBiGroupByInvoker;
import org.optaplanner.core.impl.score.stream.drools.bi.DroolsBiRuleStructure;
import org.optaplanner.core.impl.score.stream.drools.bi.DroolsBiToQuadGroupByInvoker;
import org.optaplanner.core.impl.score.stream.drools.bi.DroolsBiToTriGroupByInvoker;
import org.optaplanner.core.impl.score.stream.drools.common.BiTuple;
import org.optaplanner.core.impl.score.stream.drools.common.DroolsCondition;
import org.optaplanner.core.impl.score.stream.drools.common.DroolsPatternBuilder;
import org.optaplanner.core.impl.score.stream.drools.common.QuadTuple;
import org.optaplanner.core.impl.score.stream.drools.common.TriTuple;
import org.optaplanner.core.impl.score.stream.drools.quad.DroolsQuadCondition;
import org.optaplanner.core.impl.score.stream.drools.tri.DroolsTriCondition;
import org.optaplanner.core.impl.score.stream.drools.tri.DroolsTriRuleStructure;
import org.optaplanner.core.impl.score.stream.drools.uni.DroolsUniCondition;
import org.optaplanner.core.impl.score.stream.drools.uni.DroolsUniRuleStructure;
import org.optaplanner.core.impl.score.stream.tri.AbstractTriJoiner;
import org.optaplanner.core.impl.score.stream.tri.FilteringTriJoiner;
import org.optaplanner.core.impl.score.stream.tri.NoneTriJoiner;

public final class DroolsBiCondition<A, B, PatternVar>
extends DroolsCondition<PatternVar, DroolsBiRuleStructure<A, B, PatternVar>> {
    public DroolsBiCondition(DroolsBiRuleStructure<A, B, PatternVar> ruleStructure) {
        super(ruleStructure);
    }

    public DroolsBiCondition<A, B, PatternVar> andFilter(BiPredicate<A, B> predicate) {
        Predicate3 & Serializable filter = (Predicate3 & Serializable)(__, a, b) -> predicate.test(a, b);
        Variable aVariable = ((DroolsBiRuleStructure)this.ruleStructure).getA();
        Variable bVariable = ((DroolsBiRuleStructure)this.ruleStructure).getB();
        DroolsPatternBuilder newTargetPattern = ((DroolsBiRuleStructure)this.ruleStructure).getPrimaryPatternBuilder().expand(p -> p.expr("Filter using " + predicate, aVariable, bVariable, filter));
        DroolsBiRuleStructure newRuleStructure = new DroolsBiRuleStructure(aVariable, bVariable, newTargetPattern, ((DroolsBiRuleStructure)this.ruleStructure).getShelvedRuleItems(), ((DroolsBiRuleStructure)this.ruleStructure).getPrerequisites(), ((DroolsBiRuleStructure)this.ruleStructure).getDependents(), ((DroolsBiRuleStructure)this.ruleStructure).getVariableIdSupplier());
        return new DroolsBiCondition(newRuleStructure);
    }

    public <C, CPatternVar> DroolsTriCondition<A, B, C, CPatternVar> andJoin(DroolsUniCondition<C, CPatternVar> cCondition, AbstractTriJoiner<A, B, C> triJoiner) {
        DroolsUniRuleStructure cRuleStructure = (DroolsUniRuleStructure)cCondition.getRuleStructure();
        Variable cVariable = cRuleStructure.getA();
        UnaryOperator expander = p -> p.expr("Filter using " + triJoiner, ((DroolsBiRuleStructure)this.ruleStructure).getA(), ((DroolsBiRuleStructure)this.ruleStructure).getB(), cVariable, (Predicate4 & Serializable)(__, a, b, c) -> triJoiner.matches(a, b, c));
        DroolsUniRuleStructure newCRuleStructure = cRuleStructure.amend(expander);
        return new DroolsTriCondition(new DroolsTriRuleStructure((DroolsBiRuleStructure)this.ruleStructure, newCRuleStructure, ((DroolsBiRuleStructure)this.ruleStructure).getVariableIdSupplier()));
    }

    @SafeVarargs
    public final <C> DroolsBiCondition<A, B, PatternVar> andIfExists(Class<C> otherClass, TriJoiner<A, B, C> ... joiners) {
        return this.andIfExistsOrNot(true, otherClass, joiners);
    }

    @SafeVarargs
    public final <C> DroolsBiCondition<A, B, PatternVar> andIfNotExists(Class<C> otherClass, TriJoiner<A, B, C> ... joiners) {
        return this.andIfExistsOrNot(false, otherClass, joiners);
    }

    @SafeVarargs
    private final <C> DroolsBiCondition<A, B, PatternVar> andIfExistsOrNot(boolean shouldExist, Class<C> otherClass, TriJoiner<A, B, C> ... joiners) {
        int indexOfFirstFilter = -1;
        AbstractTriJoiner finalJoiner = null;
        TriPredicate finalFilter = null;
        for (int i = 0; i < joiners.length; ++i) {
            boolean hasAFilter;
            AbstractTriJoiner joiner = (AbstractTriJoiner)joiners[i];
            boolean bl = hasAFilter = indexOfFirstFilter >= 0;
            if (joiner instanceof NoneTriJoiner && joiners.length > 1) {
                throw new IllegalStateException("If present, " + NoneTriJoiner.class + " must be the only joiner, got " + Arrays.toString(joiners) + " instead.");
            }
            if (!(joiner instanceof FilteringTriJoiner)) {
                if (hasAFilter) {
                    throw new IllegalStateException("Indexing joiner (" + joiner + ") must not follow a filtering joiner (" + joiners[indexOfFirstFilter] + ").");
                }
                finalJoiner = finalJoiner == null ? joiner : AbstractTriJoiner.merge(finalJoiner, joiner);
                continue;
            }
            if (!hasAFilter) {
                indexOfFirstFilter = i;
            }
            finalFilter = finalFilter == null ? joiner.getFilter() : finalFilter.and(joiner.getFilter());
        }
        return this.applyJoiners(otherClass, finalJoiner, finalFilter, shouldExist);
    }

    private <C> DroolsBiCondition<A, B, PatternVar> applyJoiners(Class<C> otherClass, AbstractTriJoiner<A, B, C> joiner, TriPredicate<A, B, C> predicate, boolean shouldExist) {
        Variable<C> toExist = ((DroolsBiRuleStructure)this.ruleStructure).createVariable(otherClass, "biToExist");
        PatternDSL.PatternDef existencePattern = PatternDSL.pattern(toExist);
        if (joiner == null) {
            return this.applyFilters(existencePattern, predicate, shouldExist);
        }
        TriPredicate<Object, Object, Object> joinFilter = joiner::matches;
        TriPredicate<Object, Object, Object> result = predicate == null ? joinFilter : joinFilter.and(predicate);
        return this.applyFilters(existencePattern, result, shouldExist);
    }

    private <C> DroolsBiCondition<A, B, PatternVar> applyFilters(PatternDSL.PatternDef<C> existencePattern, TriPredicate<A, B, C> predicate, boolean shouldExist) {
        PatternDSL.PatternDef possiblyFilteredExistencePattern = predicate == null ? existencePattern : existencePattern.expr("Filter using " + predicate, ((DroolsBiRuleStructure)this.ruleStructure).getA(), ((DroolsBiRuleStructure)this.ruleStructure).getB(), (Predicate3 & Serializable)(c, a, b) -> predicate.test(a, b, c));
        return new DroolsBiCondition(((DroolsBiRuleStructure)this.ruleStructure).existsOrNot(possiblyFilteredExistencePattern, shouldExist));
    }

    public <NewA, __> DroolsUniCondition<NewA, NewA> andCollect(BiConstraintCollector<A, B, __, NewA> collector) {
        DroolsBiAccumulateFunctionBridge<A, B, __, NewA> bridge = new DroolsBiAccumulateFunctionBridge<A, B, __, NewA>(collector);
        return this.collect(bridge, (pattern, tuple) -> pattern.bind(tuple, ((DroolsBiRuleStructure)this.ruleStructure).getA(), (Function2 & Serializable)(b, a) -> new BiTuple<Object, Object>(a, b)));
    }

    public <NewA> DroolsUniCondition<NewA, NewA> andGroup(BiFunction<A, B, NewA> groupKeyMapping) {
        return this.group((pattern, tuple) -> pattern.bind(tuple, ((DroolsBiRuleStructure)this.ruleStructure).getA(), (Function2 & Serializable)(b, a) -> groupKeyMapping.apply(a, b)));
    }

    public <NewA, NewB> DroolsBiCondition<NewA, NewB, BiTuple<NewA, NewB>> andGroupWithCollect(BiFunction<A, B, NewA> groupKeyMapping, BiConstraintCollector<A, B, ?, NewB> collector) {
        return this.groupWithCollect(() -> new DroolsBiGroupByInvoker(groupKeyMapping, collector, ((DroolsBiRuleStructure)this.getRuleStructure()).getA(), ((DroolsBiRuleStructure)this.getRuleStructure()).getB()));
    }

    public <NewA, NewB> DroolsBiCondition<NewA, NewB, BiTuple<NewA, NewB>> andGroupBi(BiFunction<A, B, NewA> groupKeyAMapping, BiFunction<A, B, NewB> groupKeyBMapping) {
        return this.groupBi((pattern, tuple) -> pattern.bind(tuple, ((DroolsBiRuleStructure)this.ruleStructure).getA(), (Function2 & Serializable)(b, a) -> {
            Object newA = groupKeyAMapping.apply(a, b);
            Object newB = groupKeyBMapping.apply(a, b);
            return new BiTuple(newA, newB);
        }));
    }

    public <NewA, NewB, NewC> DroolsTriCondition<NewA, NewB, NewC, TriTuple<NewA, NewB, NewC>> andGroupBiWithCollect(BiFunction<A, B, NewA> groupKeyAMapping, BiFunction<A, B, NewB> groupKeyBMapping, BiConstraintCollector<A, B, ?, NewC> collector) {
        return this.groupBiWithCollect(() -> new DroolsBiToTriGroupByInvoker(groupKeyAMapping, groupKeyBMapping, collector, ((DroolsBiRuleStructure)this.getRuleStructure()).getA(), ((DroolsBiRuleStructure)this.getRuleStructure()).getB()));
    }

    public <NewA, NewB, NewC, NewD> DroolsQuadCondition<NewA, NewB, NewC, NewD, QuadTuple<NewA, NewB, NewC, NewD>> andGroupBiWithCollectBi(BiFunction<A, B, NewA> groupKeyAMapping, BiFunction<A, B, NewB> groupKeyBMapping, BiConstraintCollector<A, B, ?, NewC> collectorC, BiConstraintCollector<A, B, ?, NewD> collectorD) {
        return this.groupBiWithCollectBi(() -> new DroolsBiToQuadGroupByInvoker(groupKeyAMapping, groupKeyBMapping, collectorC, collectorD, ((DroolsBiRuleStructure)this.getRuleStructure()).getA(), ((DroolsBiRuleStructure)this.getRuleStructure()).getB()));
    }

    public List<RuleItemBuilder<?>> completeWithScoring(Global<? extends AbstractScoreHolder<?>> scoreHolderGlobal) {
        return this.completeWithScoring(scoreHolderGlobal, (Block4 & Serializable)(drools, scoreHolder, __, ___) -> this.impactScore((Drools)drools, scoreHolder));
    }

    public List<RuleItemBuilder<?>> completeWithScoring(Global<? extends AbstractScoreHolder<?>> scoreHolderGlobal, ToIntBiFunction<A, B> matchWeighter) {
        return this.completeWithScoring(scoreHolderGlobal, (Block4 & Serializable)(drools, scoreHolder, a, b) -> this.impactScore((Drools)drools, scoreHolder, matchWeighter.applyAsInt(a, b)));
    }

    public List<RuleItemBuilder<?>> completeWithScoring(Global<? extends AbstractScoreHolder<?>> scoreHolderGlobal, ToLongBiFunction<A, B> matchWeighter) {
        return this.completeWithScoring(scoreHolderGlobal, (Block4 & Serializable)(drools, scoreHolder, a, b) -> this.impactScore((Drools)drools, scoreHolder, matchWeighter.applyAsLong(a, b)));
    }

    public List<RuleItemBuilder<?>> completeWithScoring(Global<? extends AbstractScoreHolder<?>> scoreHolderGlobal, BiFunction<A, B, BigDecimal> matchWeighter) {
        return this.completeWithScoring(scoreHolderGlobal, (Block4 & Serializable)(drools, scoreHolder, a, b) -> this.impactScore((Drools)drools, scoreHolder, (BigDecimal)matchWeighter.apply(a, b)));
    }

    private <ScoreHolder extends AbstractScoreHolder<?>> List<RuleItemBuilder<?>> completeWithScoring(Global<ScoreHolder> scoreHolderGlobal, Block4<Drools, ScoreHolder, A, B> consequenceImpl) {
        ConsequenceBuilder._3 consequence = DSL.on(scoreHolderGlobal, ((DroolsBiRuleStructure)this.ruleStructure).getA(), ((DroolsBiRuleStructure)this.ruleStructure).getB()).execute(consequenceImpl);
        return ((DroolsBiRuleStructure)this.ruleStructure).finish((ConsequenceBuilder.AbstractValidBuilder<?>)consequence);
    }
}

