/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.score.stream.drools.uni;

import java.util.Collections;
import java.util.List;
import org.optaplanner.core.impl.score.stream.drools.DroolsConstraintFactory;
import org.optaplanner.core.impl.score.stream.drools.uni.DroolsAbstractUniConstraintStream;
import org.optaplanner.core.impl.score.stream.drools.uni.DroolsUniCondition;

public final class DroolsFromUniConstraintStream<Solution_, A>
extends DroolsAbstractUniConstraintStream<Solution_, A> {
    private final Class<A> fromClass;
    private final DroolsUniCondition<A, ?> condition;

    public DroolsFromUniConstraintStream(DroolsConstraintFactory<Solution_> constraintFactory, Class<A> fromClass) {
        super(constraintFactory);
        if (fromClass == null) {
            throw new IllegalArgumentException("The fromClass (null) cannot be null.");
        }
        this.fromClass = fromClass;
        this.condition = new DroolsUniCondition(fromClass, constraintFactory.getVariableIdSupplier());
    }

    @Override
    public List<DroolsFromUniConstraintStream<Solution_, Object>> getFromStreamList() {
        return Collections.singletonList(this);
    }

    @Override
    public boolean isGroupByAllowed() {
        return true;
    }

    @Override
    public DroolsUniCondition<A, ?> getCondition() {
        return this.condition;
    }

    public Class<A> getFromClass() {
        return this.fromClass;
    }

    public String toString() {
        return "From(" + this.fromClass.getSimpleName() + ") with " + this.getChildStreams().size() + " children";
    }
}

