/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.score.stream.drools.tri;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.LongSupplier;
import java.util.stream.Stream;
import org.drools.model.Argument;
import org.drools.model.DSL;
import org.drools.model.PatternDSL;
import org.drools.model.Variable;
import org.drools.model.view.ExprViewItem;
import org.drools.model.view.ViewItemBuilder;
import org.optaplanner.core.impl.score.stream.drools.bi.DroolsBiRuleStructure;
import org.optaplanner.core.impl.score.stream.drools.common.DroolsPatternBuilder;
import org.optaplanner.core.impl.score.stream.drools.common.DroolsRuleStructure;
import org.optaplanner.core.impl.score.stream.drools.uni.DroolsUniRuleStructure;

public class DroolsTriRuleStructure<A, B, C, PatternVar>
extends DroolsRuleStructure<PatternVar> {
    private final Variable<A> a;
    private final Variable<B> b;
    private final Variable<C> c;
    private final DroolsPatternBuilder<PatternVar> primaryPattern;
    private final List<ViewItemBuilder<?>> shelved;
    private final List<ViewItemBuilder<?>> prerequisites;
    private final List<ViewItemBuilder<?>> dependents;

    public <AbPatternVar> DroolsTriRuleStructure(DroolsBiRuleStructure<A, B, AbPatternVar> abRuleStructure, DroolsUniRuleStructure<C, PatternVar> cRuleStructure, LongSupplier variableIdSupplier) {
        super(variableIdSupplier);
        this.a = abRuleStructure.getA();
        this.b = abRuleStructure.getB();
        this.c = cRuleStructure.getA();
        this.primaryPattern = cRuleStructure.getPrimaryPatternBuilder();
        ArrayList newShelved = new ArrayList(abRuleStructure.getShelvedRuleItems());
        newShelved.addAll(cRuleStructure.getShelvedRuleItems());
        this.shelved = Collections.unmodifiableList(newShelved);
        ArrayList newOpenItems = new ArrayList(abRuleStructure.getPrerequisites());
        newOpenItems.add((ViewItemBuilder<?>)abRuleStructure.getPrimaryPatternBuilder().build());
        newOpenItems.addAll(abRuleStructure.getDependents());
        newOpenItems.addAll(cRuleStructure.getPrerequisites());
        this.prerequisites = Collections.unmodifiableList(newOpenItems);
        this.dependents = Collections.unmodifiableList(cRuleStructure.getDependents());
    }

    public DroolsTriRuleStructure(Variable<A> aVariable, Variable<B> bVariable, Variable<C> cVariable, DroolsPatternBuilder<PatternVar> primaryPattern, List<ViewItemBuilder<?>> shelved, List<ViewItemBuilder<?>> prerequisites, List<ViewItemBuilder<?>> dependents, LongSupplier variableIdSupplier) {
        super(variableIdSupplier);
        this.a = aVariable;
        this.b = bVariable;
        this.c = cVariable;
        this.primaryPattern = primaryPattern;
        this.shelved = Collections.unmodifiableList(shelved);
        this.prerequisites = Collections.unmodifiableList(prerequisites);
        this.dependents = Collections.unmodifiableList(dependents);
    }

    public <D> DroolsTriRuleStructure<A, B, C, PatternVar> existsOrNot(PatternDSL.PatternDef<D> existencePattern, boolean shouldExist) {
        ExprViewItem item = DSL.exists(existencePattern, (ViewItemBuilder[])new ViewItemBuilder[0]);
        if (!shouldExist) {
            item = DSL.not((ViewItemBuilder)item, (ViewItemBuilder[])new ViewItemBuilder[0]);
        }
        return new DroolsTriRuleStructure<A, B, C, PatternVar>(this.a, this.b, this.c, this.primaryPattern, this.shelved, this.prerequisites, this.mergeDependents(new ViewItemBuilder[]{item}), this.getVariableIdSupplier());
    }

    public Variable<A> getA() {
        return this.a;
    }

    public Variable<B> getB() {
        return this.b;
    }

    public Variable<C> getC() {
        return this.c;
    }

    @Override
    public DroolsPatternBuilder<PatternVar> getPrimaryPatternBuilder() {
        return this.primaryPattern;
    }

    @Override
    public List<ViewItemBuilder<?>> getShelvedRuleItems() {
        return this.shelved;
    }

    @Override
    public List<ViewItemBuilder<?>> getPrerequisites() {
        return this.prerequisites;
    }

    @Override
    public List<ViewItemBuilder<?>> getDependents() {
        return this.dependents;
    }

    @Override
    protected Class[] getVariableTypes() {
        return (Class[])Stream.of(this.a, this.b, this.c).map(Argument::getType).toArray(Class[]::new);
    }
}

