/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.services.optaplanner;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.stream.Collectors;
import org.kie.api.runtime.KieContainer;
import org.kie.server.api.model.KieServiceResponse;
import org.kie.server.api.model.ServiceResponse;
import org.kie.server.api.model.instance.ScoreWrapper;
import org.kie.server.api.model.instance.SolverInstance;
import org.kie.server.api.model.instance.SolverInstanceList;
import org.kie.server.services.api.KieContainerInstance;
import org.kie.server.services.api.KieServerRegistry;
import org.kie.server.services.impl.KieContainerInstanceImpl;
import org.kie.server.services.optaplanner.SolverInstanceContext;
import org.kie.server.services.prometheus.PrometheusKieServerExtension;
import org.kie.server.services.prometheus.PrometheusMetricsSolverListener;
import org.optaplanner.core.api.score.Score;
import org.optaplanner.core.api.solver.Solver;
import org.optaplanner.core.api.solver.SolverFactory;
import org.optaplanner.core.impl.phase.event.PhaseLifecycleListener;
import org.optaplanner.core.impl.solver.AbstractSolver;
import org.optaplanner.core.impl.solver.ProblemFactChange;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SolverServiceBase {
    private static final Logger logger = LoggerFactory.getLogger(SolverServiceBase.class);
    private final ExecutorService executor;
    private final KieServerRegistry context;
    private final Map<String, SolverInstanceContext> solvers = new ConcurrentHashMap<String, SolverInstanceContext>();

    public SolverServiceBase(KieServerRegistry context, ExecutorService executorService) {
        this.context = context;
        this.executor = executorService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServiceResponse<SolverInstance> createSolver(String containerId, String solverId, SolverInstance instance) {
        if (instance == null || instance.getSolverConfigFile() == null) {
            logger.error("Error creating solver. Configuration file name is null: " + instance);
            return new ServiceResponse(KieServiceResponse.ResponseType.FAILURE, "Failed to create solver for container " + containerId + ". Solver configuration file is null: " + instance);
        }
        instance.setContainerId(containerId);
        instance.setSolverId(solverId);
        try {
            KieContainerInstanceImpl ci = this.context.getContainer(containerId);
            if (ci == null) {
                logger.error("Error creating solver. Container does not exist: " + containerId);
                return new ServiceResponse(KieServiceResponse.ResponseType.FAILURE, "Failed to create solver. Container does not exist: " + containerId);
            }
            KieContainerInstanceImpl kieContainerInstanceImpl = ci;
            synchronized (kieContainerInstanceImpl) {
                if (this.solvers.containsKey(instance.getSolverInstanceKey())) {
                    logger.error("Error creating solver. Solver '" + solverId + "' already exists for container '" + containerId + "'.");
                    return new ServiceResponse(KieServiceResponse.ResponseType.FAILURE, "Failed to create solver. Solver '" + solverId + "' already exists for container '" + containerId + "'.");
                }
                SolverInstanceContext sic = new SolverInstanceContext(instance);
                if (instance.getStatus() == null) {
                    instance.setStatus(SolverInstance.SolverStatus.NOT_SOLVING);
                }
                try {
                    SolverFactory solverFactory = SolverFactory.createFromKieContainerXmlResource((KieContainer)ci.getKieContainer(), (String)instance.getSolverConfigFile());
                    Solver solver = solverFactory.buildSolver();
                    sic.setSolver((Solver<Object>)solver);
                    this.registerListener(solver, solverId);
                    this.updateSolverInstance(sic);
                    this.solvers.put(instance.getSolverInstanceKey(), sic);
                    logger.info("Solver '" + solverId + "' successfully created in container '" + containerId + "'");
                    return new ServiceResponse(KieServiceResponse.ResponseType.SUCCESS, "Solver '" + solverId + "' successfully created in container '" + containerId + "'", (Object)instance);
                }
                catch (Exception e) {
                    logger.error("Error creating solver factory for solver " + instance, (Throwable)e);
                    return new ServiceResponse(KieServiceResponse.ResponseType.FAILURE, "Error creating solver factory for solver: " + e.getMessage(), (Object)instance);
                }
            }
        }
        catch (Exception e) {
            logger.error("Error creating solver '" + solverId + "' in container '" + containerId + "'", (Throwable)e);
            return new ServiceResponse(KieServiceResponse.ResponseType.FAILURE, "Error creating solver '" + solverId + "' in container '" + containerId + "': " + e.getMessage(), (Object)instance);
        }
    }

    public ServiceResponse<SolverInstanceList> getSolvers(String containerId) {
        try {
            List<SolverInstance> sl = this.getSolversForContainer(containerId);
            return new ServiceResponse(KieServiceResponse.ResponseType.SUCCESS, "Solvers list successfully retrieved from container '" + containerId + "'", (Object)new SolverInstanceList(sl));
        }
        catch (Exception e) {
            logger.error("Error retrieving solvers list from container '" + containerId + "'", (Throwable)e);
            return new ServiceResponse(KieServiceResponse.ResponseType.FAILURE, "Error retrieving solvers list from container '" + containerId + "'" + e.getMessage(), null);
        }
    }

    public ServiceResponse<SolverInstance> getSolver(String containerId, String solverId) {
        try {
            SolverInstanceContext sic = this.solvers.get(SolverInstance.getSolverInstanceKey((String)containerId, (String)solverId));
            if (sic != null) {
                this.updateSolverInstance(sic);
                return new ServiceResponse(KieServiceResponse.ResponseType.SUCCESS, "Solver '" + solverId + "' state successfully retrieved from container '" + containerId + "'", (Object)sic.getInstance());
            }
            return new ServiceResponse(KieServiceResponse.ResponseType.FAILURE, "Solver '" + solverId + "' not found in container '" + containerId + "'", null);
        }
        catch (Exception e) {
            logger.error("Error retrieving solver '" + solverId + "' state from container '" + containerId + "'", (Throwable)e);
            return new ServiceResponse(KieServiceResponse.ResponseType.FAILURE, "Error retrieving solver '" + solverId + "' state from container '" + containerId + "'" + e.getMessage(), null);
        }
    }

    public ServiceResponse<SolverInstance> getSolverWithBestSolution(String containerId, String solverId) {
        try {
            SolverInstanceContext sic = this.solvers.get(SolverInstance.getSolverInstanceKey((String)containerId, (String)solverId));
            if (sic != null) {
                this.updateSolverInstance(sic);
                sic.getInstance().setBestSolution(sic.getSolver().getBestSolution());
                return new ServiceResponse(KieServiceResponse.ResponseType.SUCCESS, "Best computed solution for '" + solverId + "' successfully retrieved from container '" + containerId + "'", (Object)sic.getInstance());
            }
            return new ServiceResponse(KieServiceResponse.ResponseType.FAILURE, "Solver '" + solverId + "' not found in container '" + containerId + "'", null);
        }
        catch (Exception e) {
            logger.error("Error retrieving solver '" + solverId + "' state from container '" + containerId + "'", (Throwable)e);
            return new ServiceResponse(KieServiceResponse.ResponseType.FAILURE, "Error retrieving solver '" + solverId + "' state from container '" + containerId + "'" + e.getMessage(), null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServiceResponse<Void> solvePlanningProblem(String containerId, String solverId, Object planningProblem) {
        try {
            SolverInstanceContext sic = this.solvers.get(SolverInstance.getSolverInstanceKey((String)containerId, (String)solverId));
            if (sic != null) {
                SolverInstanceContext solverInstanceContext = sic;
                synchronized (solverInstanceContext) {
                    switch (sic.getInstance().getStatus()) {
                        case SOLVING: {
                            return new ServiceResponse(KieServiceResponse.ResponseType.FAILURE, "Solver '" + solverId + "' on container '" + containerId + "' is already executing.");
                        }
                        case TERMINATING_EARLY: {
                            return new ServiceResponse(KieServiceResponse.ResponseType.FAILURE, "Solver '" + solverId + "' on container '" + containerId + "' has already terminated.");
                        }
                        case NOT_SOLVING: {
                            if (planningProblem == null) {
                                return new ServiceResponse(KieServiceResponse.ResponseType.FAILURE, "Planning-problem is a mandatory field when starting the solver.");
                            }
                            this.updateSolverInstance(sic);
                            this.solvePlanningProblem(sic, planningProblem);
                            return new ServiceResponse(KieServiceResponse.ResponseType.SUCCESS, "Solver '" + solverId + "' from container '" + containerId + "' successfully started.");
                        }
                    }
                    return new ServiceResponse(KieServiceResponse.ResponseType.FAILURE, "Solver '" + solverId + "' on container '" + containerId + "' is in unrecognized state '" + sic.getInstance().getStatus() + "'.");
                }
            }
            return new ServiceResponse(KieServiceResponse.ResponseType.FAILURE, "Solver '" + solverId + "' not found in container '" + containerId + "'");
        }
        catch (Exception e) {
            logger.error("Error retrieving solver '" + solverId + "' state from container '" + containerId + "'", (Throwable)e);
            return new ServiceResponse(KieServiceResponse.ResponseType.FAILURE, "Unknown error updating solver state.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServiceResponse<Void> terminateSolverEarly(String containerId, String solverId) {
        try {
            SolverInstanceContext sic = this.solvers.get(SolverInstance.getSolverInstanceKey((String)containerId, (String)solverId));
            if (sic != null) {
                SolverInstanceContext solverInstanceContext = sic;
                synchronized (solverInstanceContext) {
                    switch (sic.getInstance().getStatus()) {
                        case SOLVING: {
                            this.terminateSolverEarly(sic);
                            return new ServiceResponse(KieServiceResponse.ResponseType.SUCCESS, "Solver '" + solverId + "' on container '" + containerId + "' successfully terminated.");
                        }
                        case TERMINATING_EARLY: {
                            return new ServiceResponse(KieServiceResponse.ResponseType.FAILURE, "Solver '" + solverId + "' on container '" + containerId + "' already terminated.");
                        }
                        case NOT_SOLVING: {
                            return new ServiceResponse(KieServiceResponse.ResponseType.FAILURE, "Solver '" + solverId + "' from container '" + containerId + "' is not executing.");
                        }
                    }
                    return new ServiceResponse(KieServiceResponse.ResponseType.FAILURE, "Solver '" + solverId + "' on container '" + containerId + "' is in unrecognized state '" + sic.getInstance().getStatus() + "'.");
                }
            }
            return new ServiceResponse(KieServiceResponse.ResponseType.FAILURE, "Solver '" + solverId + "' not found in container '" + containerId + "'");
        }
        catch (Exception e) {
            logger.error("Error retrieving solver '" + solverId + "' state from container '" + containerId + "'", (Throwable)e);
            return new ServiceResponse(KieServiceResponse.ResponseType.FAILURE, "Unknown error updating solver state.");
        }
    }

    public ServiceResponse<Void> addProblemFactChanges(String containerId, String solverId, Object problemFactChanges) {
        try {
            SolverInstanceContext sic = this.solvers.get(SolverInstance.getSolverInstanceKey((String)containerId, (String)solverId));
            if (problemFactChanges instanceof List) {
                List problemFactChangesList = (List)problemFactChanges;
                HashMap<Integer, String> indexClassNameErrorMap = new HashMap<Integer, String>();
                for (int i = 0; i < problemFactChangesList.size(); ++i) {
                    Object problemFactChange = problemFactChangesList.get(i);
                    if (problemFactChange instanceof ProblemFactChange) continue;
                    indexClassNameErrorMap.put(i, problemFactChange.getClass().getName());
                }
                if (!indexClassNameErrorMap.isEmpty()) {
                    String errorItemsString = indexClassNameErrorMap.entrySet().stream().map(e -> "[index " + e.getKey() + ", type: " + ((String)e.getValue()).getClass() + "]").collect(Collectors.joining(","));
                    return new ServiceResponse(KieServiceResponse.ResponseType.FAILURE, "Items (" + errorItemsString + ") of supplied 'problemFactChangeObject' parameter are not instances of " + ProblemFactChange.class.getName() + ".");
                }
                return this.submitProblemFactChanges(sic, containerId, solverId, () -> sic.getSolver().addProblemFactChanges(problemFactChangesList));
            }
            if (!(problemFactChanges instanceof ProblemFactChange)) {
                return new ServiceResponse(KieServiceResponse.ResponseType.FAILURE, "Supplied 'problemFactChangeObject' parameter is not an instance of " + ProblemFactChange.class.getName() + ". Actual parameter type: " + problemFactChanges.getClass().getName());
            }
            return this.submitProblemFactChanges(sic, containerId, solverId, () -> sic.getSolver().addProblemFactChange((ProblemFactChange)problemFactChanges));
        }
        catch (Exception e2) {
            logger.error("Error adding problem fact change'" + problemFactChanges + "' to solver '" + solverId + "' from container '" + containerId + "'", (Throwable)e2);
            return new ServiceResponse(KieServiceResponse.ResponseType.FAILURE, "Unknown error while adding problem fact change.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ServiceResponse<Void> submitProblemFactChanges(SolverInstanceContext sic, String containerId, String solverId, Runnable solverAction) {
        if (sic != null) {
            SolverInstanceContext solverInstanceContext = sic;
            synchronized (solverInstanceContext) {
                switch (sic.getInstance().getStatus()) {
                    case SOLVING: {
                        solverAction.run();
                        return new ServiceResponse(KieServiceResponse.ResponseType.SUCCESS, "Problem fact changes have been successfully submitted to solver '" + solverId + "' on container '" + containerId + "'.");
                    }
                    case TERMINATING_EARLY: {
                        return new ServiceResponse(KieServiceResponse.ResponseType.FAILURE, "Solver '" + solverId + "' on container '" + containerId + "' has already terminated.");
                    }
                    case NOT_SOLVING: {
                        return new ServiceResponse(KieServiceResponse.ResponseType.SUCCESS, "Solver '" + solverId + "' on container '" + containerId + "' is not running.");
                    }
                }
                return new ServiceResponse(KieServiceResponse.ResponseType.FAILURE, "Solver '" + solverId + "' on container '" + containerId + "' is in unrecognized state '" + sic.getInstance().getStatus() + "'.");
            }
        }
        return new ServiceResponse(KieServiceResponse.ResponseType.FAILURE, "Solver '" + solverId + "' not found in container '" + containerId + "'");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServiceResponse<Boolean> isEveryProblemFactChangeProcessed(String containerId, String solverId) {
        try {
            SolverInstanceContext sic = this.solvers.get(SolverInstance.getSolverInstanceKey((String)containerId, (String)solverId));
            if (sic != null) {
                SolverInstanceContext solverInstanceContext = sic;
                synchronized (solverInstanceContext) {
                    switch (sic.getInstance().getStatus()) {
                        case SOLVING: {
                            boolean everyProblemFactChangeProcessed = sic.getSolver().isEveryProblemFactChangeProcessed();
                            return new ServiceResponse(KieServiceResponse.ResponseType.SUCCESS, "Problem fact changes have been successfully queried from solver '" + solverId + "' on container '" + containerId + "'.", (Object)everyProblemFactChangeProcessed);
                        }
                        case TERMINATING_EARLY: {
                            return new ServiceResponse(KieServiceResponse.ResponseType.FAILURE, "Solver '" + solverId + "' on container '" + containerId + "' already terminated.");
                        }
                        case NOT_SOLVING: {
                            return new ServiceResponse(KieServiceResponse.ResponseType.FAILURE, "Solver '" + solverId + "' from container '" + containerId + "' is not executing.");
                        }
                    }
                    return new ServiceResponse(KieServiceResponse.ResponseType.FAILURE, "Solver '" + solverId + "' on container '" + containerId + "' is in unrecognized state '" + sic.getInstance().getStatus() + "'.");
                }
            }
            return new ServiceResponse(KieServiceResponse.ResponseType.FAILURE, "Solver '" + solverId + "' not found in container '" + containerId + "'");
        }
        catch (Exception e) {
            logger.error("Error retrieving solver '" + solverId + "' state from container '" + containerId + "'", (Throwable)e);
            return new ServiceResponse(KieServiceResponse.ResponseType.FAILURE, "Unknown error querying problem facts processing state.");
        }
    }

    public ServiceResponse<Void> disposeSolver(String containerId, String solverId) {
        try {
            SolverInstanceContext sic = this.internalDisposeSolver(containerId, solverId);
            if (sic != null) {
                return new ServiceResponse(KieServiceResponse.ResponseType.SUCCESS, "Solver '" + solverId + "' successfully disposed from container '" + containerId + "'", null);
            }
            return new ServiceResponse(KieServiceResponse.ResponseType.FAILURE, "Solver '" + solverId + "' from container '" + containerId + "' not found.", null);
        }
        catch (Exception e) {
            logger.error("Error disposing solver '" + solverId + "' from container '" + containerId + "'", (Throwable)e);
            return new ServiceResponse(KieServiceResponse.ResponseType.FAILURE, "Error disposing solver '" + solverId + "' from container '" + containerId + "'. Message: " + e.getMessage(), null);
        }
    }

    public KieServerRegistry getKieServerRegistry() {
        return this.context;
    }

    public void disposeSolversForContainer(String containerId, KieContainerInstance kci) {
        List<SolverInstance> sfc = this.getSolversForContainer(containerId);
        for (SolverInstance si : sfc) {
            this.internalDisposeSolver(containerId, si.getSolverId());
        }
    }

    private List<SolverInstance> getSolversForContainer(String containerId) {
        ArrayList<SolverInstance> sl = new ArrayList<SolverInstance>(this.solvers.size());
        for (SolverInstanceContext sic : this.solvers.values()) {
            if (!containerId.equalsIgnoreCase(sic.getInstance().getContainerId())) continue;
            this.updateSolverInstance(sic);
            sl.add(sic.getInstance());
        }
        return sl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SolverInstanceContext internalDisposeSolver(String containerId, String solverId) {
        SolverInstanceContext sic = this.solvers.remove(SolverInstance.getSolverInstanceKey((String)containerId, (String)solverId));
        if (sic != null) {
            SolverInstanceContext solverInstanceContext = sic;
            synchronized (solverInstanceContext) {
                if (sic.getInstance().getStatus() == SolverInstance.SolverStatus.SOLVING) {
                    this.terminateSolverEarly(sic);
                }
            }
        }
        return sic;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateSolverInstance(SolverInstanceContext sic) {
        SolverInstanceContext solverInstanceContext = sic;
        synchronized (solverInstanceContext) {
            Score bestScore = sic.getSolver().getBestScore();
            sic.getInstance().setScoreWrapper(new ScoreWrapper(bestScore));
        }
    }

    private void updateSolverStatus(SolverInstanceContext sic) {
        Solver<Object> solver = sic.getSolver();
        if (!solver.isSolving()) {
            sic.getInstance().setStatus(SolverInstance.SolverStatus.NOT_SOLVING);
        } else if (solver.isTerminateEarly()) {
            sic.getInstance().setStatus(SolverInstance.SolverStatus.TERMINATING_EARLY);
        } else {
            sic.getInstance().setStatus(SolverInstance.SolverStatus.SOLVING);
        }
    }

    private void solvePlanningProblem(SolverInstanceContext sic, Object planningSolution) {
        sic.getInstance().setBestSolution(null);
        sic.getInstance().setStatus(SolverInstance.SolverStatus.SOLVING);
        this.executor.execute(() -> {
            try {
                Object status;
                SolverInstanceContext solverInstanceContext = sic;
                synchronized (solverInstanceContext) {
                    status = sic.getInstance().getStatus();
                }
                if (status == SolverInstance.SolverStatus.SOLVING) {
                    sic.getSolver().solve(planningSolution);
                }
            }
            catch (Exception e) {
                logger.error("Exception executing solver '" + sic.getInstance().getSolverId() + "' from container '" + sic.getInstance().getContainerId() + "'. Thread will terminate.", (Throwable)e);
            }
            finally {
                SolverInstanceContext solverInstanceContext = sic;
                synchronized (solverInstanceContext) {
                    sic.getInstance().setStatus(SolverInstance.SolverStatus.NOT_SOLVING);
                }
            }
        });
    }

    private void registerListener(Solver solver, String solverId) {
        PrometheusKieServerExtension extension = (PrometheusKieServerExtension)this.context.getServerExtension("Prometheus");
        if (extension != null) {
            ((AbstractSolver)solver).addPhaseLifecycleListener((PhaseLifecycleListener)new PrometheusMetricsSolverListener(solverId));
            extension.getOptaPlannerListeners(solverId).forEach(l -> ((AbstractSolver)solver).addPhaseLifecycleListener(l));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void terminateSolverEarly(SolverInstanceContext sic) {
        SolverInstanceContext solverInstanceContext = sic;
        synchronized (solverInstanceContext) {
            if (sic.getInstance().getStatus() == SolverInstance.SolverStatus.SOLVING) {
                sic.getInstance().setStatus(SolverInstance.SolverStatus.TERMINATING_EARLY);
            }
        }
        sic.getSolver().terminateEarly();
    }
}

