/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.core.compiler;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.kie.dmn.api.core.DMNType;
import org.kie.dmn.api.core.ast.BusinessKnowledgeModelNode;
import org.kie.dmn.api.core.ast.DMNNode;
import org.kie.dmn.api.core.ast.DecisionNode;
import org.kie.dmn.api.core.ast.DecisionServiceNode;
import org.kie.dmn.api.core.ast.InputDataNode;
import org.kie.dmn.core.api.DMNExpressionEvaluator;
import org.kie.dmn.core.ast.DMNBaseNode;
import org.kie.dmn.core.ast.DecisionNodeImpl;
import org.kie.dmn.core.compiler.DMNCompilerContext;
import org.kie.dmn.core.compiler.DMNCompilerHelper;
import org.kie.dmn.core.compiler.DMNCompilerImpl;
import org.kie.dmn.core.compiler.DRGElementCompiler;
import org.kie.dmn.core.impl.CompositeTypeImpl;
import org.kie.dmn.core.impl.DMNModelImpl;
import org.kie.dmn.core.util.Msg;
import org.kie.dmn.model.api.DMNModelInstrumentedBase;
import org.kie.dmn.model.api.DRGElement;
import org.kie.dmn.model.api.Decision;
import org.kie.dmn.model.api.NamedElement;

public class DecisionCompiler
implements DRGElementCompiler {
    @Override
    public boolean accept(DRGElement de) {
        return de instanceof Decision;
    }

    @Override
    public void compileNode(DRGElement de, DMNCompilerImpl compiler, DMNModelImpl model) {
        Decision decision = (Decision)de;
        DecisionNodeImpl dn = new DecisionNodeImpl(decision);
        DMNType type = null;
        if (decision.getVariable() == null) {
            DMNCompilerHelper.reportMissingVariable(model, (NamedElement)de, (DMNModelInstrumentedBase)decision, Msg.MISSING_VARIABLE_FOR_DECISION);
            return;
        }
        DMNCompilerHelper.checkVariableName(model, (NamedElement)decision, decision.getName());
        type = decision.getVariable() != null && decision.getVariable().getTypeRef() != null ? compiler.resolveTypeRef(model, (NamedElement)decision, (DMNModelInstrumentedBase)decision.getVariable(), decision.getVariable().getTypeRef()) : compiler.resolveTypeRef(model, (NamedElement)decision, (DMNModelInstrumentedBase)decision, null);
        dn.setResultType(type);
        model.addDecision(dn);
    }

    @Override
    public boolean accept(DMNNode node) {
        return node instanceof DecisionNodeImpl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void compileEvaluator(DMNNode node, DMNCompilerImpl compiler, DMNCompilerContext ctx, DMNModelImpl model) {
        DecisionNodeImpl di = (DecisionNodeImpl)node;
        compiler.linkRequirements(model, di);
        ctx.enterFrame();
        try {
            DecisionCompiler.loadInCtx(di, ctx, model);
            DMNExpressionEvaluator evaluator = compiler.getEvaluatorCompiler().compileExpression(ctx, model, di, di.getName(), di.getDecision().getExpression());
            di.setEvaluator(evaluator);
        }
        finally {
            ctx.exitFrame();
        }
    }

    public static void loadInCtx(DMNBaseNode node, DMNCompilerContext ctx, DMNModelImpl model) {
        HashMap<String, DMNType> importedTypes = new HashMap<String, DMNType>();
        for (DMNNode dMNNode : node.getDependencies().values()) {
            DMNType depType = null;
            if (dMNNode instanceof DecisionNode) {
                depType = ((DecisionNode)dMNNode).getResultType();
            } else if (dMNNode instanceof InputDataNode) {
                depType = ((InputDataNode)dMNNode).getType();
            } else if (dMNNode instanceof BusinessKnowledgeModelNode) {
                depType = ((BusinessKnowledgeModelNode)dMNNode).getResultType();
            } else if (dMNNode instanceof DecisionServiceNode) {
                depType = ((DecisionServiceNode)dMNNode).getResultType();
            }
            if (dMNNode.getModelNamespace().equals(model.getNamespace())) {
                ctx.setVariable(dMNNode.getName(), depType);
                continue;
            }
            Optional<String> alias = model.getImportAliasFor(dMNNode.getModelNamespace(), dMNNode.getModelName());
            if (!alias.isPresent()) continue;
            CompositeTypeImpl importedComposite = (CompositeTypeImpl)importedTypes.computeIfAbsent(alias.get(), a -> new CompositeTypeImpl());
            importedComposite.addField(dMNNode.getName(), depType);
        }
        for (Map.Entry entry : importedTypes.entrySet()) {
            ctx.setVariable((String)entry.getKey(), (DMNType)entry.getValue());
        }
    }
}

