/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.score.stream.bi;

import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import java.util.stream.IntStream;
import org.optaplanner.core.impl.score.stream.bi.AbstractBiJoiner;
import org.optaplanner.core.impl.score.stream.bi.SingleBiJoiner;
import org.optaplanner.core.impl.score.stream.common.JoinerType;

public final class CompositeBiJoiner<A, B>
extends AbstractBiJoiner<A, B> {
    private final List<SingleBiJoiner<A, B>> joinerList;
    private final Function<A, ?>[] leftMappings;
    private final Function<B, ?>[] rightMappings;

    public CompositeBiJoiner(List<SingleBiJoiner<A, B>> joinerList) {
        if (joinerList.isEmpty()) {
            throw new IllegalArgumentException("The joinerList (" + joinerList + ") must not be empty.");
        }
        this.joinerList = joinerList;
        this.leftMappings = (Function[])joinerList.stream().map(SingleBiJoiner::getLeftMapping).toArray(Function[]::new);
        this.rightMappings = (Function[])joinerList.stream().map(SingleBiJoiner::getRightMapping).toArray(Function[]::new);
    }

    public List<SingleBiJoiner<A, B>> getJoinerList() {
        return this.joinerList;
    }

    @Override
    public Function<A, Object> getLeftMapping(int index) {
        return this.leftMappings[index];
    }

    @Override
    public Function<A, Object[]> getLeftCombinedMapping() {
        Function[] mappings = (Function[])IntStream.range(0, this.joinerList.size()).mapToObj(this::getLeftMapping).toArray(Function[]::new);
        return a -> Arrays.stream(mappings).map(f -> f.apply(a)).toArray();
    }

    @Override
    public JoinerType[] getJoinerTypes() {
        return (JoinerType[])this.joinerList.stream().map(SingleBiJoiner::getJoinerType).toArray(JoinerType[]::new);
    }

    @Override
    public Function<B, Object> getRightMapping(int index) {
        return this.rightMappings[index];
    }

    @Override
    public Function<B, Object[]> getRightCombinedMapping() {
        Function[] mappings = (Function[])IntStream.range(0, this.joinerList.size()).mapToObj(this::getRightMapping).toArray(Function[]::new);
        return b -> Arrays.stream(mappings).map(f -> f.apply(b)).toArray();
    }
}

