/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.score.stream.drools.quad;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.LongSupplier;
import java.util.stream.Stream;
import org.drools.model.Argument;
import org.drools.model.DSL;
import org.drools.model.PatternDSL;
import org.drools.model.Variable;
import org.drools.model.view.ExprViewItem;
import org.drools.model.view.ViewItemBuilder;
import org.optaplanner.core.impl.score.stream.drools.common.DroolsPatternBuilder;
import org.optaplanner.core.impl.score.stream.drools.common.DroolsRuleStructure;
import org.optaplanner.core.impl.score.stream.drools.tri.DroolsTriRuleStructure;
import org.optaplanner.core.impl.score.stream.drools.uni.DroolsUniRuleStructure;

public class DroolsQuadRuleStructure<A, B, C, D, PatternVar>
extends DroolsRuleStructure<PatternVar> {
    private final Variable<A> a;
    private final Variable<B> b;
    private final Variable<C> c;
    private final Variable<D> d;
    private final DroolsPatternBuilder<PatternVar> primaryPattern;
    private final List<ViewItemBuilder<?>> shelved;
    private final List<ViewItemBuilder<?>> prerequisites;
    private final List<ViewItemBuilder<?>> dependents;

    public <AbcPatternVar> DroolsQuadRuleStructure(DroolsTriRuleStructure<A, B, C, AbcPatternVar> abcRuleStructure, DroolsUniRuleStructure<D, PatternVar> dRuleStructure, LongSupplier variableIdSupplier) {
        super(variableIdSupplier);
        this.a = abcRuleStructure.getA();
        this.b = abcRuleStructure.getB();
        this.c = abcRuleStructure.getC();
        this.d = dRuleStructure.getA();
        this.primaryPattern = dRuleStructure.getPrimaryPatternBuilder();
        ArrayList newShelved = new ArrayList(abcRuleStructure.getShelvedRuleItems());
        newShelved.addAll(dRuleStructure.getShelvedRuleItems());
        this.shelved = Collections.unmodifiableList(newShelved);
        ArrayList newOpenItems = new ArrayList(abcRuleStructure.getPrerequisites());
        newOpenItems.add((ViewItemBuilder<?>)abcRuleStructure.getPrimaryPatternBuilder().build());
        newOpenItems.addAll(abcRuleStructure.getDependents());
        newOpenItems.addAll(dRuleStructure.getPrerequisites());
        this.prerequisites = Collections.unmodifiableList(newOpenItems);
        this.dependents = Collections.unmodifiableList(dRuleStructure.getDependents());
    }

    public DroolsQuadRuleStructure(Variable<A> aVariable, Variable<B> bVariable, Variable<C> cVariable, Variable<D> dVariable, DroolsPatternBuilder<PatternVar> primaryPattern, List<ViewItemBuilder<?>> shelved, List<ViewItemBuilder<?>> prerequisites, List<ViewItemBuilder<?>> dependents, LongSupplier variableIdSupplier) {
        super(variableIdSupplier);
        this.a = aVariable;
        this.b = bVariable;
        this.c = cVariable;
        this.d = dVariable;
        this.primaryPattern = primaryPattern;
        this.shelved = Collections.unmodifiableList(shelved);
        this.prerequisites = Collections.unmodifiableList(prerequisites);
        this.dependents = Collections.unmodifiableList(dependents);
    }

    public <E> DroolsQuadRuleStructure<A, B, C, D, PatternVar> existsOrNot(PatternDSL.PatternDef<E> existencePattern, boolean shouldExist) {
        ExprViewItem item = DSL.exists(existencePattern, (ViewItemBuilder[])new ViewItemBuilder[0]);
        if (!shouldExist) {
            item = DSL.not((ViewItemBuilder)item, (ViewItemBuilder[])new ViewItemBuilder[0]);
        }
        return new DroolsQuadRuleStructure<A, B, C, D, PatternVar>(this.a, this.b, this.c, this.d, this.primaryPattern, this.shelved, this.prerequisites, this.mergeDependents(new ViewItemBuilder[]{item}), this.getVariableIdSupplier());
    }

    public Variable<A> getA() {
        return this.a;
    }

    public Variable<B> getB() {
        return this.b;
    }

    public Variable<C> getC() {
        return this.c;
    }

    public Variable<D> getD() {
        return this.d;
    }

    @Override
    public DroolsPatternBuilder<PatternVar> getPrimaryPatternBuilder() {
        return this.primaryPattern;
    }

    @Override
    public List<ViewItemBuilder<?>> getShelvedRuleItems() {
        return this.shelved;
    }

    @Override
    public List<ViewItemBuilder<?>> getPrerequisites() {
        return this.prerequisites;
    }

    @Override
    public List<ViewItemBuilder<?>> getDependents() {
        return this.dependents;
    }

    @Override
    protected Class[] getVariableTypes() {
        return (Class[])Stream.of(this.a, this.b, this.c, this.d).map(Argument::getType).toArray(Class[]::new);
    }
}

