/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.resources;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.enterprise.context.NormalScope;
import javax.inject.Scope;
import org.jboss.weld.annotated.slim.backed.BackedAnnotatedParameter;
import org.jboss.weld.bootstrap.api.helpers.AbstractBootstrapService;
import org.jboss.weld.metadata.TypeStore;
import org.jboss.weld.resources.ReflectionCache;
import org.jboss.weld.util.Function;
import org.jboss.weld.util.cache.ComputingCache;
import org.jboss.weld.util.cache.ComputingCacheBuilder;
import org.jboss.weld.util.collections.Arrays2;
import org.jboss.weld.util.collections.ImmutableSet;

public class DefaultReflectionCache
extends AbstractBootstrapService
implements ReflectionCache {
    private final TypeStore store;
    private final ComputingCache<AnnotatedElement, Annotations> annotations;
    private final ComputingCache<AnnotatedElement, Annotations> declaredAnnotations;
    private final ComputingCache<Constructor<?>, Annotation[][]> constructorParameterAnnotations;
    private final ComputingCache<Method, Annotation[][]> methodParameterAnnotations;
    private final ComputingCache<BackedAnnotatedParameter<?>, Set<Annotation>> parameterAnnotationSet;
    private final ComputingCache<Class<?>, Set<Annotation>> backedAnnotatedTypeAnnotations;
    private final ComputingCache<Class<? extends Annotation>, Boolean> isScopeAnnotation;

    protected Annotation[] internalGetAnnotations(AnnotatedElement element) {
        return element.getAnnotations();
    }

    protected Annotation[] internalGetDeclaredAnnotations(AnnotatedElement element) {
        return element.getDeclaredAnnotations();
    }

    public DefaultReflectionCache(TypeStore store) {
        this.store = store;
        ComputingCacheBuilder cacheBuilder = ComputingCacheBuilder.newBuilder();
        this.annotations = cacheBuilder.build(new Function<AnnotatedElement, Annotations>(){

            @Override
            public Annotations apply(AnnotatedElement input) {
                return new Annotations(DefaultReflectionCache.this.internalGetAnnotations(input));
            }
        });
        this.declaredAnnotations = cacheBuilder.build(new Function<AnnotatedElement, Annotations>(){

            @Override
            public Annotations apply(AnnotatedElement input) {
                return new Annotations(DefaultReflectionCache.this.internalGetDeclaredAnnotations(input));
            }
        });
        this.constructorParameterAnnotations = cacheBuilder.build(new Function<Constructor<?>, Annotation[][]>(){

            @Override
            public Annotation[][] apply(Constructor<?> input) {
                return input.getParameterAnnotations();
            }
        });
        this.methodParameterAnnotations = cacheBuilder.build(new Function<Method, Annotation[][]>(){

            @Override
            public Annotation[][] apply(Method input) {
                return input.getParameterAnnotations();
            }
        });
        this.parameterAnnotationSet = cacheBuilder.build(new Function<BackedAnnotatedParameter<?>, Set<Annotation>>(){

            @Override
            public Set<Annotation> apply(BackedAnnotatedParameter<?> parameter) {
                Member member = parameter.getDeclaringCallable().getJavaMember();
                if (member instanceof Method) {
                    return ImmutableSet.of(DefaultReflectionCache.this.getParameterAnnotations((Method)member, parameter.getPosition()));
                }
                return ImmutableSet.of(DefaultReflectionCache.this.getParameterAnnotations((Constructor)member, parameter.getPosition()));
            }
        });
        this.backedAnnotatedTypeAnnotations = cacheBuilder.build(new BackedAnnotatedTypeAnnotationsFunction());
        this.isScopeAnnotation = cacheBuilder.build(new IsScopeAnnotationFunction());
    }

    @Override
    public Annotation[] getAnnotations(AnnotatedElement element) {
        return this.annotations.getValue(element).annotations;
    }

    @Override
    public Annotation[] getDeclaredAnnotations(AnnotatedElement element) {
        return this.declaredAnnotations.getValue(element).annotations;
    }

    @Override
    public Annotation[] getParameterAnnotations(Constructor<?> constructor, int parameterPosition) {
        return this.constructorParameterAnnotations.getValue(constructor)[parameterPosition];
    }

    @Override
    public Annotation[] getParameterAnnotations(Method method, int parameterPosition) {
        return this.methodParameterAnnotations.getValue(method)[parameterPosition];
    }

    public void cleanupAfterBoot() {
        this.annotations.clear();
        this.declaredAnnotations.clear();
        this.constructorParameterAnnotations.clear();
        this.methodParameterAnnotations.clear();
        this.backedAnnotatedTypeAnnotations.clear();
        this.isScopeAnnotation.clear();
        this.parameterAnnotationSet.clear();
    }

    @Override
    public Set<Annotation> getAnnotationSet(AnnotatedElement element) {
        return this.annotations.getValue(element).annotationSet;
    }

    @Override
    public Set<Annotation> getDeclaredAnnotationSet(AnnotatedElement element) {
        return this.declaredAnnotations.getValue(element).annotationSet;
    }

    @Override
    public Set<Annotation> getParameterAnnotationSet(BackedAnnotatedParameter<?> parameter) {
        return this.parameterAnnotationSet.getValue(parameter);
    }

    @Override
    public Set<Annotation> getBackedAnnotatedTypeAnnotationSet(Class<?> javaClass) {
        return this.backedAnnotatedTypeAnnotations.getValue(javaClass);
    }

    private class IsScopeAnnotationFunction
    implements Function<Class<? extends Annotation>, Boolean> {
        private IsScopeAnnotationFunction() {
        }

        @Override
        public Boolean apply(Class<? extends Annotation> input) {
            if (input.isAnnotationPresent(NormalScope.class)) {
                return true;
            }
            if (input.isAnnotationPresent(Scope.class)) {
                return true;
            }
            return DefaultReflectionCache.this.store.isExtraScope(input);
        }
    }

    private class BackedAnnotatedTypeAnnotationsFunction
    implements Function<Class<?>, Set<Annotation>> {
        private BackedAnnotatedTypeAnnotationsFunction() {
        }

        @Override
        public Set<Annotation> apply(Class<?> javaClass) {
            Set<Annotation> annotations = DefaultReflectionCache.this.getAnnotationSet(javaClass);
            boolean scopeFound = false;
            for (Annotation annotation : annotations) {
                boolean isScope = (Boolean)DefaultReflectionCache.this.isScopeAnnotation.getValue(annotation.annotationType());
                if (isScope && scopeFound) {
                    return this.applyScopeInheritanceRules(annotations, javaClass);
                }
                if (!isScope) continue;
                scopeFound = true;
            }
            return annotations;
        }

        public Set<Annotation> applyScopeInheritanceRules(Set<Annotation> annotations, Class<?> javaClass) {
            HashSet<Annotation> result = new HashSet<Annotation>();
            for (Annotation annotation : annotations) {
                if (((Boolean)DefaultReflectionCache.this.isScopeAnnotation.getValue(annotation.annotationType())).booleanValue()) continue;
                result.add(annotation);
            }
            result.addAll(this.findTopLevelScopeDefinitions(javaClass));
            return ImmutableSet.copyOf(result);
        }

        public Set<Annotation> findTopLevelScopeDefinitions(Class<?> javaClass) {
            for (Class<?> clazz = javaClass; clazz != null && clazz != Object.class; clazz = clazz.getSuperclass()) {
                HashSet<Annotation> scopes = new HashSet<Annotation>();
                for (Annotation annotation : DefaultReflectionCache.this.getDeclaredAnnotations(clazz)) {
                    if (!((Boolean)DefaultReflectionCache.this.isScopeAnnotation.getValue(annotation.annotationType())).booleanValue()) continue;
                    scopes.add(annotation);
                }
                if (scopes.size() <= 0) continue;
                return scopes;
            }
            throw new IllegalStateException();
        }
    }

    private static class Annotations {
        private final Annotation[] annotations;
        private final Set<Annotation> annotationSet;

        public Annotations(Annotation[] annotations) {
            if (annotations.length == 0) {
                this.annotations = Arrays2.EMPTY_ANNOTATION_ARRAY;
                this.annotationSet = Collections.emptySet();
            } else {
                this.annotations = annotations;
                this.annotationSet = ImmutableSet.copyOf(Arrays.asList(annotations));
            }
        }
    }
}

