/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.constructionheuristic.decider.forager;

import java.util.Comparator;
import org.optaplanner.core.api.score.FeasibilityScore;
import org.optaplanner.core.api.score.Score;
import org.optaplanner.core.api.score.comparator.NaturalScoreComparator;
import org.optaplanner.core.config.constructionheuristic.decider.forager.ConstructionHeuristicPickEarlyType;
import org.optaplanner.core.impl.constructionheuristic.decider.forager.AbstractConstructionHeuristicForager;
import org.optaplanner.core.impl.constructionheuristic.scope.ConstructionHeuristicMoveScope;
import org.optaplanner.core.impl.constructionheuristic.scope.ConstructionHeuristicPhaseScope;
import org.optaplanner.core.impl.constructionheuristic.scope.ConstructionHeuristicStepScope;

public class DefaultConstructionHeuristicForager
extends AbstractConstructionHeuristicForager {
    protected final ConstructionHeuristicPickEarlyType pickEarlyType;
    protected Comparator<Score> scoreComparator;
    protected long selectedMoveCount;
    protected ConstructionHeuristicMoveScope earlyPickedMoveScope;
    protected ConstructionHeuristicMoveScope maxScoreMoveScope;

    public DefaultConstructionHeuristicForager(ConstructionHeuristicPickEarlyType pickEarlyType) {
        this.pickEarlyType = pickEarlyType;
        this.scoreComparator = new NaturalScoreComparator();
    }

    public void stepStarted(ConstructionHeuristicStepScope stepScope) {
        super.stepStarted(stepScope);
        this.selectedMoveCount = 0L;
        this.earlyPickedMoveScope = null;
        this.maxScoreMoveScope = null;
    }

    public void stepEnded(ConstructionHeuristicStepScope stepScope) {
        super.stepEnded(stepScope);
        this.earlyPickedMoveScope = null;
        this.maxScoreMoveScope = null;
    }

    @Override
    public void addMove(ConstructionHeuristicMoveScope moveScope) {
        ++this.selectedMoveCount;
        this.checkPickEarly(moveScope);
        if (this.maxScoreMoveScope == null || this.scoreComparator.compare(moveScope.getScore(), this.maxScoreMoveScope.getScore()) > 0) {
            this.maxScoreMoveScope = moveScope;
        }
    }

    protected void checkPickEarly(ConstructionHeuristicMoveScope moveScope) {
        switch (this.pickEarlyType) {
            case NEVER: {
                break;
            }
            case FIRST_NON_DETERIORATING_SCORE: {
                Score lastStepScore = ((ConstructionHeuristicPhaseScope)((ConstructionHeuristicStepScope)moveScope.getStepScope()).getPhaseScope()).getLastCompletedStepScope().getScore();
                if (moveScope.getScore().toInitializedScore().compareTo(lastStepScore.toInitializedScore()) < 0) break;
                this.earlyPickedMoveScope = moveScope;
                break;
            }
            case FIRST_FEASIBLE_SCORE: {
                if (!((FeasibilityScore)moveScope.getScore().toInitializedScore()).isFeasible()) break;
                this.earlyPickedMoveScope = moveScope;
                break;
            }
            case FIRST_FEASIBLE_SCORE_OR_NON_DETERIORATING_HARD: {
                Score lastStepScore2 = ((ConstructionHeuristicPhaseScope)((ConstructionHeuristicStepScope)moveScope.getStepScope()).getPhaseScope()).getLastCompletedStepScope().getScore();
                Object lastStepScoreDifference = moveScope.getScore().toInitializedScore().subtract(lastStepScore2.toInitializedScore());
                if (!((FeasibilityScore)lastStepScoreDifference).isFeasible()) break;
                this.earlyPickedMoveScope = moveScope;
                break;
            }
            default: {
                throw new IllegalStateException("The pickEarlyType (" + (Object)((Object)this.pickEarlyType) + ") is not implemented.");
            }
        }
    }

    @Override
    public boolean isQuitEarly() {
        return this.earlyPickedMoveScope != null;
    }

    @Override
    public ConstructionHeuristicMoveScope pickMove(ConstructionHeuristicStepScope stepScope) {
        stepScope.setSelectedMoveCount(this.selectedMoveCount);
        if (this.earlyPickedMoveScope != null) {
            return this.earlyPickedMoveScope;
        }
        return this.maxScoreMoveScope;
    }
}

