/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.score.stream.drools.bi;

import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import org.optaplanner.core.api.function.TriFunction;
import org.optaplanner.core.api.score.stream.bi.BiConstraintCollector;
import org.optaplanner.core.impl.score.stream.drools.common.BiTuple;
import org.optaplanner.core.impl.score.stream.drools.common.DroolsAbstractUniCollectingGroupByAccumulator;

final class DroolsBiGroupByAccumulator<A, B, ResultContainer, NewA, NewB>
extends DroolsAbstractUniCollectingGroupByAccumulator<ResultContainer, BiTuple<A, B>, NewA, BiTuple<NewA, NewB>> {
    private final BiFunction<A, B, NewA> groupKeyMapping;
    private final Supplier<ResultContainer> supplier;
    private final TriFunction<ResultContainer, A, B, Runnable> accumulator;
    private final Function<ResultContainer, NewB> finisher;

    public DroolsBiGroupByAccumulator(BiFunction<A, B, NewA> groupKeyMapping, BiConstraintCollector<A, B, ResultContainer, NewB> collector) {
        this.groupKeyMapping = groupKeyMapping;
        this.supplier = collector.supplier();
        this.accumulator = collector.accumulator();
        this.finisher = collector.finisher();
    }

    @Override
    protected NewA toKey(BiTuple<A, B> tuple) {
        return this.groupKeyMapping.apply(tuple.a, tuple.b);
    }

    @Override
    protected ResultContainer newContainer() {
        return this.supplier.get();
    }

    @Override
    protected Runnable process(BiTuple<A, B> tuple, ResultContainer container) {
        return this.accumulator.apply(container, tuple.a, tuple.b);
    }

    @Override
    protected BiTuple<NewA, NewB> toResult(NewA key, ResultContainer container) {
        return new BiTuple<NewA, NewB>(key, this.finisher.apply(container));
    }
}

