/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.core.compiler.execmodelbased;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.drools.core.util.IoUtils;

public class DMNRuleClassFile {
    public static final String RULE_CLASS_FILE_NAME = "META-INF/kie/dmn";
    private ClassLoader classLoader;
    private List<String> classFile;

    public DMNRuleClassFile(ClassLoader classLoader) {
        this.classLoader = classLoader;
        if (this.classLoader == null) {
            this.classFile = Collections.emptyList();
        }
    }

    public boolean hasCompiledClasses() {
        if (this.classFile == null) {
            this.classFile = this.getClassFile();
        }
        return this.classFile.size() > 0;
    }

    public List<String> getClassFile() {
        if (this.classFile == null) {
            try {
                InputStream resourceAsStream = this.classLoader.getResourceAsStream(RULE_CLASS_FILE_NAME);
                if (resourceAsStream != null) {
                    String allClasses = new String(IoUtils.readBytesFromInputStream((InputStream)resourceAsStream));
                    this.classFile = Arrays.asList(allClasses.split("\\n"));
                } else {
                    this.classFile = new ArrayList<String>();
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return this.classFile;
    }

    public Optional<String> getCompiledClass(String className) {
        return this.getClassFile().stream().filter(ms -> ms.equals(className)).findFirst();
    }
}

