/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.services.taskassigning.planning;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.kie.api.task.model.Status;
import org.kie.server.api.model.taskassigning.TaskData;
import org.kie.server.api.model.taskassigning.util.StatusConverter;
import org.kie.server.services.taskassigning.core.model.AbstractPersistable;
import org.kie.server.services.taskassigning.core.model.ModelConstants;
import org.kie.server.services.taskassigning.core.model.Task;
import org.kie.server.services.taskassigning.core.model.TaskAssigningSolution;
import org.kie.server.services.taskassigning.core.model.solver.realtime.AddTaskProblemFactChange;
import org.kie.server.services.taskassigning.core.model.solver.realtime.AssignTaskProblemFactChange;
import org.kie.server.services.taskassigning.core.model.solver.realtime.ReleaseTaskProblemFactChange;
import org.kie.server.services.taskassigning.core.model.solver.realtime.RemoveTaskProblemFactChange;
import org.kie.server.services.taskassigning.core.model.solver.realtime.TaskPropertyChangeProblemFactChange;
import org.kie.server.services.taskassigning.planning.SolverHandlerContext;
import org.kie.server.services.taskassigning.planning.TraceHelper;
import org.kie.server.services.taskassigning.planning.util.IndexedElement;
import org.kie.server.services.taskassigning.planning.util.TaskUtil;
import org.kie.server.services.taskassigning.planning.util.UserUtil;
import org.kie.server.services.taskassigning.user.system.api.User;
import org.kie.server.services.taskassigning.user.system.api.UserSystemService;
import org.optaplanner.core.impl.solver.ProblemFactChange;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SolutionChangesBuilder {
    private static final Logger LOGGER = LoggerFactory.getLogger(SolutionChangesBuilder.class);
    private TaskAssigningSolution solution;
    private List<TaskData> taskDataList;
    private UserSystemService userSystemService;
    private SolverHandlerContext context;

    private SolutionChangesBuilder() {
    }

    public static SolutionChangesBuilder create() {
        return new SolutionChangesBuilder();
    }

    public SolutionChangesBuilder withSolution(TaskAssigningSolution solution) {
        this.solution = solution;
        return this;
    }

    public SolutionChangesBuilder withTasks(List<TaskData> taskDataList) {
        this.taskDataList = taskDataList;
        return this;
    }

    public SolutionChangesBuilder withUserSystem(UserSystemService userSystemService) {
        this.userSystemService = userSystemService;
        return this;
    }

    public SolutionChangesBuilder withContext(SolverHandlerContext context) {
        this.context = context;
        return this;
    }

    public List<ProblemFactChange<TaskAssigningSolution>> build() {
        Map taskById = this.solution.getTaskList().stream().filter(ModelConstants.IS_NOT_DUMMY).collect(Collectors.toMap(AbstractPersistable::getId, Function.identity()));
        Map<String, org.kie.server.services.taskassigning.core.model.User> usersById = this.solution.getUserList().stream().collect(Collectors.toMap(org.kie.server.services.taskassigning.core.model.User::getEntityId, Function.identity()));
        ArrayList<AddTaskProblemFactChange> newTaskChanges = new ArrayList<AddTaskProblemFactChange>();
        ArrayList<ReleaseTaskProblemFactChange> releasedTasksChanges = new ArrayList<ReleaseTaskProblemFactChange>();
        ArrayList<RemoveTaskProblemFactChange> removedTaskChanges = new ArrayList<RemoveTaskProblemFactChange>();
        HashSet<Task> removedTasksSet = new HashSet<Task>();
        ArrayList<TaskPropertyChangeProblemFactChange> propertyChanges = new ArrayList<TaskPropertyChangeProblemFactChange>();
        HashMap<String, List<IndexedElement<AssignTaskProblemFactChange>>> changesByUserId = new HashMap<String, List<IndexedElement<AssignTaskProblemFactChange>>>();
        List<TaskData> filteredTaskDataList = this.taskDataList.stream().filter(taskData -> !this.context.isProcessedTaskChange(taskData.getTaskId(), taskData.getLastModificationDate())).collect(Collectors.toList());
        for (TaskData taskData2 : filteredTaskDataList) {
            Task task = (Task)taskById.remove(taskData2.getTaskId());
            if (task == null) {
                this.addNewTaskChanges(taskData2, usersById, newTaskChanges, changesByUserId);
                continue;
            }
            this.addTaskChanges(task, taskData2, usersById, releasedTasksChanges, removedTasksSet, propertyChanges, changesByUserId);
        }
        for (Task removedTask : removedTasksSet) {
            removedTaskChanges.add(new RemoveTaskProblemFactChange(removedTask));
        }
        ArrayList<ProblemFactChange<TaskAssigningSolution>> totalChanges = new ArrayList<ProblemFactChange<TaskAssigningSolution>>();
        totalChanges.addAll(removedTaskChanges);
        totalChanges.addAll(releasedTasksChanges);
        changesByUserId.values().forEach(userChanges -> userChanges.forEach(change -> totalChanges.add((ProblemFactChange<TaskAssigningSolution>)change.getElement())));
        totalChanges.addAll(propertyChanges);
        totalChanges.addAll(newTaskChanges);
        if (LOGGER.isTraceEnabled()) {
            if (!totalChanges.isEmpty()) {
                TraceHelper.traceProgrammedChanges(LOGGER, removedTaskChanges, releasedTasksChanges, changesByUserId, propertyChanges, newTaskChanges);
            } else {
                LOGGER.trace("No changes has been calculated.");
            }
        }
        this.applyWorkaroundForPLANNER241(this.solution, totalChanges);
        if (!totalChanges.isEmpty()) {
            totalChanges.add(0, (ProblemFactChange<TaskAssigningSolution>)((ProblemFactChange)scoreDirector -> this.context.setCurrentChangeSetId(this.context.nextChangeSetId())));
        }
        filteredTaskDataList.forEach(taskData -> this.context.setTaskChangeTime(taskData.getTaskId(), taskData.getLastModificationDate()));
        return totalChanges;
    }

    private void addNewTaskChanges(TaskData taskData, Map<String, org.kie.server.services.taskassigning.core.model.User> usersById, List<AddTaskProblemFactChange> newTaskChanges, Map<String, List<IndexedElement<AssignTaskProblemFactChange>>> changesByUserId) {
        Status taskDataStatus = StatusConverter.convertFromString((String)taskData.getStatus());
        switch (taskDataStatus) {
            case Ready: {
                Task newTask = TaskUtil.fromTaskData(taskData);
                newTaskChanges.add(new AddTaskProblemFactChange(newTask));
                break;
            }
            case Reserved: 
            case InProgress: 
            case Suspended: {
                if (taskData.getActualOwner() == null) break;
                Task newTask = TaskUtil.fromTaskData(taskData);
                org.kie.server.services.taskassigning.core.model.User user = this.getUser(usersById, taskData.getActualOwner());
                AssignTaskProblemFactChange change = new AssignTaskProblemFactChange(newTask, user, true);
                SolutionChangesBuilder.addChangeToUser(changesByUserId, change, user, -1, true);
                break;
            }
        }
    }

    private void addTaskChanges(Task task, TaskData taskData, Map<String, org.kie.server.services.taskassigning.core.model.User> usersById, List<ReleaseTaskProblemFactChange> releasedTasksChanges, Set<Task> removedTasksSet, List<TaskPropertyChangeProblemFactChange> propertyChanges, Map<String, List<IndexedElement<AssignTaskProblemFactChange>>> changesByUserId) {
        Status taskDataStatus = StatusConverter.convertFromString((String)taskData.getStatus());
        switch (taskDataStatus) {
            case Ready: {
                if (StatusConverter.convertToString((Status)Status.Ready).equals(task.getStatus())) break;
                releasedTasksChanges.add(new ReleaseTaskProblemFactChange(task));
                break;
            }
            case Reserved: 
            case InProgress: 
            case Suspended: {
                org.kie.server.services.taskassigning.core.model.User user;
                if (taskData.getActualOwner() == null) {
                    removedTasksSet.add(task);
                    break;
                }
                if (!taskData.getActualOwner().equals(task.getUser().getEntityId())) {
                    user = this.getUser(usersById, taskData.getActualOwner());
                    AssignTaskProblemFactChange change = new AssignTaskProblemFactChange(task, user, true);
                    SolutionChangesBuilder.addChangeToUser(changesByUserId, change, user, -1, true);
                    break;
                }
                if (taskData.getPlanningTask() != null && !taskData.getPlanningTask().getPublished().booleanValue() || task.isPinned()) break;
                user = this.getUser(usersById, taskData.getActualOwner());
                AssignTaskProblemFactChange change = new AssignTaskProblemFactChange(task, user, true);
                int index = taskData.getPlanningTask() != null ? taskData.getPlanningTask().getIndex() : -1;
                SolutionChangesBuilder.addChangeToUser(changesByUserId, change, user, index, true);
                break;
            }
            case Completed: 
            case Exited: 
            case Failed: 
            case Error: 
            case Obsolete: {
                removedTasksSet.add(task);
                break;
            }
        }
        if (!(removedTasksSet.contains(task) || taskData.getPriority().intValue() == task.getPriority() && taskData.getStatus().equals(task.getStatus()))) {
            TaskPropertyChangeProblemFactChange propertyChange = new TaskPropertyChangeProblemFactChange(task);
            if (taskData.getPriority().intValue() != task.getPriority()) {
                propertyChange.setPriority(taskData.getPriority());
            }
            if (!taskData.getStatus().equals(task.getStatus())) {
                propertyChange.setStatus(taskData.getStatus());
            }
            propertyChanges.add(propertyChange);
        }
    }

    private static void addChangeToUser(Map<String, List<IndexedElement<AssignTaskProblemFactChange>>> changesByUserId, AssignTaskProblemFactChange change, org.kie.server.services.taskassigning.core.model.User user, int index, boolean pinned) {
        List userChanges = changesByUserId.computeIfAbsent(user.getEntityId(), key -> new ArrayList());
        IndexedElement.addInOrder(userChanges, new IndexedElement<AssignTaskProblemFactChange>(change, index, pinned));
    }

    private org.kie.server.services.taskassigning.core.model.User getUser(Map<String, org.kie.server.services.taskassigning.core.model.User> usersById, String userId) {
        org.kie.server.services.taskassigning.core.model.User user = usersById.get(userId);
        if (user == null) {
            LOGGER.debug("User {} was not found in current solution, it'll we looked up in the external user system .", (Object)userId);
            User externalUser = this.userSystemService.findUser(userId);
            if (externalUser != null) {
                user = UserUtil.fromExternalUser(externalUser);
            } else {
                LOGGER.debug("User {} was not found in the external user system, it looks like it's a manual assignment from the tasks administration. It'll be added to the solution to respect the assignment.", (Object)userId);
                user = new org.kie.server.services.taskassigning.core.model.User((long)userId.hashCode(), userId);
            }
        }
        return user;
    }

    private void applyWorkaroundForPLANNER241(TaskAssigningSolution solution, List<ProblemFactChange<TaskAssigningSolution>> changes) {
        boolean hasDummyTask241 = solution.getTaskList().stream().anyMatch(task -> ModelConstants.DUMMY_TASK_PLANNER_241.getId().equals(task.getId()));
        if (!hasDummyTask241) {
            changes.add((ProblemFactChange<TaskAssigningSolution>)new AssignTaskProblemFactChange(ModelConstants.DUMMY_TASK_PLANNER_241, ModelConstants.PLANNING_USER));
        }
    }
}

