/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.services.taskassigning.planning;

import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.chrono.ChronoLocalDateTime;
import java.util.Deque;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.stream.Collectors;

public class SolverHandlerContext {
    private long changeSetIds;
    private long currentChangeSetId;
    private long lastProcessedChangeSetId = -1L;
    private LocalDateTime previousQueryTime;
    private Map<Long, LocalDateTime> taskChangeTimes = new HashMap<Long, LocalDateTime>();
    private Deque<LocalDateTime> queryTimes = new LinkedList<LocalDateTime>();
    private int queryTimesSize;
    private long queryMinimumDistance;

    public SolverHandlerContext(int queryTimesSize, long queryMinimumDistance) {
        this.queryTimesSize = queryTimesSize;
        this.queryMinimumDistance = queryMinimumDistance;
    }

    public long getCurrentChangeSetId() {
        return this.currentChangeSetId;
    }

    public void setCurrentChangeSetId(long currentChangeSetId) {
        this.currentChangeSetId = currentChangeSetId;
    }

    public long nextChangeSetId() {
        return ++this.changeSetIds;
    }

    public boolean isProcessedChangeSet(long changeSetId) {
        return changeSetId <= this.lastProcessedChangeSetId;
    }

    public void setProcessedChangeSet(long changeSetId) {
        this.lastProcessedChangeSetId = changeSetId;
    }

    public void clearProcessedChangeSet() {
        this.lastProcessedChangeSetId = -1L;
    }

    public void setTaskChangeTime(long taskId, LocalDateTime changeTime) {
        this.taskChangeTimes.put(taskId, changeTime);
    }

    public boolean isProcessedTaskChange(long taskId, LocalDateTime changeTime) {
        return changeTime.equals(this.taskChangeTimes.get(taskId));
    }

    public void clearTaskChangeTimes(LocalDateTime untilLocalDateTime) {
        if (untilLocalDateTime != null) {
            this.taskChangeTimes.entrySet().stream().filter(entry -> untilLocalDateTime.compareTo((ChronoLocalDateTime)entry.getValue()) > 0).map(Map.Entry::getKey).collect(Collectors.toList()).forEach(removableChange -> this.taskChangeTimes.remove(removableChange));
        }
    }

    public void clearTaskChangeTimes() {
        this.taskChangeTimes.clear();
    }

    public LocalDateTime getPreviousQueryTime() {
        return this.previousQueryTime;
    }

    public void setPreviousQueryTime(LocalDateTime previousQueryTime) {
        this.previousQueryTime = previousQueryTime;
    }

    public void resetQueryTimes(LocalDateTime startValue) {
        this.queryTimes.clear();
        for (int i = 0; i < this.queryTimesSize; ++i) {
            this.queryTimes.add(startValue);
        }
    }

    public LocalDateTime pollNextQueryTime() {
        return this.queryTimes.pollFirst();
    }

    public LocalDateTime pollLastQueryTime() {
        return this.queryTimes.pollLast();
    }

    public LocalDateTime peekLastQueryTime() {
        return this.queryTimes.peekLast();
    }

    public void addNextQueryTime(LocalDateTime nextQueryTime) {
        this.queryTimes.add(nextQueryTime);
    }

    public boolean hasMinimalDistance(LocalDateTime lastQueryTime, LocalDateTime nextQueryTime) {
        if (lastQueryTime == null || nextQueryTime == null) {
            return true;
        }
        long lastQueryTimeMillis = lastQueryTime.atZone(ZoneId.systemDefault()).toInstant().toEpochMilli();
        long nextQueryTimeMillis = nextQueryTime.atZone(ZoneId.systemDefault()).toInstant().toEpochMilli();
        return nextQueryTimeMillis - lastQueryTimeMillis > this.queryMinimumDistance;
    }
}

