/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.services.taskassigning.planning.util;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.function.Predicate;
import org.kie.server.services.taskassigning.core.model.Group;
import org.kie.server.services.taskassigning.core.model.Task;
import org.kie.server.services.taskassigning.planning.data.LabelValueExtractorRegistry;
import org.kie.server.services.taskassigning.user.system.api.User;

public class UserUtil {
    private UserUtil() {
    }

    public static org.kie.server.services.taskassigning.core.model.User fromExternalUser(User externalUser) {
        org.kie.server.services.taskassigning.core.model.User user = new org.kie.server.services.taskassigning.core.model.User((long)externalUser.getId().hashCode(), externalUser.getId());
        HashSet groups = new HashSet();
        user.setGroups(groups);
        if (externalUser.getGroups() != null) {
            externalUser.getGroups().forEach(externalGroup -> groups.add(new Group((long)externalGroup.getId().hashCode(), externalGroup.getId())));
        }
        LabelValueExtractorRegistry.getInstance().applyLabelValueExtractors(User.class, externalUser, (arg_0, arg_1) -> ((org.kie.server.services.taskassigning.core.model.User)user).setLabelValues(arg_0, arg_1));
        return user;
    }

    public static boolean isUser(String userType) {
        return "User".equals(userType);
    }

    public static List<Task> extractTasks(org.kie.server.services.taskassigning.core.model.User user, Predicate<Task> predicate) {
        Task nextTask;
        ArrayList<Task> result = new ArrayList<Task>();
        Task task = nextTask = user != null ? user.getNextTask() : null;
        while (nextTask != null) {
            if (predicate.test(nextTask)) {
                result.add(nextTask);
            }
            nextTask = nextTask.getNextTask();
        }
        return result;
    }
}

