/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.services.taskassigning.core.model.solver;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.kie.server.services.taskassigning.core.model.OrganizationalEntity;
import org.kie.server.services.taskassigning.core.model.Task;
import org.kie.server.services.taskassigning.core.model.TaskOrUser;
import org.kie.server.services.taskassigning.core.model.User;

public class TaskHelper {
    private TaskHelper() {
    }

    public static boolean isPotentialOwner(Task task, User user) {
        boolean directlyAssigned = task.getPotentialOwners().stream().filter(OrganizationalEntity::isUser).anyMatch(entity -> Objects.equals(entity.getEntityId(), user.getEntityId()));
        if (directlyAssigned) {
            return true;
        }
        Set acceptedGroupIds = task.getPotentialOwners().stream().filter(entity -> !entity.isUser()).map(OrganizationalEntity::getEntityId).collect(Collectors.toSet());
        return user.getGroups().stream().anyMatch(group -> acceptedGroupIds.contains(group.getEntityId()));
    }

    public static boolean hasAllLabels(Task task, User user, String labelName) {
        Set<Object> taskLabelValues = task.getLabelValues(labelName);
        if (taskLabelValues == null || taskLabelValues.isEmpty()) {
            return true;
        }
        Set<Object> userLabelValues = user.getLabelValues(labelName);
        return userLabelValues != null && userLabelValues.containsAll(taskLabelValues);
    }

    public static int countMatchingLabels(Task task, User user, String labelName) {
        Set<Object> taskLabelValues = task.getLabelValues(labelName);
        if (taskLabelValues == null || taskLabelValues.isEmpty()) {
            return 0;
        }
        Set<Object> userLabelValues = user.getLabelValues(labelName);
        if (userLabelValues == null) {
            return 0;
        }
        return Math.toIntExact(userLabelValues.stream().filter(taskLabelValues::contains).count());
    }

    public static List<Task> extractTaskList(TaskOrUser taskOrUser) {
        ArrayList<Task> result = new ArrayList<Task>();
        for (Task task = taskOrUser.getNextTask(); task != null; task = task.getNextTask()) {
            result.add(task);
        }
        return result;
    }
}

