/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.core.impl;

import java.util.List;
import java.util.function.Consumer;
import org.kie.dmn.api.core.DMNModel;
import org.kie.dmn.api.core.DMNResult;
import org.kie.dmn.api.core.ast.BusinessKnowledgeModelNode;
import org.kie.dmn.api.core.ast.DecisionNode;
import org.kie.dmn.api.core.ast.DecisionServiceNode;
import org.kie.dmn.api.core.event.BeforeEvaluateDecisionEvent;
import org.kie.dmn.api.core.event.DMNRuntimeEventListener;
import org.kie.dmn.api.core.event.DMNRuntimeEventManager;
import org.kie.dmn.core.impl.AfterEvaluateAllEventImpl;
import org.kie.dmn.core.impl.AfterEvaluateBKMEventImpl;
import org.kie.dmn.core.impl.AfterEvaluateContextEntryEventImpl;
import org.kie.dmn.core.impl.AfterEvaluateDecisionEventImpl;
import org.kie.dmn.core.impl.AfterEvaluateDecisionServiceEventImpl;
import org.kie.dmn.core.impl.AfterEvaluateDecisionTableEventImpl;
import org.kie.dmn.core.impl.AfterInvokeBKMEventImpl;
import org.kie.dmn.core.impl.BeforeEvaluateAllEventImpl;
import org.kie.dmn.core.impl.BeforeEvaluateBKMEventImpl;
import org.kie.dmn.core.impl.BeforeEvaluateContextEntryEventImpl;
import org.kie.dmn.core.impl.BeforeEvaluateDecisionEventImpl;
import org.kie.dmn.core.impl.BeforeEvaluateDecisionServiceEventImpl;
import org.kie.dmn.core.impl.BeforeEvaluateDecisionTableEventImpl;
import org.kie.dmn.core.impl.BeforeInvokeBKMEventImpl;
import org.kie.dmn.core.impl.DMNResultImpl;
import org.kie.dmn.core.impl.DMNRuntimeEventManagerImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DMNRuntimeEventManagerUtils {
    private static final Logger logger = LoggerFactory.getLogger(DMNRuntimeEventManagerUtils.class);

    public static BeforeEvaluateDecisionEvent fireBeforeEvaluateDecision(DMNRuntimeEventManager eventManager, DecisionNode decision, DMNResult result) {
        if (eventManager.hasListeners()) {
            BeforeEvaluateDecisionEventImpl event = new BeforeEvaluateDecisionEventImpl(decision, result);
            DMNRuntimeEventManagerUtils.notifyListeners(eventManager, l -> l.beforeEvaluateDecision(event));
            return event;
        }
        return null;
    }

    public static void fireAfterEvaluateDecision(DMNRuntimeEventManager eventManager, DecisionNode decision, DMNResult result, BeforeEvaluateDecisionEvent beforeEvaluateDecisionEvent) {
        if (eventManager.hasListeners()) {
            AfterEvaluateDecisionEventImpl event = new AfterEvaluateDecisionEventImpl(decision, result, beforeEvaluateDecisionEvent);
            DMNRuntimeEventManagerUtils.notifyListeners(eventManager, l -> l.afterEvaluateDecision(event));
        }
    }

    public static void fireBeforeEvaluateDecisionService(DMNRuntimeEventManager eventManager, DecisionServiceNode decision, DMNResult result) {
        if (eventManager.hasListeners()) {
            BeforeEvaluateDecisionServiceEventImpl event = new BeforeEvaluateDecisionServiceEventImpl(decision, result);
            DMNRuntimeEventManagerUtils.notifyListeners(eventManager, l -> l.beforeEvaluateDecisionService(event));
        }
    }

    public static void fireAfterEvaluateDecisionService(DMNRuntimeEventManager eventManager, DecisionServiceNode decision, DMNResult result) {
        if (eventManager.hasListeners()) {
            AfterEvaluateDecisionServiceEventImpl event = new AfterEvaluateDecisionServiceEventImpl(decision, result);
            DMNRuntimeEventManagerUtils.notifyListeners(eventManager, l -> l.afterEvaluateDecisionService(event));
        }
    }

    public static void fireBeforeEvaluateBKM(DMNRuntimeEventManager eventManager, BusinessKnowledgeModelNode bkm, DMNResult result) {
        if (eventManager.hasListeners()) {
            BeforeEvaluateBKMEventImpl event = new BeforeEvaluateBKMEventImpl(bkm, result);
            DMNRuntimeEventManagerUtils.notifyListeners(eventManager, l -> l.beforeEvaluateBKM(event));
        }
    }

    public static void fireAfterEvaluateBKM(DMNRuntimeEventManager eventManager, BusinessKnowledgeModelNode bkm, DMNResult result) {
        if (eventManager.hasListeners()) {
            AfterEvaluateBKMEventImpl event = new AfterEvaluateBKMEventImpl(bkm, result);
            DMNRuntimeEventManagerUtils.notifyListeners(eventManager, l -> l.afterEvaluateBKM(event));
        }
    }

    public static void fireBeforeEvaluateDecisionTable(DMNRuntimeEventManager eventManager, String nodeName, String dtName, DMNResult result) {
        if (eventManager.hasListeners()) {
            BeforeEvaluateDecisionTableEventImpl event = new BeforeEvaluateDecisionTableEventImpl(nodeName, dtName, result);
            DMNRuntimeEventManagerUtils.notifyListeners(eventManager, l -> l.beforeEvaluateDecisionTable(event));
        }
    }

    public static void fireAfterEvaluateDecisionTable(DMNRuntimeEventManager eventManager, String nodeName, String dtName, DMNResult result, List<Integer> matches, List<Integer> fired) {
        if (eventManager.hasListeners()) {
            AfterEvaluateDecisionTableEventImpl event = new AfterEvaluateDecisionTableEventImpl(nodeName, dtName, result, matches, fired);
            DMNRuntimeEventManagerUtils.notifyListeners(eventManager, l -> l.afterEvaluateDecisionTable(event));
        }
    }

    public static void fireBeforeEvaluateContextEntry(DMNRuntimeEventManager eventManager, String nodeName, String variableName, String variableId, String expressionId, DMNResult result) {
        if (eventManager.hasListeners()) {
            BeforeEvaluateContextEntryEventImpl event = new BeforeEvaluateContextEntryEventImpl(nodeName, variableName, variableId, expressionId, result);
            DMNRuntimeEventManagerUtils.notifyListeners(eventManager, l -> l.beforeEvaluateContextEntry(event));
        }
    }

    public static void fireAfterEvaluateContextEntry(DMNRuntimeEventManager eventManager, String nodeName, String variableName, String variableId, String expressionId, Object expressionResult, DMNResult result) {
        if (eventManager.hasListeners()) {
            AfterEvaluateContextEntryEventImpl event = new AfterEvaluateContextEntryEventImpl(nodeName, variableName, variableId, expressionId, expressionResult, result);
            DMNRuntimeEventManagerUtils.notifyListeners(eventManager, l -> l.afterEvaluateContextEntry(event));
        }
    }

    public static void fireBeforeInvokeBKM(DMNRuntimeEventManager eventManager, BusinessKnowledgeModelNode bkm, DMNResult result) {
        if (eventManager.hasListeners()) {
            BeforeInvokeBKMEventImpl event = new BeforeInvokeBKMEventImpl(bkm, result);
            DMNRuntimeEventManagerUtils.notifyListeners(eventManager, l -> l.beforeInvokeBKM(event));
        }
    }

    public static void fireAfterInvokeBKM(DMNRuntimeEventManager eventManager, BusinessKnowledgeModelNode bkm, DMNResult result) {
        if (eventManager.hasListeners()) {
            AfterInvokeBKMEventImpl event = new AfterInvokeBKMEventImpl(bkm, result);
            DMNRuntimeEventManagerUtils.notifyListeners(eventManager, l -> l.afterInvokeBKM(event));
        }
    }

    public static void fireBeforeEvaluateAll(DMNRuntimeEventManagerImpl eventManager, DMNModel model, DMNResultImpl result) {
        if (eventManager.hasListeners()) {
            BeforeEvaluateAllEventImpl event = new BeforeEvaluateAllEventImpl(model.getNamespace(), model.getName(), result);
            DMNRuntimeEventManagerUtils.notifyListeners(eventManager, l -> l.beforeEvaluateAll(event));
        }
    }

    public static void fireAfterEvaluateAll(DMNRuntimeEventManagerImpl eventManager, DMNModel model, DMNResultImpl result) {
        if (eventManager.hasListeners()) {
            AfterEvaluateAllEventImpl event = new AfterEvaluateAllEventImpl(model.getNamespace(), model.getName(), result);
            DMNRuntimeEventManagerUtils.notifyListeners(eventManager, l -> l.afterEvaluateAll(event));
        }
    }

    private static void notifyListeners(DMNRuntimeEventManager eventManager, Consumer<DMNRuntimeEventListener> consumer) {
        for (DMNRuntimeEventListener listener : eventManager.getListeners()) {
            try {
                consumer.accept(listener);
            }
            catch (Throwable t) {
                logger.error("Error notifying listener '" + listener + "'", t);
            }
        }
    }

    private DMNRuntimeEventManagerUtils() {
    }
}

