/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.services.prometheus;

import io.prometheus.client.Counter;
import io.prometheus.client.Gauge;
import io.prometheus.client.Summary;
import java.util.List;
import org.dashbuilder.dataset.DataSet;
import org.dashbuilder.dataset.DataSetLookup;
import org.dashbuilder.dataset.def.DataSetDef;
import org.dashbuilder.dataset.def.DataSetDefRegistry;
import org.dashbuilder.dataset.def.DataSetDefRegistryListener;
import org.dashbuilder.dataset.def.DataSetPostProcessor;
import org.dashbuilder.dataset.def.DataSetPreprocessor;
import org.kie.server.services.prometheus.PrometheusMetrics;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrometheusDataSetListener
implements DataSetDefRegistryListener,
DataSetPreprocessor,
DataSetPostProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(PrometheusDataSetListener.class);
    private static final String PROMETHEUS_META = "prometheus_start";
    protected static final Gauge numberOfRegisteredDataSet = (Gauge)((Gauge.Builder)((Gauge.Builder)((Gauge.Builder)Gauge.build().name("kie_server_data_set_registered_total")).help("Kie Server Data Set Registered")).labelNames(new String[]{"name", "uuid"})).register();
    protected static final Gauge numberOfRunningDataSetLookups = (Gauge)((Gauge.Builder)((Gauge.Builder)((Gauge.Builder)Gauge.build().name("kie_server_data_set_lookups_total")).help("Kie Server Data Set Running Lookups")).labelNames(new String[]{"uuid"})).register();
    protected static final Summary dataSetExecutionTime = (Summary)((Summary.Builder)((Summary.Builder)((Summary.Builder)Summary.build().name("kie_server_data_set_execution_time_seconds")).help("Kie Server Data Set Execution Time")).labelNames(new String[]{"uuid"})).register();
    protected static final Counter dataSetExecution = (Counter)((Counter.Builder)((Counter.Builder)((Counter.Builder)Counter.build().name("kie_server_data_set_execution_total")).help("Kie Server Data Set Execution")).labelNames(new String[]{"uuid"})).register();
    private DataSetDefRegistry dataSetDefRegistry;

    public PrometheusDataSetListener(DataSetDefRegistry dataSetDefRegistry) {
        this.dataSetDefRegistry = dataSetDefRegistry;
    }

    protected void init() {
        List dataSetDefs = this.dataSetDefRegistry.getDataSetDefs(false);
        dataSetDefs.forEach(dataSetDef -> this.onDataSetDefRegistered((DataSetDef)dataSetDef));
        LOGGER.debug("Loaded {} data sets", (Object)dataSetDefs.size());
    }

    public void onDataSetDefStale(DataSetDef dataSetDef) {
    }

    public void onDataSetDefModified(DataSetDef oldDef, DataSetDef newDef) {
        List dataSetDefPostProcessors;
        List dataSetDefPreProcessors = this.dataSetDefRegistry.getDataSetDefPreProcessors(newDef.getUUID());
        if (dataSetDefPreProcessors == null || !dataSetDefPreProcessors.stream().anyMatch(p -> p instanceof PrometheusDataSetListener)) {
            this.dataSetDefRegistry.registerPreprocessor(newDef.getUUID(), (DataSetPreprocessor)this);
            LOGGER.debug("Registered PreProcessor for data set: {}", (Object)newDef.getUUID());
        }
        if ((dataSetDefPostProcessors = this.dataSetDefRegistry.getDataSetDefPostProcessors(newDef.getUUID())) == null || !dataSetDefPostProcessors.stream().anyMatch(p -> p instanceof PrometheusDataSetListener)) {
            this.dataSetDefRegistry.registerPostProcessor(newDef.getUUID(), (DataSetPostProcessor)this);
            LOGGER.debug("Registered PostProcessor for data set: {}", (Object)newDef.getUUID());
        }
    }

    public void onDataSetDefRegistered(DataSetDef dataSetDef) {
        LOGGER.debug("On Data Set Def Registered: {}", (Object)dataSetDef.getUUID());
        ((Gauge.Child)numberOfRegisteredDataSet.labels(new String[]{dataSetDef.getName(), dataSetDef.getUUID()})).inc();
        this.dataSetDefRegistry.registerPreprocessor(dataSetDef.getUUID(), (DataSetPreprocessor)this);
        this.dataSetDefRegistry.registerPostProcessor(dataSetDef.getUUID(), (DataSetPostProcessor)this);
        LOGGER.debug("Registered Pre and Post processors for data set: {}", (Object)dataSetDef.getUUID());
    }

    public void onDataSetDefRemoved(DataSetDef dataSetDef) {
        LOGGER.debug("On Data Set Def Removed: {}", (Object)dataSetDef);
        ((Gauge.Child)numberOfRegisteredDataSet.labels(new String[]{dataSetDef.getName(), dataSetDef.getUUID()})).dec();
    }

    public void postProcess(DataSetLookup lookup, DataSet dataSet) {
        LOGGER.debug("On Data Set Post Process: {}", (Object)dataSet.getUUID());
        ((Gauge.Child)numberOfRunningDataSetLookups.labels(new String[]{dataSet.getUUID()})).dec();
        ((Counter.Child)dataSetExecution.labels(new String[]{dataSet.getUUID()})).inc();
        Long start = (Long)lookup.getMetadata(PROMETHEUS_META);
        if (start != null) {
            double duration = PrometheusMetrics.millisToSeconds(System.currentTimeMillis() - start);
            LOGGER.debug("Data Set query duration: {}s", (Object)duration);
            ((Summary.Child)dataSetExecutionTime.labels(new String[]{lookup.getDataSetUUID()})).observe(duration);
        }
    }

    public void preprocess(DataSetLookup lookup) {
        LOGGER.debug("On Data Set Pre Process: {}", (Object)lookup.getDataSetUUID());
        ((Gauge.Child)numberOfRunningDataSetLookups.labels(new String[]{lookup.getDataSetUUID()})).inc();
        lookup.setMetadata(PROMETHEUS_META, (Object)System.currentTimeMillis());
    }
}

