/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk;

import com.unboundid.ldap.sdk.Attribute;
import com.unboundid.ldap.sdk.CompactAttribute;
import com.unboundid.ldap.sdk.DN;
import com.unboundid.ldap.sdk.Entry;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.RDN;
import com.unboundid.util.ByteStringBuffer;
import com.unboundid.util.NotMutable;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.Validator;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.NOT_THREADSAFE)
public final class CompactEntry
implements Serializable {
    private static final long serialVersionUID = 8067151651120794058L;
    private final CompactAttribute[] attributes;
    private int hashCode;
    private final String dn;

    public CompactEntry(Entry entry) {
        Validator.ensureNotNull(entry);
        this.dn = entry.getDN();
        this.hashCode = -1;
        Collection<Attribute> attrs = entry.getAttributes();
        this.attributes = new CompactAttribute[attrs.size()];
        Iterator<Attribute> iterator = attrs.iterator();
        for (int i = 0; i < this.attributes.length; ++i) {
            this.attributes[i] = new CompactAttribute(iterator.next());
        }
    }

    public String getDN() {
        return this.dn;
    }

    public DN getParsedDN() throws LDAPException {
        return new DN(this.dn);
    }

    public RDN getRDN() throws LDAPException {
        return this.getParsedDN().getRDN();
    }

    public DN getParentDN() throws LDAPException {
        return this.getParsedDN().getParent();
    }

    public String getParentDNString() throws LDAPException {
        return this.getParsedDN().getParentString();
    }

    public boolean hasAttribute(String attributeName) {
        Validator.ensureNotNull(attributeName);
        for (CompactAttribute a : this.attributes) {
            if (!a.getName().equalsIgnoreCase(attributeName)) continue;
            return true;
        }
        return false;
    }

    public boolean hasAttribute(Attribute attribute) {
        Validator.ensureNotNull(attribute);
        for (CompactAttribute a : this.attributes) {
            if (!a.toAttribute().equals(attribute)) continue;
            return true;
        }
        return false;
    }

    public boolean hasAttributeValue(String attributeName, String attributeValue) {
        Validator.ensureNotNull(attributeName, attributeValue);
        for (CompactAttribute a : this.attributes) {
            if (!a.getName().equalsIgnoreCase(attributeName) || !a.toAttribute().hasValue(attributeValue)) continue;
            return true;
        }
        return false;
    }

    public boolean hasAttributeValue(String attributeName, byte[] attributeValue) {
        Validator.ensureNotNull(attributeName, attributeValue);
        for (CompactAttribute a : this.attributes) {
            if (!a.getName().equalsIgnoreCase(attributeName) || !a.toAttribute().hasValue(attributeValue)) continue;
            return true;
        }
        return false;
    }

    public boolean hasObjectClass(String objectClassName) {
        return this.hasAttributeValue("objectClass", objectClassName);
    }

    public Collection<Attribute> getAttributes() {
        ArrayList<Attribute> attrList = new ArrayList<Attribute>(this.attributes.length);
        for (CompactAttribute a : this.attributes) {
            attrList.add(a.toAttribute());
        }
        return Collections.unmodifiableCollection(attrList);
    }

    public Attribute getAttribute(String attributeName) {
        Validator.ensureNotNull(attributeName);
        for (CompactAttribute a : this.attributes) {
            if (!a.getName().equalsIgnoreCase(attributeName)) continue;
            return a.toAttribute();
        }
        return null;
    }

    public List<Attribute> getAttributesWithOptions(String baseName, Set<String> options) {
        return this.toEntry().getAttributesWithOptions(baseName, options);
    }

    public String getAttributeValue(String attributeName) {
        Validator.ensureNotNull(attributeName);
        for (CompactAttribute a : this.attributes) {
            if (!a.getName().equalsIgnoreCase(attributeName)) continue;
            String[] values = a.getStringValues();
            if (values.length > 0) {
                return values[0];
            }
            return null;
        }
        return null;
    }

    public byte[] getAttributeValueBytes(String attributeName) {
        Validator.ensureNotNull(attributeName);
        for (CompactAttribute a : this.attributes) {
            if (!a.getName().equalsIgnoreCase(attributeName)) continue;
            byte[][] values = a.getByteValues();
            if (values.length > 0) {
                return values[0];
            }
            return null;
        }
        return null;
    }

    public Boolean getAttributeValueAsBoolean(String attributeName) {
        Validator.ensureNotNull(attributeName);
        Attribute a = this.getAttribute(attributeName);
        if (a == null) {
            return null;
        }
        return a.getValueAsBoolean();
    }

    public Date getAttributeValueAsDate(String attributeName) {
        Validator.ensureNotNull(attributeName);
        Attribute a = this.getAttribute(attributeName);
        if (a == null) {
            return null;
        }
        return a.getValueAsDate();
    }

    public DN getAttributeValueAsDN(String attributeName) {
        Validator.ensureNotNull(attributeName);
        Attribute a = this.getAttribute(attributeName);
        if (a == null) {
            return null;
        }
        return a.getValueAsDN();
    }

    public Integer getAttributeValueAsInteger(String attributeName) {
        Validator.ensureNotNull(attributeName);
        Attribute a = this.getAttribute(attributeName);
        if (a == null) {
            return null;
        }
        return a.getValueAsInteger();
    }

    public Long getAttributeValueAsLong(String attributeName) {
        Validator.ensureNotNull(attributeName);
        Attribute a = this.getAttribute(attributeName);
        if (a == null) {
            return null;
        }
        return a.getValueAsLong();
    }

    public String[] getAttributeValues(String attributeName) {
        Validator.ensureNotNull(attributeName);
        for (CompactAttribute a : this.attributes) {
            if (!a.getName().equalsIgnoreCase(attributeName)) continue;
            return a.getStringValues();
        }
        return null;
    }

    public byte[][] getAttributeValueByteArrays(String attributeName) {
        Validator.ensureNotNull(attributeName);
        for (CompactAttribute a : this.attributes) {
            if (!a.getName().equalsIgnoreCase(attributeName)) continue;
            return a.getByteValues();
        }
        return null;
    }

    public Attribute getObjectClassAttribute() {
        return this.getAttribute("objectClass");
    }

    public String[] getObjectClassValues() {
        return this.getAttributeValues("objectClass");
    }

    public Entry toEntry() {
        Attribute[] attrs = new Attribute[this.attributes.length];
        for (int i = 0; i < this.attributes.length; ++i) {
            attrs[i] = this.attributes[i].toAttribute();
        }
        return new Entry(this.dn, attrs);
    }

    public int hashCode() {
        if (this.hashCode == -1) {
            this.hashCode = this.toEntry().hashCode();
        }
        return this.hashCode;
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof CompactEntry)) {
            return false;
        }
        return this.toEntry().equals(((CompactEntry)o).toEntry());
    }

    public String[] toLDIF() {
        return this.toLDIF(0);
    }

    public String[] toLDIF(int wrapColumn) {
        return this.toEntry().toLDIF(wrapColumn);
    }

    public void toLDIF(ByteStringBuffer buffer) {
        this.toLDIF(buffer, 0);
    }

    public void toLDIF(ByteStringBuffer buffer, int wrapColumn) {
        this.toEntry().toLDIF(buffer, wrapColumn);
    }

    public String toLDIFString() {
        StringBuilder buffer = new StringBuilder();
        this.toLDIFString(buffer, 0);
        return buffer.toString();
    }

    public String toLDIFString(int wrapColumn) {
        StringBuilder buffer = new StringBuilder();
        this.toLDIFString(buffer, wrapColumn);
        return buffer.toString();
    }

    public void toLDIFString(StringBuilder buffer) {
        this.toLDIFString(buffer, 0);
    }

    public void toLDIFString(StringBuilder buffer, int wrapColumn) {
        this.toEntry().toLDIFString(buffer, wrapColumn);
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        this.toString(buffer);
        return buffer.toString();
    }

    public void toString(StringBuilder buffer) {
        buffer.append("Entry(dn='");
        buffer.append(this.dn);
        buffer.append("', attributes={");
        for (int i = 0; i < this.attributes.length; ++i) {
            if (i > 0) {
                buffer.append(", ");
            }
            this.attributes[i].toAttribute().toString(buffer);
        }
        buffer.append("})");
    }
}

