/*
 * Copyright 2017 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package elemental2.dom;

import java.lang.String;
import jsinterop.annotations.JsPackage;
import jsinterop.annotations.JsType;

@JsType(isNative = true, namespace = JsPackage.GLOBAL)
public class ShadowRoot extends DocumentFragment {
  public Element activeElement;
  public boolean applyAuthorStyles;
  public Element host;
  public String innerHTML;
  public ShadowRoot olderShadowRoot;
  public boolean resetStyleInheritance;
  public StyleSheetList styleSheets;

  public native Element elementFromPoint(double x, double y);

  public native HTMLElement getElementById(String id);

  public native NodeList<Element> getElementsByClassName(String className);

  public native NodeList<Element> getElementsByTagName(String tagName);

  public native NodeList<Element> getElementsByTagNameNS(String namespace, String localName);

  public native Selection getSelection();
}
