/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.config.domain;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import org.drools.compiler.compiler.io.File;
import org.drools.compiler.compiler.io.FileSystemItem;
import org.drools.compiler.compiler.io.Folder;
import org.drools.compiler.compiler.io.memory.MemoryFileSystem;
import org.drools.compiler.kie.builder.impl.MemoryKieModule;
import org.drools.core.impl.InternalKieContainer;
import org.kie.api.builder.KieModule;
import org.kie.api.runtime.KieContainer;
import org.reflections.vfs.Vfs;

public class ReflectionsKieVfsUrlType
implements Vfs.UrlType {
    private final KieContainer kieContainer;

    public static void register(KieContainer kieContainer) {
        Vfs.addDefaultURLTypes((Vfs.UrlType)new ReflectionsKieVfsUrlType(kieContainer));
    }

    public ReflectionsKieVfsUrlType(KieContainer kieContainer) {
        this.kieContainer = kieContainer;
    }

    public boolean matches(URL url) {
        return url.getProtocol().equalsIgnoreCase("mfs");
    }

    public Vfs.Dir createDir(URL url) {
        KieModule kieModule = ((InternalKieContainer)this.kieContainer).getMainKieModule();
        if (!(kieModule instanceof MemoryKieModule)) {
            throw new IllegalStateException("The classpath url (" + url + ") has an mfs protocol but the kieModule (" + kieModule + ") is not an instance of " + MemoryKieModule.class.getSimpleName() + ".");
        }
        MemoryFileSystem memoryFileSystem = ((MemoryKieModule)kieModule).getMemoryFileSystem();
        Folder folder = memoryFileSystem.getFolder(url.toExternalForm().substring("mfs:/".length()));
        return new ReflectionsKieVfsDir(folder);
    }

    public static class ReflectionsKieVfsFile
    implements Vfs.File {
        private final File kieFile;

        public ReflectionsKieVfsFile(File kieFile) {
            this.kieFile = kieFile;
        }

        public String getName() {
            return this.kieFile.getName();
        }

        public String getRelativePath() {
            return this.kieFile.getPath().toPortableString();
        }

        public InputStream openInputStream() throws IOException {
            return this.kieFile.getContents();
        }
    }

    public static class ReflectionsKieVfsDir
    implements Vfs.Dir {
        private final Folder kieFolder;

        public ReflectionsKieVfsDir(Folder kieFolder) {
            this.kieFolder = kieFolder;
        }

        public String getPath() {
            return this.kieFolder.getPath().toPortableString();
        }

        public Iterable<Vfs.File> getFiles() {
            ArrayList<Vfs.File> vfsFileList = new ArrayList<Vfs.File>();
            ArrayDeque resourceDeque = new ArrayDeque();
            Collection mainMembers = this.kieFolder.getMembers();
            if (mainMembers != null) {
                resourceDeque.addAll(mainMembers);
            }
            while (!resourceDeque.isEmpty()) {
                FileSystemItem resource = (FileSystemItem)resourceDeque.pop();
                if (resource instanceof File) {
                    File file = (File)resource;
                    if (!file.getName().endsWith(".class")) continue;
                    vfsFileList.add(new ReflectionsKieVfsFile(file));
                    continue;
                }
                if (resource instanceof Folder) {
                    Collection members = ((Folder)resource).getMembers();
                    if (members == null) continue;
                    resourceDeque.addAll(members);
                    continue;
                }
                throw new IllegalStateException("Unsupported resource class (" + resource.getClass() + ") for resource (" + resource + ").");
            }
            return vfsFileList;
        }

        public void close() {
        }
    }
}

