/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.score.buildin.hardmediumsoft;

import java.util.Arrays;
import org.optaplanner.core.api.score.buildin.hardmediumsoft.HardMediumSoftScore;
import org.optaplanner.core.api.score.buildin.hardmediumsoft.HardMediumSoftScoreHolder;
import org.optaplanner.core.config.score.trend.InitializingScoreTrendLevel;
import org.optaplanner.core.impl.score.buildin.hardmediumsoft.HardMediumSoftScoreInliner;
import org.optaplanner.core.impl.score.definition.AbstractFeasibilityScoreDefinition;
import org.optaplanner.core.impl.score.inliner.ScoreInliner;
import org.optaplanner.core.impl.score.trend.InitializingScoreTrend;

public class HardMediumSoftScoreDefinition
extends AbstractFeasibilityScoreDefinition<HardMediumSoftScore> {
    public HardMediumSoftScoreDefinition() {
        super(new String[]{"hard score", "medium score", "soft score"});
    }

    @Override
    public int getLevelsSize() {
        return 3;
    }

    @Override
    public int getFeasibleLevelsSize() {
        return 1;
    }

    @Override
    public Class<HardMediumSoftScore> getScoreClass() {
        return HardMediumSoftScore.class;
    }

    @Override
    public HardMediumSoftScore getZeroScore() {
        return HardMediumSoftScore.ZERO;
    }

    @Override
    public HardMediumSoftScore getOneSoftestScore() {
        return HardMediumSoftScore.ONE_SOFT;
    }

    @Override
    public HardMediumSoftScore parseScore(String scoreString) {
        return HardMediumSoftScore.parseScore(scoreString);
    }

    @Override
    public HardMediumSoftScore fromLevelNumbers(int initScore, Number[] levelNumbers) {
        if (levelNumbers.length != this.getLevelsSize()) {
            throw new IllegalStateException("The levelNumbers (" + Arrays.toString(levelNumbers) + ")'s length (" + levelNumbers.length + ") must equal the levelSize (" + this.getLevelsSize() + ").");
        }
        return HardMediumSoftScore.ofUninitialized(initScore, (Integer)levelNumbers[0], (Integer)levelNumbers[1], (Integer)levelNumbers[2]);
    }

    @Override
    public ScoreInliner<HardMediumSoftScore> buildScoreInliner(boolean constraintMatchEnabled) {
        return new HardMediumSoftScoreInliner(constraintMatchEnabled);
    }

    public HardMediumSoftScoreHolder buildScoreHolder(boolean constraintMatchEnabled) {
        return new HardMediumSoftScoreHolder(constraintMatchEnabled);
    }

    @Override
    public HardMediumSoftScore buildOptimisticBound(InitializingScoreTrend initializingScoreTrend, HardMediumSoftScore score) {
        InitializingScoreTrendLevel[] trendLevels = initializingScoreTrend.getTrendLevels();
        return HardMediumSoftScore.ofUninitialized(0, trendLevels[0] == InitializingScoreTrendLevel.ONLY_DOWN ? score.getHardScore() : Integer.MAX_VALUE, trendLevels[1] == InitializingScoreTrendLevel.ONLY_DOWN ? score.getMediumScore() : Integer.MAX_VALUE, trendLevels[2] == InitializingScoreTrendLevel.ONLY_DOWN ? score.getSoftScore() : Integer.MAX_VALUE);
    }

    @Override
    public HardMediumSoftScore buildPessimisticBound(InitializingScoreTrend initializingScoreTrend, HardMediumSoftScore score) {
        InitializingScoreTrendLevel[] trendLevels = initializingScoreTrend.getTrendLevels();
        return HardMediumSoftScore.ofUninitialized(0, trendLevels[0] == InitializingScoreTrendLevel.ONLY_UP ? score.getHardScore() : Integer.MIN_VALUE, trendLevels[1] == InitializingScoreTrendLevel.ONLY_UP ? score.getMediumScore() : Integer.MIN_VALUE, trendLevels[2] == InitializingScoreTrendLevel.ONLY_UP ? score.getSoftScore() : Integer.MIN_VALUE);
    }

    @Override
    public HardMediumSoftScore divideBySanitizedDivisor(HardMediumSoftScore dividend, HardMediumSoftScore divisor) {
        int dividendInitScore = dividend.getInitScore();
        int divisorInitScore = HardMediumSoftScoreDefinition.sanitize(divisor.getInitScore());
        int dividendHardScore = dividend.getHardScore();
        int divisorHardScore = HardMediumSoftScoreDefinition.sanitize(divisor.getHardScore());
        int dividendMediumScore = dividend.getMediumScore();
        int divisorMediumScore = HardMediumSoftScoreDefinition.sanitize(divisor.getMediumScore());
        int dividendSoftScore = dividend.getSoftScore();
        int divisorSoftScore = HardMediumSoftScoreDefinition.sanitize(divisor.getSoftScore());
        return this.fromLevelNumbers(HardMediumSoftScoreDefinition.divide(dividendInitScore, divisorInitScore), new Number[]{HardMediumSoftScoreDefinition.divide(dividendHardScore, divisorHardScore), HardMediumSoftScoreDefinition.divide(dividendMediumScore, divisorMediumScore), HardMediumSoftScoreDefinition.divide(dividendSoftScore, divisorSoftScore)});
    }
}

