/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.score.stream.common;

import java.util.function.Function;
import org.optaplanner.core.api.domain.constraintweight.ConstraintConfiguration;
import org.optaplanner.core.api.domain.constraintweight.ConstraintConfigurationProvider;
import org.optaplanner.core.api.domain.constraintweight.ConstraintWeight;
import org.optaplanner.core.api.score.Score;
import org.optaplanner.core.api.score.stream.Constraint;
import org.optaplanner.core.api.score.stream.ConstraintStream;
import org.optaplanner.core.impl.domain.constraintweight.descriptor.ConstraintConfigurationDescriptor;
import org.optaplanner.core.impl.domain.constraintweight.descriptor.ConstraintWeightDescriptor;
import org.optaplanner.core.impl.domain.solution.descriptor.SolutionDescriptor;
import org.optaplanner.core.impl.score.stream.InnerConstraintFactory;
import org.optaplanner.core.impl.score.stream.common.ScoreImpactType;

public abstract class AbstractConstraintStream<Solution_>
implements ConstraintStream {
    protected Function<Solution_, Score<?>> buildConstraintWeightExtractor(String constraintPackage, String constraintName) {
        AbstractConstraintStream.validateConstraintId(constraintPackage, constraintName);
        SolutionDescriptor solutionDescriptor = this.getConstraintFactory().getSolutionDescriptor();
        ConstraintConfigurationDescriptor configurationDescriptor = solutionDescriptor.getConstraintConfigurationDescriptor();
        if (configurationDescriptor == null) {
            throw new IllegalStateException("The constraint (" + constraintName + ") of package (" + constraintPackage + ") does not hard-code a constraint weight and there is no @" + ConstraintConfigurationProvider.class.getSimpleName() + " on the solution class (" + solutionDescriptor.getSolutionClass() + ").\nMaybe add a @" + ConstraintConfiguration.class.getSimpleName() + " class or use " + ConstraintStream.class.getSimpleName() + ".penalize()/reward() instead of penalizeConfigurable()/rewardConfigurable.");
        }
        ConstraintWeightDescriptor weightDescriptor = configurationDescriptor.findConstraintWeightDescriptor(constraintPackage, constraintName);
        if (weightDescriptor == null) {
            throw new IllegalStateException("The constraint (" + constraintName + ") of package (" + constraintPackage + ") does not hard-code a constraint weight and there is no such @" + ConstraintWeight.class.getSimpleName() + " on the constraintConfigurationClass (" + configurationDescriptor.getConstraintConfigurationClass() + ").\nMaybe there is a typo in the constraintPackage or constraintName of one of the @" + ConstraintWeight.class.getSimpleName() + " members.\nMaybe add a @" + ConstraintWeight.class.getSimpleName() + " member for it.");
        }
        return weightDescriptor.createExtractor();
    }

    protected Function<Solution_, Score<?>> buildConstraintWeightExtractor(String constraintPackage, String constraintName, Score<?> constraintWeight) {
        AbstractConstraintStream.validateConstraintId(constraintPackage, constraintName);
        this.getConstraintFactory().getSolutionDescriptor().validateConstraintWeight(constraintPackage, constraintName, constraintWeight);
        return solution -> constraintWeight;
    }

    private static void validateConstraintId(String constraintPackage, String constraintName) {
        if (constraintPackage == null) {
            throw new IllegalStateException("The constraint (" + constraintName + ") cannot have a null package (" + constraintPackage + ").");
        }
        if (constraintName == null) {
            throw new IllegalStateException("The constraint of package (" + constraintPackage + ") cannot have a null name (" + constraintName + ").");
        }
    }

    @Override
    public abstract InnerConstraintFactory<Solution_> getConstraintFactory();

    @Override
    public final Constraint penalize(String constraintPackage, String constraintName, Score<?> constraintWeight) {
        return this.impactScore(constraintPackage, constraintName, constraintWeight, ScoreImpactType.PENALTY);
    }

    @Override
    public final Constraint penalizeConfigurable(String constraintPackage, String constraintName) {
        return this.impactScoreConfigurable(constraintPackage, constraintName, ScoreImpactType.PENALTY);
    }

    @Override
    public final Constraint reward(String constraintPackage, String constraintName, Score<?> constraintWeight) {
        return this.impactScore(constraintPackage, constraintName, constraintWeight, ScoreImpactType.REWARD);
    }

    @Override
    public final Constraint rewardConfigurable(String constraintPackage, String constraintName) {
        return this.impactScoreConfigurable(constraintPackage, constraintName, ScoreImpactType.REWARD);
    }

    @Override
    public final Constraint impact(String constraintPackage, String constraintName, Score<?> constraintWeight) {
        return this.impactScore(constraintPackage, constraintName, constraintWeight, ScoreImpactType.MIXED);
    }

    protected abstract Constraint impactScore(String var1, String var2, Score<?> var3, ScoreImpactType var4);

    protected abstract Constraint impactScoreConfigurable(String var1, String var2, ScoreImpactType var3);
}

