/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.test.api.score.stream;

import java.util.Objects;
import java.util.function.BiFunction;
import org.optaplanner.core.api.score.stream.Constraint;
import org.optaplanner.core.api.score.stream.ConstraintFactory;
import org.optaplanner.core.api.score.stream.ConstraintProvider;
import org.optaplanner.core.api.score.stream.ConstraintStreamImplType;
import org.optaplanner.core.impl.domain.solution.descriptor.SolutionDescriptor;
import org.optaplanner.test.api.score.stream.ConstraintProviderVerifier;
import org.optaplanner.test.api.score.stream.SingleConstraintVerifier;

public final class ConstraintVerifier<ConstraintProvider_ extends ConstraintProvider, Solution_> {
    private final ConstraintProvider_ constraintProvider;
    private final SolutionDescriptor<Solution_> solutionDescriptor;
    private ConstraintStreamImplType constraintStreamImplType = ConstraintStreamImplType.DROOLS;

    private ConstraintVerifier(ConstraintProvider_ constraintProvider, SolutionDescriptor<Solution_> solutionDescriptor) {
        this.constraintProvider = constraintProvider;
        this.solutionDescriptor = solutionDescriptor;
    }

    public static <ConstraintProvider_ extends ConstraintProvider, Solution_> ConstraintVerifier<ConstraintProvider_, Solution_> build(ConstraintProvider_ constraintProvider, Class<Solution_> planningSolutionClass, Class<?> ... entityClasses) {
        Objects.requireNonNull(constraintProvider);
        SolutionDescriptor solutionDescriptor = SolutionDescriptor.buildSolutionDescriptor(Objects.requireNonNull(planningSolutionClass), (Class[])entityClasses);
        return new ConstraintVerifier<ConstraintProvider_, Solution_>(constraintProvider, solutionDescriptor);
    }

    protected SolutionDescriptor<Solution_> getSolutionDescriptor() {
        return this.solutionDescriptor;
    }

    public ConstraintVerifier<ConstraintProvider_, Solution_> withConstraintStreamImplType(ConstraintStreamImplType constraintStreamImplType) {
        this.constraintStreamImplType = constraintStreamImplType;
        return this;
    }

    public SingleConstraintVerifier<Solution_> verifyThat(BiFunction<ConstraintProvider_, ConstraintFactory, Constraint> constraintFunction) {
        Objects.requireNonNull(constraintFunction);
        return new SingleConstraintVerifier(this, constraintFactory -> (Constraint)constraintFunction.apply(this.constraintProvider, (ConstraintFactory)constraintFactory), this.constraintStreamImplType);
    }

    public ConstraintProviderVerifier<Solution_> verifyThat() {
        return new ConstraintProviderVerifier(this, (ConstraintProvider)this.constraintProvider, this.constraintStreamImplType);
    }
}

