/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.score.buildin.simpledouble;

import java.util.Arrays;
import org.optaplanner.core.api.score.buildin.simpledouble.SimpleDoubleScore;
import org.optaplanner.core.api.score.buildin.simpledouble.SimpleDoubleScoreHolder;
import org.optaplanner.core.config.score.trend.InitializingScoreTrendLevel;
import org.optaplanner.core.impl.score.definition.AbstractScoreDefinition;
import org.optaplanner.core.impl.score.inliner.ScoreInliner;
import org.optaplanner.core.impl.score.trend.InitializingScoreTrend;

public class SimpleDoubleScoreDefinition
extends AbstractScoreDefinition<SimpleDoubleScore> {
    public SimpleDoubleScoreDefinition() {
        super(new String[]{"score"});
    }

    @Override
    public int getLevelsSize() {
        return 1;
    }

    @Override
    public Class<SimpleDoubleScore> getScoreClass() {
        return SimpleDoubleScore.class;
    }

    @Override
    public SimpleDoubleScore getZeroScore() {
        return SimpleDoubleScore.ZERO;
    }

    @Override
    public SimpleDoubleScore getOneSoftestScore() {
        return SimpleDoubleScore.ONE;
    }

    @Override
    public SimpleDoubleScore parseScore(String scoreString) {
        return SimpleDoubleScore.parseScore(scoreString);
    }

    @Override
    public SimpleDoubleScore fromLevelNumbers(int initScore, Number[] levelNumbers) {
        if (levelNumbers.length != this.getLevelsSize()) {
            throw new IllegalStateException("The levelNumbers (" + Arrays.toString(levelNumbers) + ")'s length (" + levelNumbers.length + ") must equal the levelSize (" + this.getLevelsSize() + ").");
        }
        return SimpleDoubleScore.ofUninitialized(initScore, (Double)levelNumbers[0]);
    }

    @Override
    public ScoreInliner<SimpleDoubleScore> buildScoreInliner(boolean constraintMatchEnabled) {
        throw new IllegalStateException("ConstraintStreams don't support a " + SimpleDoubleScore.class.getSimpleName() + ") because it is error prone.");
    }

    public SimpleDoubleScoreHolder buildScoreHolder(boolean constraintMatchEnabled) {
        return new SimpleDoubleScoreHolder(constraintMatchEnabled);
    }

    @Override
    public SimpleDoubleScore buildOptimisticBound(InitializingScoreTrend initializingScoreTrend, SimpleDoubleScore score) {
        InitializingScoreTrendLevel[] trendLevels = initializingScoreTrend.getTrendLevels();
        return SimpleDoubleScore.ofUninitialized(0, trendLevels[0] == InitializingScoreTrendLevel.ONLY_DOWN ? score.getScore() : Double.POSITIVE_INFINITY);
    }

    @Override
    public SimpleDoubleScore buildPessimisticBound(InitializingScoreTrend initializingScoreTrend, SimpleDoubleScore score) {
        InitializingScoreTrendLevel[] trendLevels = initializingScoreTrend.getTrendLevels();
        return SimpleDoubleScore.ofUninitialized(0, trendLevels[0] == InitializingScoreTrendLevel.ONLY_UP ? score.getScore() : Double.NEGATIVE_INFINITY);
    }

    @Override
    public SimpleDoubleScore divideBySanitizedDivisor(SimpleDoubleScore dividend, SimpleDoubleScore divisor) {
        int dividendInitScore = dividend.getInitScore();
        int divisorInitScore = SimpleDoubleScoreDefinition.sanitize(divisor.getInitScore());
        double dividendScore = dividend.getScore();
        double divisorScore = SimpleDoubleScoreDefinition.sanitize(divisor.getScore());
        return this.fromLevelNumbers(SimpleDoubleScoreDefinition.divide(dividendInitScore, divisorInitScore), new Number[]{SimpleDoubleScoreDefinition.divide(dividendScore, divisorScore)});
    }
}

