/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.services.taskassigning.planning;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.commons.lang3.StringUtils;
import org.kie.server.api.exception.KieServicesException;
import org.kie.server.api.model.KieContainerResource;
import org.kie.server.api.model.KieContainerStatus;
import org.kie.server.api.model.KieServiceResponse;
import org.kie.server.api.model.Message;
import org.kie.server.api.model.ReleaseId;
import org.kie.server.api.model.ServiceResponse;
import org.kie.server.api.model.Severity;
import org.kie.server.client.TaskAssigningRuntimeClient;
import org.kie.server.client.TaskAssigningRuntimeClientFactory;
import org.kie.server.services.api.KieContainerInstance;
import org.kie.server.services.api.KieServer;
import org.kie.server.services.api.KieServerExtension;
import org.kie.server.services.api.KieServerRegistry;
import org.kie.server.services.api.SupportedTransports;
import org.kie.server.services.impl.KieContainerInstanceImpl;
import org.kie.server.services.impl.KieServerImpl;
import org.kie.server.services.taskassigning.core.model.TaskAssigningSolution;
import org.kie.server.services.taskassigning.planning.SolverBuilder;
import org.kie.server.services.taskassigning.planning.SolverDef;
import org.kie.server.services.taskassigning.planning.TaskAssigningPlanningKieServerExtensionMessages;
import org.kie.server.services.taskassigning.planning.TaskAssigningRuntimeDelegate;
import org.kie.server.services.taskassigning.planning.TaskAssigningService;
import org.kie.server.services.taskassigning.planning.TaskAssigningValidationException;
import org.kie.server.services.taskassigning.planning.UserSystemServiceLoader;
import org.kie.server.services.taskassigning.planning.data.LabelValueExtractorRegistry;
import org.kie.server.services.taskassigning.planning.util.PropertyUtil;
import org.kie.server.services.taskassigning.user.system.api.UserSystemService;
import org.optaplanner.core.api.solver.Solver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskAssigningPlanningKieServerExtension
implements KieServerExtension {
    private static final Logger LOGGER = LoggerFactory.getLogger(TaskAssigningPlanningKieServerExtension.class);
    static final String CAPABILITY_TASK_ASSIGNING_PLANNING = "TaskAssigningPlanning";
    static final String EXTENSION_NAME = "TaskAssigningPlanning";
    static final int EXTENSION_START_ORDER = 1001;
    private static final String DEFAULT_SOLVER_CONFIG = "org/kie/server/services/taskassigning/solver/taskAssigningDefaultSolverConfig.xml";
    private KieServer kieServer;
    private KieServerRegistry registry;
    private final List<Object> services = new ArrayList<Object>();
    private boolean initialized = false;
    private TaskAssigningRuntimeClient runtimeClient;
    private UserSystemService userSystemService;
    private TaskAssigningService taskAssigningService;
    private ExecutorService executorService;
    private SolverDef solverDef;
    private String userSystemName;
    private KieContainerResource userSystemContainer = null;
    private List<Message> permanentErrors = new ArrayList<Message>();

    public boolean isActive() {
        return Boolean.FALSE.toString().equals(System.getProperty("org.kie.server.taskAssigning.planning.ext.disabled", Boolean.TRUE.toString()));
    }

    public void init(KieServerImpl kieServer, KieServerRegistry registry) {
        LOGGER.debug("Initializing TaskAssigningPlanning extension.");
        this.kieServer = kieServer;
        this.registry = registry;
        KieServerExtension jbpmExtension = registry.getServerExtension("jBPM");
        if (jbpmExtension != null) {
            String msg = String.format("It's was detected that the following extensions %s are running in current server, but it's not recommended to run them on the same server instance as the TaskAssigningPlanning sever.", "jBPM");
            LOGGER.warn(msg);
            kieServer.addServerMessage(new Message(Severity.WARN, TaskAssigningPlanningKieServerExtensionMessages.addExtensionMessagePrefix(msg)));
        }
        this.initRuntimeClient();
        try {
            this.validateAndSetSolverConfiguration();
        }
        catch (TaskAssigningValidationException e) {
            throw new KieServicesException(String.format("Planner solver is not properly configured, error: %s", e.getMessage()), (Throwable)e);
        }
        try {
            this.validateAndSetUserSystemServiceConfiguration();
        }
        catch (TaskAssigningValidationException e) {
            throw new KieServicesException(String.format("User system service is not properly configured, error: %s", e.getMessage()), (Throwable)e);
        }
        this.executorService = Executors.newFixedThreadPool(3);
        this.taskAssigningService = this.createTaskAssigningService();
        this.services.add(this.taskAssigningService);
        this.initialized = true;
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public void createContainer(String id, KieContainerInstance kieContainerInstance, Map<String, Object> parameters) {
    }

    public void updateContainer(String id, KieContainerInstance kieContainerInstance, Map<String, Object> parameters) {
    }

    public boolean isUpdateContainerAllowed(String id, KieContainerInstance kieContainerInstance, Map<String, Object> parameters) {
        return true;
    }

    public void disposeContainer(String id, KieContainerInstance kieContainerInstance, Map<String, Object> parameters) {
    }

    public List<Object> getAppComponents(SupportedTransports type) {
        return new ArrayList<Object>();
    }

    public <T> T getAppComponents(Class<T> serviceType) {
        if (serviceType.isAssignableFrom(this.taskAssigningService.getClass())) {
            return (T)this.taskAssigningService;
        }
        return null;
    }

    public String getImplementedCapability() {
        return "TaskAssigningPlanning";
    }

    public List<Object> getServices() {
        return this.services;
    }

    public String getExtensionName() {
        return "TaskAssigningPlanning";
    }

    public Integer getStartOrder() {
        return 1001;
    }

    public String toString() {
        return "TaskAssigningPlanning KIE Server extension";
    }

    public void serverStarted() {
        if (this.initialized) {
            if (!this.initSolverRuntime()) {
                return;
            }
            if (!this.initUserSystemService()) {
                return;
            }
            this.taskAssigningService.setExecutorService(this.executorService);
            this.taskAssigningService.setDelegate(new TaskAssigningRuntimeDelegate(this.getRuntimeClient()));
            this.taskAssigningService.setUserSystemService(this.getUserSystemService());
            this.taskAssigningService.start(this.solverDef, this.registry);
        }
    }

    public void destroy(KieServerImpl kieServer, KieServerRegistry registry) {
        LOGGER.debug("Destroying TaskAssigningPlanning extension.");
        if (this.initialized) {
            this.taskAssigningService.destroy();
        }
    }

    public List<Message> healthCheck(boolean report) {
        List messages = super.healthCheck(report);
        if (!this.permanentErrors.isEmpty()) {
            messages.addAll(this.permanentErrors);
        } else if (report) {
            messages.add(new Message(Severity.INFO, "TaskAssigningPlanning is alive"));
        }
        return messages;
    }

    private SolverDef getSolverDef() {
        String containerId = PropertyUtil.readSystemProperty("org.kie.server.taskAssigning.solver.container.id", null, value -> value);
        String groupId = PropertyUtil.readSystemProperty("org.kie.server.taskAssigning.solver.container.groupId", null, value -> value);
        String artifactId = PropertyUtil.readSystemProperty("org.kie.server.taskAssigning.solver.container.artifactId", null, value -> value);
        String version = PropertyUtil.readSystemProperty("org.kie.server.taskAssigning.solver.container.version", null, value -> value);
        String solverConfigResource = PropertyUtil.readSystemProperty("org.kie.server.taskAssigning.solver.configResource", DEFAULT_SOLVER_CONFIG, value -> value);
        return new SolverDef(containerId, groupId, artifactId, version, solverConfigResource);
    }

    TaskAssigningService createTaskAssigningService() {
        return new TaskAssigningService();
    }

    private UserSystemService getUserSystemService() {
        return this.userSystemService;
    }

    private TaskAssigningRuntimeClient getRuntimeClient() {
        return this.runtimeClient;
    }

    private void validateAndSetSolverConfiguration() throws TaskAssigningValidationException {
        this.solverDef = this.getSolverDef();
        if (StringUtils.isEmpty((CharSequence)this.solverDef.getSolverConfigResource())) {
            throw new TaskAssigningValidationException("No solverConfigResource has been configured for starting the task assigning solver. TaskAssigningPlanning won't operate properly");
        }
        if (!StringUtils.isEmpty((CharSequence)this.solverDef.getContainerId())) {
            KieContainerResource resource = new KieContainerResource(this.solverDef.getContainerId(), new ReleaseId(this.solverDef.getGroupId(), this.solverDef.getArtifactId(), this.solverDef.getVersion()));
            this.validateContainerRequiredParams(resource);
        }
    }

    private boolean initSolverRuntime() {
        if (!StringUtils.isEmpty((CharSequence)this.solverDef.getContainerId())) {
            KieContainerResource resource = new KieContainerResource(this.solverDef.getContainerId(), new ReleaseId(this.solverDef.getGroupId(), this.solverDef.getArtifactId(), this.solverDef.getVersion()));
            KieContainerInstanceImpl container = this.prepareContainer(resource);
            if (container == null) {
                String msg = String.format("Planner container %s is not available. TaskAssigningPlanning won't operate properly", this.solverDef.getContainerId());
                LOGGER.error(msg);
                this.registerMessage(Severity.ERROR, msg);
                return false;
            }
            this.registerExtractors(container);
        }
        try {
            this.createSolver(this.registry, this.solverDef);
        }
        catch (Exception e) {
            String msg = String.format("An error was produced during solver instantiation check. It was not possible to create a solver for the provided configuration, error: %s. TaskAssigningPlanning won't operate properly", e.getMessage());
            LOGGER.error(msg, (Throwable)e);
            this.registerMessage(Severity.ERROR, msg);
            return false;
        }
        return true;
    }

    Solver<TaskAssigningSolution> createSolver(KieServerRegistry registry, SolverDef solverDef) {
        return SolverBuilder.create().registry(registry).solverDef(solverDef).build();
    }

    void registerExtractors(KieContainerInstanceImpl container) {
        LabelValueExtractorRegistry.getInstance().registerExtractors(container.getKieContainer().getClassLoader());
    }

    private void validateAndSetUserSystemServiceConfiguration() throws TaskAssigningValidationException {
        this.userSystemName = PropertyUtil.readSystemProperty("org.kie.server.taskAssigning.userSystem.name", null, value -> value);
        if (StringUtils.isEmpty((CharSequence)this.userSystemName)) {
            String msg = String.format("No user system service name has been configured. TaskAssigningPlanning won't operate properly. Please use the property %s to configure it", "org.kie.server.taskAssigning.userSystem.name");
            throw new TaskAssigningValidationException(msg);
        }
        String containerId = PropertyUtil.readSystemProperty("org.kie.server.taskAssigning.userSystem.container.id", null, value -> value);
        if (!StringUtils.isEmpty((CharSequence)containerId)) {
            String groupId = PropertyUtil.readSystemProperty("org.kie.server.taskAssigning.userSystem.container.groupId", null, value -> value);
            String artifactId = PropertyUtil.readSystemProperty("org.kie.server.taskAssigning.userSystem.container.artifactId", null, value -> value);
            String version = PropertyUtil.readSystemProperty("org.kie.server.taskAssigning.userSystem.container.version", null, value -> value);
            this.userSystemContainer = new KieContainerResource(containerId, new ReleaseId(groupId, artifactId, version));
            this.validateContainerRequiredParams(this.userSystemContainer);
        }
    }

    private boolean initUserSystemService() {
        ClassLoader classLoader;
        if (this.userSystemContainer != null) {
            LOGGER.debug("User system service {} will be loaded from container {} class loader", (Object)this.userSystemName, (Object)this.userSystemContainer.getContainerId());
            KieContainerInstanceImpl container = this.prepareContainer(this.userSystemContainer);
            if (container == null) {
                String msg = String.format("User system service container %s is not available. TaskAssigningPlanning won't operate properly", this.userSystemContainer.getContainerId());
                LOGGER.error(msg);
                this.registerMessage(Severity.ERROR, msg);
                return false;
            }
            classLoader = container.getKieContainer().getClassLoader();
            this.registerExtractors(container);
        } else {
            LOGGER.debug("User system service {} will be loaded from application class loader", (Object)this.userSystemName);
            classLoader = this.getClass().getClassLoader();
        }
        this.userSystemService = this.lookupUserSystem(this.userSystemName, classLoader);
        if (this.userSystemService == null) {
            String msg = String.format("User system service %s was not found. TaskAssigningPlanning won't operate properly", this.userSystemName);
            LOGGER.error(msg);
            this.registerMessage(Severity.ERROR, msg);
            return false;
        }
        try {
            this.userSystemService.start();
        }
        catch (Exception e) {
            String msg = String.format("User system service %s initialization failed, error: %s. TaskAssigningPlanning won't operate properly", this.userSystemName, e.getMessage());
            LOGGER.error(msg, (Throwable)e);
            this.registerMessage(Severity.ERROR, msg);
            return false;
        }
        try {
            this.userSystemService.test();
            LOGGER.debug("User system service {} test check was successful.", (Object)this.userSystemName);
        }
        catch (Exception e) {
            LOGGER.warn("User system service {} test check failed, but TaskAssigningPlanning startup procedure will continue. error: ", (Object)e.getMessage());
        }
        return true;
    }

    UserSystemService lookupUserSystem(String userSystemName, ClassLoader classLoader) {
        Map<String, UserSystemService> userServices = UserSystemServiceLoader.loadServices(classLoader);
        return userServices.get(userSystemName);
    }

    private void initRuntimeClient() {
        String url = PropertyUtil.readSystemProperty("org.kie.server.taskAssigning.processRuntime.url", "http://localhost:8080/kie-server/services/rest/server", value -> value);
        String user = PropertyUtil.readSystemProperty("org.kie.server.taskAssigning.processRuntime.user", "wbadmin", value -> value);
        String pwd = PropertyUtil.readSystemProperty("org.kie.server.taskAssigning.processRuntime.pwd", null, value -> value);
        long timeout = PropertyUtil.readSystemProperty("org.kie.server.taskAssigning.processRuntime.timeout", 90000L, Long::parseLong);
        this.runtimeClient = this.createRuntimeClient(url, user, pwd, timeout);
    }

    TaskAssigningRuntimeClient createRuntimeClient(String url, String user, String pwd, long timeout) {
        return TaskAssigningRuntimeClientFactory.newRuntimeClient((String)url, (String)user, (String)pwd, (long)timeout);
    }

    private void validateContainerRequiredParams(KieContainerResource resource) throws TaskAssigningValidationException {
        String containerId = resource.getContainerId();
        String groupId = resource.getReleaseId().getGroupId();
        String artifactId = resource.getReleaseId().getArtifactId();
        String version = resource.getReleaseId().getVersion();
        if (StringUtils.isEmpty((CharSequence)containerId) || StringUtils.isEmpty((CharSequence)artifactId) || StringUtils.isEmpty((CharSequence)groupId) || StringUtils.isEmpty((CharSequence)version)) {
            throw new TaskAssigningValidationException(String.format("Required parameters for container configuration are missing. containerId: %s, groupId: %s, artifactId: %s, version: %s", containerId, groupId, artifactId, version));
        }
    }

    private KieContainerInstanceImpl prepareContainer(KieContainerResource resource) {
        ServiceResponse response;
        KieContainerInstanceImpl container = this.registry.getContainer(resource.getContainerId());
        if (container == null) {
            LOGGER.debug("Container {} is not available in current server. It'll be created now.", (Object)resource.getContainerId());
            try {
                response = this.kieServer.createContainer(resource.getContainerId(), resource);
                if (response.getType() == KieServiceResponse.ResponseType.FAILURE) {
                    String msg = String.format("Container creation failed for containerId: %s, error: %s", resource.getContainerId(), response.getMsg());
                    LOGGER.error(msg);
                    this.registerMessage(Severity.ERROR, msg);
                    return null;
                }
                container = this.registry.getContainer(resource.getContainerId());
                if (container == null) {
                    String msg = String.format("It was not possible get access to containerId: %s TaskAssigningPlanning won't operate properly", resource.getContainerId());
                    LOGGER.error(msg);
                    this.registerMessage(Severity.ERROR, msg);
                    return null;
                }
            }
            catch (Exception e) {
                String msg = String.format("Container creation failed for containerId: %s, error: %s", resource.getContainerId(), e.getMessage());
                LOGGER.error(msg, (Throwable)e);
                this.registerMessage(Severity.ERROR, msg);
                return null;
            }
        }
        if (container.getStatus() == KieContainerStatus.DEACTIVATED) {
            LOGGER.debug("Container {} is currently {}. It needs to be activated.", (Object)resource.getContainerId(), (Object)container.getStatus());
            try {
                response = ((KieServerImpl)this.kieServer).activateContainer(resource.getContainerId());
                if (response.getType() == KieServiceResponse.ResponseType.FAILURE) {
                    String msg = String.format("Container activation failed for containerId: %s, error: %s", resource.getContainerId(), response.getMsg());
                    LOGGER.error(msg);
                    this.registerMessage(Severity.ERROR, msg);
                    return null;
                }
            }
            catch (Exception e) {
                String msg = String.format("Container activation failed for containerId: %s, error: %s", resource.getContainerId(), e.getMessage());
                LOGGER.error(msg, (Throwable)e);
                this.registerMessage(Severity.ERROR, msg);
                return null;
            }
        }
        if (container.getStatus() != KieContainerStatus.STARTED) {
            String msg = String.format("Container %s must be in %s status but is currently %s. TaskAssigningPlanning won't operate properly", resource.getContainerId(), KieContainerStatus.STARTED, container.getStatus());
            LOGGER.error(msg);
            this.registerMessage(Severity.ERROR, msg);
            return null;
        }
        return container;
    }

    private void registerMessage(Severity severity, String msg) {
        String prefixedMsg = TaskAssigningPlanningKieServerExtensionMessages.addExtensionMessagePrefix(msg);
        this.kieServer.addServerMessage(new Message(severity, prefixedMsg));
        this.permanentErrors.add(new Message(severity, prefixedMsg));
    }
}

