/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.core.ast;

import java.util.List;
import org.kie.dmn.api.core.DMNMessage;
import org.kie.dmn.api.core.DMNType;
import org.kie.dmn.api.core.ast.BusinessKnowledgeModelNode;
import org.kie.dmn.core.api.DMNMessageManager;
import org.kie.dmn.core.impl.DMNRuntimeImpl;
import org.kie.dmn.core.util.Msg;
import org.kie.dmn.core.util.MsgUtil;
import org.kie.dmn.feel.lang.EvaluationContext;
import org.kie.dmn.feel.lang.Symbol;
import org.kie.dmn.feel.runtime.FEELFunction;
import org.kie.dmn.feel.runtime.functions.BaseFEELFunction;
import org.kie.dmn.model.api.DMNModelInstrumentedBase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DMNFunctionWithReturnType
extends BaseFEELFunction {
    private static final Logger LOG = LoggerFactory.getLogger(DMNFunctionWithReturnType.class);
    private final FEELFunction wrapped;
    private final DMNType returnType;
    private final DMNMessageManager msgMgr;
    private final BusinessKnowledgeModelNode node;

    public DMNFunctionWithReturnType(FEELFunction wrapped, DMNType returnType, DMNMessageManager msgMgr, BusinessKnowledgeModelNode node) {
        super(wrapped.getName());
        this.wrapped = wrapped;
        this.returnType = returnType;
        this.msgMgr = msgMgr;
        this.node = node;
    }

    public Object invokeReflectively(EvaluationContext ctx, Object[] params) {
        Object result = this.wrapped.invokeReflectively(ctx, params);
        result = DMNRuntimeImpl.coerceUsingType(result, this.returnType, (r, t) -> MsgUtil.reportMessage(LOG, DMNMessage.Severity.WARN, (DMNModelInstrumentedBase)this.node.getBusinessKnowledModel(), this.msgMgr, null, null, Msg.ERROR_EVAL_NODE_RESULT_WRONG_TYPE, this.node.getName() != null ? this.node.getName() : this.node.getId(), t, MsgUtil.clipString(r.toString(), 50)));
        return result;
    }

    public Symbol getSymbol() {
        return this.wrapped.getSymbol();
    }

    public List<List<FEELFunction.Param>> getParameters() {
        return this.wrapped.getParameters();
    }

    public String getName() {
        return this.wrapped.getName();
    }

    public String toString() {
        return this.wrapped.toString();
    }
}

