/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.services.taskassigning.planning;

import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import org.apache.commons.lang3.tuple.Pair;
import org.kie.api.task.model.Status;
import org.kie.server.api.model.taskassigning.TaskData;
import org.kie.server.api.model.taskassigning.TaskInputVariablesReadMode;
import org.kie.server.services.taskassigning.core.model.TaskAssigningSolution;
import org.kie.server.services.taskassigning.planning.RunnableBase;
import org.kie.server.services.taskassigning.planning.SolutionBuilder;
import org.kie.server.services.taskassigning.planning.SolutionChangesBuilder;
import org.kie.server.services.taskassigning.planning.SolverExecutor;
import org.kie.server.services.taskassigning.planning.SolverHandlerContext;
import org.kie.server.services.taskassigning.planning.TaskAssigningRuntimeDelegate;
import org.kie.server.services.taskassigning.user.system.api.User;
import org.kie.server.services.taskassigning.user.system.api.UserSystemService;
import org.kie.soup.commons.validation.PortablePreconditions;
import org.optaplanner.core.impl.solver.ProblemFactChange;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SolutionSynchronizer
extends RunnableBase {
    private static final Logger LOGGER = LoggerFactory.getLogger(SolutionSynchronizer.class);
    private final SolverExecutor solverExecutor;
    private final TaskAssigningRuntimeDelegate delegate;
    private final UserSystemService userSystemService;
    private final long syncInterval;
    private final SolverHandlerContext context;
    private final Consumer<Result> resultConsumer;
    private int solverExecutorStarts = 0;
    private TaskAssigningSolution solution;
    private LocalDateTime fromLastModificationDate;
    private AtomicReference<Action> action = new AtomicReference<Object>(null);
    private final Semaphore startPermit = new Semaphore(0);

    public SolutionSynchronizer(SolverExecutor solverExecutor, TaskAssigningRuntimeDelegate delegate, UserSystemService userSystem, long syncInterval, SolverHandlerContext context, Consumer<Result> resultConsumer) {
        PortablePreconditions.checkNotNull((String)"solverExecutor", (Object)solverExecutor);
        PortablePreconditions.checkNotNull((String)"delegate", (Object)delegate);
        PortablePreconditions.checkNotNull((String)"userSystem", (Object)userSystem);
        PortablePreconditions.checkCondition((String)"syncInterval", (syncInterval > 0L ? 1 : 0) != 0);
        PortablePreconditions.checkNotNull((String)"context", (Object)context);
        PortablePreconditions.checkNotNull((String)"resultConsumer", resultConsumer);
        this.solverExecutor = solverExecutor;
        this.delegate = delegate;
        this.userSystemService = userSystem;
        this.syncInterval = syncInterval;
        this.context = context;
        this.resultConsumer = resultConsumer;
    }

    public void initSolverExecutor() {
        if (!this.status.compareAndSet(RunnableBase.Status.STOPPED, RunnableBase.Status.STARTED)) {
            throw new IllegalStateException("SolutionSynchronizer initSolverExecutor method can only be invoked when the status is STOPPED");
        }
        this.action.set(Action.INIT_SOLVER_EXECUTOR);
        this.startPermit.release();
    }

    public void synchronizeSolution(TaskAssigningSolution solution, LocalDateTime fromLastModificationDate) {
        if (!this.status.compareAndSet(RunnableBase.Status.STOPPED, RunnableBase.Status.STARTED)) {
            throw new IllegalStateException("SolutionSynchronizer synchronizeSolution method can only be invoked when the status is STOPPED");
        }
        this.solution = solution;
        this.fromLastModificationDate = fromLastModificationDate;
        this.action.set(Action.SYNCHRONIZE_SOLUTION);
        LOGGER.debug("Start synchronizeSolution fromLastModificationDate: {}", (Object)fromLastModificationDate);
        this.startPermit.release();
    }

    @Override
    public void destroy() {
        super.destroy();
        this.startPermit.release();
    }

    @Override
    public void run() {
        LOGGER.debug("Solution Synchronizer Started");
        while (this.isAlive()) {
            try {
                Action nextAction;
                this.startPermit.acquire();
                if (!this.isAlive()) continue;
                if (this.action.get() == Action.INIT_SOLVER_EXECUTOR) {
                    nextAction = this.doInitSolverExecutor();
                    this.action.set(nextAction);
                } else if (this.action.get() == Action.SYNCHRONIZE_SOLUTION) {
                    nextAction = this.doSynchronizeSolution();
                    this.action.set(nextAction);
                }
                if (this.action.get() != null) {
                    Thread.sleep(this.syncInterval);
                    this.startPermit.release();
                    continue;
                }
                if (!this.isAlive()) continue;
                this.status.set(RunnableBase.Status.STOPPED);
            }
            catch (InterruptedException e) {
                super.destroy();
                Thread.currentThread().interrupt();
                LOGGER.error("Solution Synchronizer was interrupted.", (Throwable)e);
            }
        }
        super.destroy();
        LOGGER.debug("Solution Synchronizer finished");
    }

    Action doInitSolverExecutor() {
        Action nextAction = null;
        try {
            LOGGER.debug("Solution Synchronizer will recover the solution from the jBPM runtime for starting the solver.");
            if (!this.solverExecutor.isStopped()) {
                LOGGER.debug("Previous solver instance has not yet finished, let's wait for it to stop. Next attempt will be in {} milliseconds.", (Object)this.syncInterval);
                nextAction = Action.INIT_SOLVER_EXECUTOR;
            } else {
                TaskAssigningSolution recoveredSolution = this.recoverSolution();
                if (this.isAlive() && !this.solverExecutor.isDestroyed()) {
                    if (!recoveredSolution.getTaskList().isEmpty()) {
                        this.solverExecutor.start(recoveredSolution);
                        LOGGER.debug("Solution was successfully recovered. Solver was started for #{} time.", (Object)(++this.solverExecutorStarts));
                        if (this.solverExecutorStarts > 1) {
                            LOGGER.debug("It looks like it was necessary to restart the solver. It might have been caused due to errors during the solution applying in the jBPM runtime");
                        }
                    } else {
                        nextAction = Action.INIT_SOLVER_EXECUTOR;
                        LOGGER.debug("It looks like there are no tasks for recovering the solution at this moment. Next attempt will be in {} milliseconds", (Object)this.syncInterval);
                    }
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("An error was produced during solution recovering. Next attempt will be in " + this.syncInterval + " milliseconds", (Throwable)e);
            nextAction = Action.INIT_SOLVER_EXECUTOR;
        }
        return nextAction;
    }

    Action doSynchronizeSolution() {
        Action nextAction = null;
        try {
            if (this.solverExecutor.isStarted()) {
                LOGGER.debug("Synchronizing solution status from the jBPM runtime.");
                Pair<List<TaskData>, LocalDateTime> result = this.loadTasksForUpdate(this.fromLastModificationDate);
                List updatedTaskDataList = (List)result.getLeft();
                LOGGER.debug("Status was read successful.");
                if (this.isAlive()) {
                    List<ProblemFactChange<TaskAssigningSolution>> changes = this.buildChanges(this.solution, updatedTaskDataList);
                    this.context.setPreviousQueryTime(this.fromLastModificationDate);
                    LocalDateTime nextQueryTime = SolutionSynchronizer.trimMillis((LocalDateTime)result.getRight());
                    LocalDateTime lastQueryTime = this.context.peekLastQueryTime();
                    if (!this.context.hasMinimalDistance(lastQueryTime, nextQueryTime)) {
                        nextQueryTime = lastQueryTime;
                    }
                    this.context.addNextQueryTime(nextQueryTime);
                    if (!changes.isEmpty()) {
                        LOGGER.debug("Current solution will be updated with {} changes from last synchronization", (Object)changes.size());
                        this.resultConsumer.accept(new Result(changes));
                    } else {
                        LOGGER.debug("There are no changes to apply from last synchronization.");
                        this.fromLastModificationDate = this.context.pollNextQueryTime();
                        nextAction = Action.SYNCHRONIZE_SOLUTION;
                    }
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("An error was produced during solution status synchronization from the jBPM runtime. Next attempt will be in " + this.syncInterval + " milliseconds", (Throwable)e);
            nextAction = Action.SYNCHRONIZE_SOLUTION;
        }
        return nextAction;
    }

    protected List<ProblemFactChange<TaskAssigningSolution>> buildChanges(TaskAssigningSolution solution, List<TaskData> updatedTaskDataList) {
        return SolutionChangesBuilder.create().withSolution(solution).withTasks(updatedTaskDataList).withUserSystem(this.userSystemService).withContext(this.context).build();
    }

    private TaskAssigningSolution recoverSolution() {
        TaskAssigningRuntimeDelegate.FindTasksResult result = this.delegate.findTasks(Arrays.asList(Status.Ready, Status.Reserved, Status.InProgress, Status.Suspended), null, TaskInputVariablesReadMode.READ_FOR_ALL);
        LocalDateTime nextQueryTime = SolutionSynchronizer.trimMillis(result.getQueryTime());
        LocalDateTime adjustedFirstQueryTime = nextQueryTime != null ? nextQueryTime.minusHours(1L) : null;
        this.context.setPreviousQueryTime(adjustedFirstQueryTime);
        this.context.resetQueryTimes(adjustedFirstQueryTime);
        this.context.pollLastQueryTime();
        this.context.addNextQueryTime(nextQueryTime);
        this.context.clearTaskChangeTimes();
        List<TaskData> taskDataList = result.getTasks();
        LOGGER.debug("{} tasks where loaded for solution recovery, with result.queryTime: {}", (Object)taskDataList.size(), (Object)result.getQueryTime());
        List externalUsers = this.userSystemService.findAllUsers();
        return this.buildSolution(taskDataList, externalUsers);
    }

    protected TaskAssigningSolution buildSolution(List<TaskData> taskDataList, List<User> externalUsers) {
        return SolutionBuilder.create().withTasks(taskDataList).withUsers(externalUsers).withContext(this.context).build();
    }

    private Pair<List<TaskData>, LocalDateTime> loadTasksForUpdate(LocalDateTime fromLastModificationDate) {
        TaskAssigningRuntimeDelegate.FindTasksResult result = this.delegate.findTasks(null, fromLastModificationDate, TaskInputVariablesReadMode.READ_FOR_ACTIVE_TASKS_WITH_NO_PLANNING_ENTITY);
        LOGGER.debug("Total modifications found: {} since fromLastModificationDate: {}, with result.queryTime: {}", new Object[]{result.getTasks().size(), fromLastModificationDate, result.getQueryTime()});
        return Pair.of(result.getTasks(), (Object)result.getQueryTime());
    }

    private static LocalDateTime trimMillis(LocalDateTime localDateTime) {
        return localDateTime != null ? localDateTime.withNano(0) : null;
    }

    public static class Result {
        private List<ProblemFactChange<TaskAssigningSolution>> changes;

        public Result(List<ProblemFactChange<TaskAssigningSolution>> changes) {
            this.changes = changes;
        }

        public List<ProblemFactChange<TaskAssigningSolution>> getChanges() {
            return this.changes;
        }
    }

    static enum Action {
        INIT_SOLVER_EXECUTOR,
        SYNCHRONIZE_SOLUTION;

    }
}

