/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.services.taskassigning.planning;

import java.time.LocalDateTime;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Consumer;
import org.kie.server.api.model.taskassigning.PlanningExecutionResult;
import org.kie.server.services.api.KieServerRegistry;
import org.kie.server.services.taskassigning.core.model.TaskAssigningSolution;
import org.kie.server.services.taskassigning.planning.SolutionProcessor;
import org.kie.server.services.taskassigning.planning.SolutionSynchronizer;
import org.kie.server.services.taskassigning.planning.SolverDef;
import org.kie.server.services.taskassigning.planning.SolverExecutor;
import org.kie.server.services.taskassigning.planning.SolverHandlerContext;
import org.kie.server.services.taskassigning.planning.TaskAssigningRuntimeDelegate;
import org.kie.server.services.taskassigning.planning.util.PropertyUtil;
import org.kie.server.services.taskassigning.user.system.api.UserSystemService;
import org.kie.soup.commons.validation.PortablePreconditions;
import org.optaplanner.core.api.solver.event.BestSolutionChangedEvent;
import org.optaplanner.core.api.solver.event.SolverEventListener;
import org.optaplanner.core.impl.solver.ProblemFactChange;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SolverHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(SolverHandler.class);
    private static final String TARGET_USER_ID = PropertyUtil.readSystemProperty("org.kie.server.taskAssigning.processRuntime.targetUser", null, value -> value);
    private static final int PUBLISH_WINDOW_SIZE = PropertyUtil.readSystemProperty("org.kie.server.taskAssigning.publishWindowSize", 2, Integer::parseInt);
    private static final long SYNC_INTERVAL = PropertyUtil.readSystemProperty("org.kie.server.taskAssigning.solutionSyncInterval", 5000L, Long::parseLong);
    private static final int SYNC_QUERIES_WINDOW_SIZE = PropertyUtil.readSystemProperty("org.kie.server.taskAssigning.solutionSyncQueriesWindowSize", 2, Integer::parseInt);
    private static final long SYNC_QUERIES_MINIMUM_DISTANCE = PropertyUtil.readSystemProperty("org.kie.server.taskAssigning.solutionSyncQueriesMinimumDistance", 2000, Integer::parseInt).intValue();
    private static final long EXECUTOR_TERMINATION_TIMEOUT = 5L;
    private final SolverDef solverDef;
    private final KieServerRegistry registry;
    private final TaskAssigningRuntimeDelegate delegate;
    private final UserSystemService userSystemService;
    private final ExecutorService executorService;
    private final ReentrantLock lock = new ReentrantLock();
    private TaskAssigningSolution currentSolution = null;
    private SolverExecutor solverExecutor;
    private SolverHandlerContext context;
    private SolutionSynchronizer solutionSynchronizer;
    private SolutionProcessor solutionProcessor;

    public SolverHandler(SolverDef solverDef, KieServerRegistry registry, TaskAssigningRuntimeDelegate delegate, UserSystemService userSystemService, ExecutorService executorService) {
        PortablePreconditions.checkNotNull((String)"solverDef", (Object)solverDef);
        PortablePreconditions.checkNotNull((String)"registry", (Object)registry);
        PortablePreconditions.checkNotNull((String)"delegate", (Object)delegate);
        PortablePreconditions.checkNotNull((String)"userSystemService", (Object)userSystemService);
        PortablePreconditions.checkNotNull((String)"executorService", (Object)executorService);
        this.solverDef = solverDef;
        this.registry = registry;
        this.delegate = delegate;
        this.userSystemService = userSystemService;
        this.executorService = executorService;
        this.context = new SolverHandlerContext(SYNC_QUERIES_WINDOW_SIZE, SYNC_QUERIES_MINIMUM_DISTANCE);
    }

    public void start() {
        this.solverExecutor = this.createSolverExecutor(this.solverDef, this.registry, (SolverEventListener<TaskAssigningSolution>)((SolverEventListener)this::onBestSolutionChange));
        this.solutionSynchronizer = this.createSolutionSynchronizer(this.solverExecutor, this.delegate, this.userSystemService, SYNC_INTERVAL, this.context, this::onUpdateSolution);
        this.solutionProcessor = this.createSolutionProcessor(this.delegate, this::onSolutionProcessed, TARGET_USER_ID, PUBLISH_WINDOW_SIZE);
        this.executorService.execute(this.solverExecutor);
        this.executorService.execute(this.solutionSynchronizer);
        this.executorService.execute(this.solutionProcessor);
        this.solutionSynchronizer.initSolverExecutor();
    }

    public void destroy() {
        this.solverExecutor.destroy();
        this.solutionSynchronizer.destroy();
        this.solutionProcessor.destroy();
        this.executorService.shutdown();
        try {
            this.executorService.awaitTermination(5L, TimeUnit.SECONDS);
            LOGGER.debug("ExecutorService was successfully shutted down.");
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            LOGGER.debug("An exception was thrown during executionService graceful termination.", (Throwable)e);
            this.executorService.shutdownNow();
        }
    }

    SolverExecutor createSolverExecutor(SolverDef solverDef, KieServerRegistry registry, SolverEventListener<TaskAssigningSolution> listener) {
        return new SolverExecutor(solverDef, registry, listener);
    }

    SolutionSynchronizer createSolutionSynchronizer(SolverExecutor solverExecutor, TaskAssigningRuntimeDelegate delegate, UserSystemService userSystemService, long synchInterval, SolverHandlerContext context, Consumer<SolutionSynchronizer.Result> resultConsumer) {
        return new SolutionSynchronizer(solverExecutor, delegate, userSystemService, synchInterval, context, resultConsumer);
    }

    SolutionProcessor createSolutionProcessor(TaskAssigningRuntimeDelegate delegate, Consumer<SolutionProcessor.Result> resultConsumer, String targetUserId, int publishWindowSize) {
        return new SolutionProcessor(delegate, resultConsumer, targetUserId, publishWindowSize);
    }

    private void addProblemFactChanges(List<ProblemFactChange<TaskAssigningSolution>> changes) {
        PortablePreconditions.checkNotNull((String)"changes", changes);
        if (!this.solverExecutor.isStarted()) {
            LOGGER.info("SolverExecutor has not been started. Changes will be discarded {}", changes);
            return;
        }
        if (!changes.isEmpty()) {
            this.solverExecutor.addProblemFactChanges(changes);
        } else {
            LOGGER.info("It looks like an empty change list was provided. Nothing will be done since it has no effect on the solution.");
        }
    }

    private void onBestSolutionChange(BestSolutionChangedEvent<TaskAssigningSolution> event) {
        LOGGER.debug("onBestSolutionChange: isEveryProblemFactChangeProcessed: {}, currentChangeSetId: {}, isCurrentChangeSetProcessed: {}", new Object[]{event.isEveryProblemFactChangeProcessed(), this.context.getCurrentChangeSetId(), this.context.isProcessedChangeSet(this.context.getCurrentChangeSetId())});
        if (event.isEveryProblemFactChangeProcessed() && ((TaskAssigningSolution)event.getNewBestSolution()).getScore().isSolutionInitialized() && !this.context.isProcessedChangeSet(this.context.getCurrentChangeSetId())) {
            this.lock.lock();
            try {
                LOGGER.debug("A new solution has been produced for changeSetId: {}", (Object)this.context.getCurrentChangeSetId());
                this.currentSolution = (TaskAssigningSolution)event.getNewBestSolution();
                this.context.setProcessedChangeSet(this.context.getCurrentChangeSetId());
                this.solutionProcessor.process(this.currentSolution);
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    private void onSolutionProcessed(SolutionProcessor.Result result) {
        this.lock.lock();
        try {
            if (result.hasException() || result.getExecutionResult().hasError() && !this.isRecoverableError(result.getExecutionResult().getError())) {
                LOGGER.error("An error was produced during the solution processing. The solver will be restarted with a recovered solution from the jBPM runtime.", (Object)(result.hasException() ? result.getException() : result.getExecutionResult().getError()));
                this.solverExecutor.stop();
                this.context.clearProcessedChangeSet();
                this.solutionSynchronizer.initSolverExecutor();
                this.currentSolution = null;
            } else {
                LocalDateTime fromLastModificationDate;
                if (result.getExecutionResult().hasError()) {
                    LOGGER.debug("A recoverable error was produced during solution processing. errorCode: {}, message: {} Solution will be properly updated on next refresh", (Object)result.getExecutionResult().getError(), (Object)result.getExecutionResult().getErrorMessage());
                    fromLastModificationDate = this.context.getPreviousQueryTime();
                    this.context.pollLastQueryTime();
                } else {
                    fromLastModificationDate = this.context.pollNextQueryTime();
                    this.context.clearTaskChangeTimes(this.context.getPreviousQueryTime());
                }
                this.solutionSynchronizer.synchronizeSolution(this.currentSolution, fromLastModificationDate);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    private void onUpdateSolution(SolutionSynchronizer.Result result) {
        this.lock.lock();
        try {
            this.addProblemFactChanges(result.getChanges());
        }
        finally {
            this.lock.unlock();
        }
    }

    private boolean isRecoverableError(PlanningExecutionResult.ErrorCode errorCode) {
        return errorCode == PlanningExecutionResult.ErrorCode.TASK_MODIFIED_SINCE_PLAN_CALCULATION_ERROR;
    }
}

