/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.score.stream.drools.bi;

import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import org.optaplanner.core.api.function.TriFunction;
import org.optaplanner.core.api.score.stream.bi.BiConstraintCollector;
import org.optaplanner.core.impl.score.stream.drools.common.BiTuple;
import org.optaplanner.core.impl.score.stream.drools.common.DroolsAbstractBiCollectingGroupByAccumulator;
import org.optaplanner.core.impl.score.stream.drools.common.QuadTuple;

final class DroolsBiToQuadGroupByAccumulator<A, B, NewA, NewB, NewC, NewD, ResultContainerC, ResultContainerD>
extends DroolsAbstractBiCollectingGroupByAccumulator<ResultContainerC, ResultContainerD, BiTuple<A, B>, BiTuple<NewA, NewB>, QuadTuple<NewA, NewB, NewC, NewD>> {
    private final BiFunction<A, B, NewA> groupKeyAMapping;
    private final BiFunction<A, B, NewB> groupKeyBMapping;
    private final Supplier<ResultContainerC> supplierC;
    private final TriFunction<ResultContainerC, A, B, Runnable> accumulatorC;
    private final Function<ResultContainerC, NewC> finisherC;
    private final Supplier<ResultContainerD> supplierD;
    private final TriFunction<ResultContainerD, A, B, Runnable> accumulatorD;
    private final Function<ResultContainerD, NewD> finisherD;

    public DroolsBiToQuadGroupByAccumulator(BiFunction<A, B, NewA> groupKeyAMapping, BiFunction<A, B, NewB> groupKeyBMapping, BiConstraintCollector<A, B, ResultContainerC, NewC> collectorC, BiConstraintCollector<A, B, ResultContainerD, NewD> collectorD) {
        this.groupKeyAMapping = groupKeyAMapping;
        this.groupKeyBMapping = groupKeyBMapping;
        this.supplierC = collectorC.supplier();
        this.accumulatorC = collectorC.accumulator();
        this.finisherC = collectorC.finisher();
        this.supplierD = collectorD.supplier();
        this.accumulatorD = collectorD.accumulator();
        this.finisherD = collectorD.finisher();
    }

    @Override
    protected BiTuple<NewA, NewB> toKey(BiTuple<A, B> tuple) {
        return new BiTuple<NewA, NewB>(this.groupKeyAMapping.apply(tuple.a, tuple.b), this.groupKeyBMapping.apply(tuple.a, tuple.b));
    }

    @Override
    protected ResultContainerC newFirstContainer() {
        return this.supplierC.get();
    }

    @Override
    protected ResultContainerD newSecondContainer() {
        return this.supplierD.get();
    }

    @Override
    protected Runnable processFirst(BiTuple<A, B> tuple, ResultContainerC container) {
        return this.accumulatorC.apply(container, tuple.a, tuple.b);
    }

    @Override
    protected Runnable processSecond(BiTuple<A, B> tuple, ResultContainerD container) {
        return this.accumulatorD.apply(container, tuple.a, tuple.b);
    }

    @Override
    protected QuadTuple<NewA, NewB, NewC, NewD> toResult(BiTuple<NewA, NewB> key, ResultContainerC containerC, ResultContainerD containerD) {
        return new QuadTuple(key.a, key.b, this.finisherC.apply(containerC), this.finisherD.apply(containerD));
    }
}

