/*
 * Decompiled with CFR 0.152.
 */
package org.mvel2;

public class ErrorDetail {
    private char[] expr;
    private int cursor;
    private boolean critical;
    private String message;
    private int lineNumber;
    private int column;

    public ErrorDetail(char[] expr, int cursor, boolean critical, String message) {
        this.expr = expr;
        this.cursor = cursor;
        this.critical = critical;
        this.message = message;
        this.calcRowAndColumn();
    }

    public boolean isCritical() {
        return this.critical;
    }

    public void setCritical(boolean critical) {
        this.critical = critical;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public int getCursor() {
        return this.cursor;
    }

    public void calcRowAndColumn() {
        int row = 1;
        int col = 1;
        if (this.lineNumber != 0 && this.column != 0 || this.expr == null || this.expr.length == 0) {
            return;
        }
        block4: for (int i = 0; i < this.cursor; ++i) {
            switch (this.expr[i]) {
                case '\r': {
                    continue block4;
                }
                case '\n': {
                    ++row;
                    col = 0;
                    continue block4;
                }
                default: {
                    ++col;
                }
            }
        }
        this.lineNumber = row;
        this.column = col;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public int getColumn() {
        return this.column;
    }

    public void setCursor(int cursor) {
        this.cursor = cursor;
    }

    public void setExpr(char[] expr) {
        this.expr = expr;
    }

    public char[] getExpr() {
        return this.expr;
    }

    public void setLineNumber(int lineNumber) {
        this.lineNumber = lineNumber;
    }

    public void setColumn(int column) {
        this.column = column;
    }

    public String toString() {
        if (this.critical) {
            return "(" + this.lineNumber + "," + this.column + ") " + this.message;
        }
        return "(" + this.lineNumber + "," + this.column + ") WARNING: " + this.message;
    }
}

