/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.score.stream.drools.tri;

import java.util.function.Function;
import java.util.function.Supplier;
import org.optaplanner.core.api.function.QuadFunction;
import org.optaplanner.core.api.function.TriFunction;
import org.optaplanner.core.api.score.stream.tri.TriConstraintCollector;
import org.optaplanner.core.impl.score.stream.drools.common.BiTuple;
import org.optaplanner.core.impl.score.stream.drools.common.DroolsAbstractUniCollectingGroupByAccumulator;
import org.optaplanner.core.impl.score.stream.drools.common.TriTuple;

final class DroolsTriToBiGroupByAccumulator<A, B, C, ResultContainer, NewA, NewB>
extends DroolsAbstractUniCollectingGroupByAccumulator<ResultContainer, TriTuple<A, B, C>, NewA, BiTuple<NewA, NewB>> {
    private final TriFunction<A, B, C, NewA> groupKeyMapping;
    private final Supplier<ResultContainer> supplier;
    private final QuadFunction<ResultContainer, A, B, C, Runnable> accumulator;
    private final Function<ResultContainer, NewB> finisher;

    public DroolsTriToBiGroupByAccumulator(TriFunction<A, B, C, NewA> groupKeyMapping, TriConstraintCollector<A, B, C, ResultContainer, NewB> collector) {
        this.groupKeyMapping = groupKeyMapping;
        this.supplier = collector.supplier();
        this.accumulator = collector.accumulator();
        this.finisher = collector.finisher();
    }

    @Override
    protected NewA toKey(TriTuple<A, B, C> abcTriTuple) {
        return this.groupKeyMapping.apply(abcTriTuple.a, abcTriTuple.b, abcTriTuple.c);
    }

    @Override
    protected ResultContainer newContainer() {
        return this.supplier.get();
    }

    @Override
    protected Runnable process(TriTuple<A, B, C> abcTriTuple, ResultContainer container) {
        return this.accumulator.apply(container, abcTriTuple.a, abcTriTuple.b, abcTriTuple.c);
    }

    @Override
    protected BiTuple<NewA, NewB> toResult(NewA key, ResultContainer container) {
        return new BiTuple<NewA, NewB>(key, this.finisher.apply(container));
    }
}

