/*
 * Decompiled with CFR 0.152.
 */
package org.kie.aries.blueprint.factorybeans;

import org.kie.api.io.ResourceType;
import org.kie.api.runtime.manager.RuntimeEngine;
import org.kie.api.runtime.manager.RuntimeEnvironment;
import org.kie.api.runtime.manager.RuntimeEnvironmentBuilder;
import org.kie.api.runtime.manager.RuntimeManager;
import org.kie.api.runtime.manager.RuntimeManagerFactory;
import org.kie.internal.io.ResourceFactory;
import org.kie.internal.runtime.manager.context.EmptyContext;

public class KieRuntimeManagerFactoryBean {
    public static Object createRuntime(String type, String asset, String assetType) {
        RuntimeEnvironmentBuilder builder;
        if ("empty".equalsIgnoreCase(type)) {
            builder = RuntimeEnvironmentBuilder.Factory.get().newEmptyBuilder();
        } else if ("default".equalsIgnoreCase(type)) {
            builder = RuntimeEnvironmentBuilder.Factory.get().newDefaultBuilder();
        } else if ("defaultInMemory".equalsIgnoreCase(type)) {
            builder = RuntimeEnvironmentBuilder.Factory.get().newDefaultInMemoryBuilder();
        } else {
            throw new IllegalArgumentException("Could not find a RuntimeManager for the type : " + type);
        }
        if (!assetType.equals(ResourceType.BPMN2.getName())) {
            throw new IllegalArgumentException("Asset is not of type BPMN2");
        }
        builder.addAsset(ResourceFactory.newClassPathResource((String)asset), ResourceType.BPMN2);
        RuntimeEnvironment environment = builder.get();
        RuntimeManager manager = RuntimeManagerFactory.Factory.get().newSingletonRuntimeManager(environment);
        return manager;
    }

    public static Object createSession(RuntimeManager manager) {
        RuntimeEngine engine = manager.getRuntimeEngine(EmptyContext.get());
        return engine.getKieSession();
    }
}

