/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.services.taskassigning.planning;

import java.time.Duration;
import java.time.LocalDateTime;
import java.time.chrono.ChronoLocalDateTime;
import java.time.temporal.ChronoUnit;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;

public class SolverHandlerContext {
    private long changeSetIds;
    private long currentChangeSetId;
    private long lastProcessedChangeSetId = -1L;
    private LocalDateTime previousQueryTime;
    private LocalDateTime nextQueryTime;
    private Map<Long, LocalDateTime> taskChangeTimes = new HashMap<Long, LocalDateTime>();
    private Duration queryShift;

    public SolverHandlerContext(Duration queryShift) {
        this.queryShift = queryShift;
    }

    public long getCurrentChangeSetId() {
        return this.currentChangeSetId;
    }

    public void setCurrentChangeSetId(long currentChangeSetId) {
        this.currentChangeSetId = currentChangeSetId;
    }

    public long nextChangeSetId() {
        return ++this.changeSetIds;
    }

    public boolean isProcessedChangeSet(long changeSetId) {
        return changeSetId <= this.lastProcessedChangeSetId;
    }

    public void setProcessedChangeSet(long changeSetId) {
        this.lastProcessedChangeSetId = changeSetId;
    }

    public void clearProcessedChangeSet() {
        this.lastProcessedChangeSetId = -1L;
    }

    public void setTaskChangeTime(long taskId, LocalDateTime changeTime) {
        this.taskChangeTimes.put(taskId, changeTime);
    }

    public boolean isProcessedTaskChange(long taskId, LocalDateTime changeTime) {
        return changeTime.equals(this.taskChangeTimes.get(taskId));
    }

    public void clearTaskChangeTimes(LocalDateTime untilLocalDateTime) {
        if (untilLocalDateTime != null) {
            this.taskChangeTimes.entrySet().stream().filter(entry -> untilLocalDateTime.compareTo((ChronoLocalDateTime)entry.getValue()) > 0).map(Map.Entry::getKey).collect(Collectors.toList()).forEach(removableChange -> this.taskChangeTimes.remove(removableChange));
        }
    }

    public void clearTaskChangeTimes() {
        this.taskChangeTimes.clear();
    }

    public LocalDateTime getPreviousQueryTime() {
        return this.previousQueryTime;
    }

    public void setPreviousQueryTime(LocalDateTime previousQueryTime) {
        this.previousQueryTime = previousQueryTime;
    }

    public LocalDateTime getNextQueryTime() {
        return this.nextQueryTime;
    }

    public void setNextQueryTime(LocalDateTime nextQueryTime) {
        this.nextQueryTime = nextQueryTime;
    }

    public LocalDateTime shiftQueryTime(LocalDateTime queryTime) {
        return queryTime != null ? queryTime.minus(this.queryShift.toMillis(), ChronoUnit.MILLIS) : null;
    }
}

