/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.score.stream.drools.common;

import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.optaplanner.core.impl.score.stream.drools.common.DroolsAbstractGroupByAccumulator;

public abstract class DroolsAbstractUniCollectingGroupByAccumulator<ResultContainer, InTuple, KeyTuple, OutTuple>
extends DroolsAbstractGroupByAccumulator<InTuple, KeyTuple, OutTuple> {
    private final Map<KeyTuple, ResultContainer> containersMap = new HashMap<KeyTuple, ResultContainer>(0);
    private final Map<KeyTuple, OutTuple> resultMap = new LinkedHashMap<KeyTuple, OutTuple>(0);

    @Override
    public Runnable accumulate(InTuple input) {
        KeyTuple key = this.toKey(input);
        Object container = this.containersMap.computeIfAbsent(key, __ -> this.newContainer());
        Runnable undo = this.process(input, container);
        this.addTuple(key);
        return () -> {
            undo.run();
            long currentCount = this.removeTuple(key);
            if (currentCount == 0L) {
                this.containersMap.remove(key);
                this.resultMap.remove(key);
            }
        };
    }

    @Override
    public Collection<OutTuple> finish() {
        Set dirtyTupleSet = this.clearDirtyTupleSet();
        if (!dirtyTupleSet.isEmpty()) {
            for (Object tuple : dirtyTupleSet) {
                this.resultMap.put(tuple, this.toResult(tuple, this.containersMap.get(tuple)));
            }
        }
        return this.resultMap.values();
    }

    protected abstract KeyTuple toKey(InTuple var1);

    protected abstract ResultContainer newContainer();

    protected abstract Runnable process(InTuple var1, ResultContainer var2);

    protected abstract OutTuple toResult(KeyTuple var1, ResultContainer var2);
}

