/*
 * Decompiled with CFR 0.152.
 */
package org.drools.scenariosimulation.backend.fluent;

import java.io.Serializable;
import java.util.Objects;
import org.drools.scenariosimulation.backend.util.DMNSimulationUtils;
import org.kie.api.command.ExecutableCommand;
import org.kie.api.runtime.ExecutableRunner;
import org.kie.api.runtime.KieContainer;
import org.kie.api.runtime.RequestContext;
import org.kie.dmn.api.core.DMNModel;
import org.kie.dmn.api.core.DMNRuntime;
import org.kie.internal.builder.fluent.DMNRuntimeFluent;
import org.kie.internal.builder.fluent.ExecutableBuilder;
import org.kie.internal.command.RegistryContext;

public class DMNScenarioExecutableBuilder {
    public static String DEFAULT_APPLICATION = "defaultApplication";
    public static String DMN_RESULT = "dmnResult";
    public static String DMN_MODEL = "dmnModel";
    private final DMNRuntimeFluent dmnRuntimeFluent;
    private final ExecutableBuilder executableBuilder = ExecutableBuilder.create();

    private DMNScenarioExecutableBuilder(KieContainer kieContainer, String applicationName) {
        this.dmnRuntimeFluent = ((ExecutableBuilder)this.executableBuilder.newApplicationContext(applicationName)).setKieContainer(kieContainer).newDMNRuntime();
    }

    private DMNScenarioExecutableBuilder(KieContainer kieContainer) {
        this(kieContainer, DEFAULT_APPLICATION);
    }

    public static DMNScenarioExecutableBuilder createBuilder(KieContainer kieContainer, String applicationName) {
        return new DMNScenarioExecutableBuilder(kieContainer, applicationName);
    }

    public static DMNScenarioExecutableBuilder createBuilder(KieContainer kieContainer) {
        return new DMNScenarioExecutableBuilder(kieContainer);
    }

    public void setActiveModel(String path) {
        ((DMNRuntimeFluent)this.dmnRuntimeFluent.addCommand((ExecutableCommand & Serializable)context -> {
            RegistryContext registryContext = (RegistryContext)context;
            DMNRuntime dmnRuntime = (DMNRuntime)registryContext.lookup(DMNRuntime.class);
            if (dmnRuntime == null) {
                throw new IllegalStateException("There is no DMNRuntime available");
            }
            DMNModel dmnModel = DMNSimulationUtils.extractDMNModel(dmnRuntime, path);
            registryContext.register(DMNModel.class, (Object)dmnModel);
            return dmnModel;
        })).out(DMN_MODEL);
    }

    public void setValue(String key, Object value) {
        this.dmnRuntimeFluent.setInput(key, value);
    }

    public RequestContext run() {
        Objects.requireNonNull(this.executableBuilder, "Executable builder is null, please invoke create(KieContainer, )");
        ((DMNRuntimeFluent)((DMNRuntimeFluent)this.dmnRuntimeFluent.evaluateModel()).out(DMN_RESULT)).end();
        return (RequestContext)ExecutableRunner.create().execute(this.executableBuilder.getExecutable());
    }
}

