/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.services.taskassigning.planning;

import java.util.List;
import java.util.concurrent.Semaphore;
import java.util.function.Consumer;
import org.kie.server.api.model.taskassigning.PlanningExecutionResult;
import org.kie.server.api.model.taskassigning.PlanningItem;
import org.kie.server.services.taskassigning.core.model.TaskAssigningSolution;
import org.kie.server.services.taskassigning.planning.PlanningBuilder;
import org.kie.server.services.taskassigning.planning.RunnableBase;
import org.kie.server.services.taskassigning.planning.TaskAssigningRuntimeDelegate;
import org.kie.server.services.taskassigning.planning.TraceHelper;
import org.kie.soup.commons.validation.PortablePreconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SolutionProcessor
extends RunnableBase {
    private static final Logger LOGGER = LoggerFactory.getLogger(SolutionProcessor.class);
    private final TaskAssigningRuntimeDelegate delegate;
    private final Consumer<Result> resultConsumer;
    private final String targetUserId;
    private final int publishWindowSize;
    private final Semaphore solutionResource = new Semaphore(0);
    private TaskAssigningSolution solution;

    public SolutionProcessor(TaskAssigningRuntimeDelegate delegate, Consumer<Result> resultConsumer, String targetUserId, int publishWindowSize) {
        PortablePreconditions.checkNotNull((String)"delegate", (Object)delegate);
        PortablePreconditions.checkNotNull((String)"resultConsumer", resultConsumer);
        PortablePreconditions.checkNotNull((String)"targetUserId", (Object)targetUserId);
        PortablePreconditions.checkCondition((String)"publishWindowSize", (publishWindowSize > 0 ? 1 : 0) != 0);
        this.delegate = delegate;
        this.resultConsumer = resultConsumer;
        this.targetUserId = targetUserId;
        this.publishWindowSize = publishWindowSize;
    }

    public boolean isProcessing() {
        RunnableBase.Status currentStatus = (RunnableBase.Status)((Object)this.status.get());
        return RunnableBase.Status.STARTING == currentStatus || RunnableBase.Status.STARTED == currentStatus;
    }

    public void process(TaskAssigningSolution solution) {
        PortablePreconditions.checkNotNull((String)"solution", (Object)solution);
        if (!this.status.compareAndSet(RunnableBase.Status.STOPPED, RunnableBase.Status.STARTING)) {
            throw new IllegalStateException("SolutionProcessor process method can only be invoked when the status is STOPPED");
        }
        this.solution = solution;
        this.solutionResource.release();
    }

    @Override
    public void destroy() {
        super.destroy();
        this.solutionResource.release();
    }

    @Override
    public void run() {
        while (this.isAlive()) {
            try {
                this.solutionResource.acquire();
                if (!this.isAlive() || !this.status.compareAndSet(RunnableBase.Status.STARTING, RunnableBase.Status.STARTED)) continue;
                this.doProcess(this.solution);
            }
            catch (InterruptedException e) {
                super.destroy();
                Thread.currentThread().interrupt();
                LOGGER.error("Solution Processor was interrupted", (Throwable)e);
            }
        }
        super.destroy();
        LOGGER.debug("Solution Processor finished");
    }

    protected void doProcess(TaskAssigningSolution solution) {
        Result result;
        LOGGER.debug("Starting processing of solution: {}", (Object)solution);
        List<PlanningItem> publishedTasks = this.buildPlanning(solution, this.publishWindowSize);
        if (LOGGER.isTraceEnabled()) {
            TraceHelper.traceSolution(LOGGER, solution);
            TraceHelper.tracePublishedTasks(LOGGER, publishedTasks);
        }
        try {
            PlanningExecutionResult executeResult = this.delegate.executePlanning(publishedTasks, this.targetUserId);
            result = new Result(executeResult);
        }
        catch (Exception e) {
            LOGGER.error("An error was produced during solution processing, planning execution failed.", (Throwable)e);
            result = new Result(e);
        }
        LOGGER.debug("Solution processing finished: {}", (Object)solution);
        if (this.isAlive()) {
            this.resultConsumer.accept(result);
            this.status.set(RunnableBase.Status.STOPPED);
        }
    }

    List<PlanningItem> buildPlanning(TaskAssigningSolution solution, int publishWindowSize) {
        return PlanningBuilder.create().withSolution(solution).withPublishWindowSize(publishWindowSize).build();
    }

    public static class Result {
        private Exception exception;
        private PlanningExecutionResult executionResult;

        private Result() {
        }

        public Result(Exception exception) {
            this.exception = exception;
        }

        public Result(PlanningExecutionResult executionResult) {
            this.executionResult = executionResult;
        }

        public boolean hasException() {
            return this.exception != null;
        }

        public Exception getException() {
            return this.exception;
        }

        public PlanningExecutionResult getExecutionResult() {
            return this.executionResult;
        }
    }
}

