/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.simpletext;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.text.ParseException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.codecs.SegmentInfoFormat;
import org.apache.lucene.codecs.simpletext.SimpleTextUtil;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.IndexFileNames;
import org.apache.lucene.index.SegmentInfo;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.SortField;
import org.apache.lucene.search.SortedNumericSelector;
import org.apache.lucene.search.SortedNumericSortField;
import org.apache.lucene.search.SortedSetSelector;
import org.apache.lucene.search.SortedSetSortField;
import org.apache.lucene.store.ChecksumIndexInput;
import org.apache.lucene.store.DataInput;
import org.apache.lucene.store.DataOutput;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefBuilder;
import org.apache.lucene.util.StringHelper;
import org.apache.lucene.util.Version;

public class SimpleTextSegmentInfoFormat
extends SegmentInfoFormat {
    static final BytesRef SI_VERSION = new BytesRef((CharSequence)"    version ");
    static final BytesRef SI_DOCCOUNT = new BytesRef((CharSequence)"    number of documents ");
    static final BytesRef SI_USECOMPOUND = new BytesRef((CharSequence)"    uses compound file ");
    static final BytesRef SI_NUM_DIAG = new BytesRef((CharSequence)"    diagnostics ");
    static final BytesRef SI_DIAG_KEY = new BytesRef((CharSequence)"      key ");
    static final BytesRef SI_DIAG_VALUE = new BytesRef((CharSequence)"      value ");
    static final BytesRef SI_NUM_ATT = new BytesRef((CharSequence)"    attributes ");
    static final BytesRef SI_ATT_KEY = new BytesRef((CharSequence)"      key ");
    static final BytesRef SI_ATT_VALUE = new BytesRef((CharSequence)"      value ");
    static final BytesRef SI_NUM_FILES = new BytesRef((CharSequence)"    files ");
    static final BytesRef SI_FILE = new BytesRef((CharSequence)"      file ");
    static final BytesRef SI_ID = new BytesRef((CharSequence)"    id ");
    static final BytesRef SI_SORT = new BytesRef((CharSequence)"    sort ");
    static final BytesRef SI_SORT_FIELD = new BytesRef((CharSequence)"      field ");
    static final BytesRef SI_SORT_TYPE = new BytesRef((CharSequence)"      type ");
    static final BytesRef SI_SELECTOR_TYPE = new BytesRef((CharSequence)"      selector ");
    static final BytesRef SI_SORT_REVERSE = new BytesRef((CharSequence)"      reverse ");
    static final BytesRef SI_SORT_MISSING = new BytesRef((CharSequence)"      missing ");
    public static final String SI_EXTENSION = "si";

    public SegmentInfo read(Directory directory, String segmentName, byte[] segmentID, IOContext context) throws IOException {
        BytesRefBuilder scratch = new BytesRefBuilder();
        String segFileName = IndexFileNames.segmentFileName((String)segmentName, (String)"", (String)SI_EXTENSION);
        try (ChecksumIndexInput input = directory.openChecksumInput(segFileName, context);){
            Version version;
            SimpleTextUtil.readLine((DataInput)input, scratch);
            assert (StringHelper.startsWith((BytesRef)scratch.get(), (BytesRef)SI_VERSION));
            try {
                version = Version.parse((String)this.readString(SimpleTextSegmentInfoFormat.SI_VERSION.length, scratch));
            }
            catch (ParseException pe) {
                throw new CorruptIndexException("unable to parse version string: " + pe.getMessage(), (DataInput)input, (Throwable)pe);
            }
            SimpleTextUtil.readLine((DataInput)input, scratch);
            assert (StringHelper.startsWith((BytesRef)scratch.get(), (BytesRef)SI_DOCCOUNT));
            int docCount = Integer.parseInt(this.readString(SimpleTextSegmentInfoFormat.SI_DOCCOUNT.length, scratch));
            SimpleTextUtil.readLine((DataInput)input, scratch);
            assert (StringHelper.startsWith((BytesRef)scratch.get(), (BytesRef)SI_USECOMPOUND));
            boolean isCompoundFile = Boolean.parseBoolean(this.readString(SimpleTextSegmentInfoFormat.SI_USECOMPOUND.length, scratch));
            SimpleTextUtil.readLine((DataInput)input, scratch);
            assert (StringHelper.startsWith((BytesRef)scratch.get(), (BytesRef)SI_NUM_DIAG));
            int numDiag = Integer.parseInt(this.readString(SimpleTextSegmentInfoFormat.SI_NUM_DIAG.length, scratch));
            HashMap<String, String> diagnostics = new HashMap<String, String>();
            for (int i = 0; i < numDiag; ++i) {
                SimpleTextUtil.readLine((DataInput)input, scratch);
                assert (StringHelper.startsWith((BytesRef)scratch.get(), (BytesRef)SI_DIAG_KEY));
                String key = this.readString(SimpleTextSegmentInfoFormat.SI_DIAG_KEY.length, scratch);
                SimpleTextUtil.readLine((DataInput)input, scratch);
                assert (StringHelper.startsWith((BytesRef)scratch.get(), (BytesRef)SI_DIAG_VALUE));
                String value = this.readString(SimpleTextSegmentInfoFormat.SI_DIAG_VALUE.length, scratch);
                diagnostics.put(key, value);
            }
            SimpleTextUtil.readLine((DataInput)input, scratch);
            assert (StringHelper.startsWith((BytesRef)scratch.get(), (BytesRef)SI_NUM_ATT));
            int numAtt = Integer.parseInt(this.readString(SimpleTextSegmentInfoFormat.SI_NUM_ATT.length, scratch));
            HashMap<String, String> attributes = new HashMap<String, String>(numAtt);
            for (int i = 0; i < numAtt; ++i) {
                SimpleTextUtil.readLine((DataInput)input, scratch);
                assert (StringHelper.startsWith((BytesRef)scratch.get(), (BytesRef)SI_ATT_KEY));
                String key = this.readString(SimpleTextSegmentInfoFormat.SI_ATT_KEY.length, scratch);
                SimpleTextUtil.readLine((DataInput)input, scratch);
                assert (StringHelper.startsWith((BytesRef)scratch.get(), (BytesRef)SI_ATT_VALUE));
                String value = this.readString(SimpleTextSegmentInfoFormat.SI_ATT_VALUE.length, scratch);
                attributes.put(key, value);
            }
            SimpleTextUtil.readLine((DataInput)input, scratch);
            assert (StringHelper.startsWith((BytesRef)scratch.get(), (BytesRef)SI_NUM_FILES));
            int numFiles = Integer.parseInt(this.readString(SimpleTextSegmentInfoFormat.SI_NUM_FILES.length, scratch));
            HashSet<String> files = new HashSet<String>();
            for (int i = 0; i < numFiles; ++i) {
                SimpleTextUtil.readLine((DataInput)input, scratch);
                assert (StringHelper.startsWith((BytesRef)scratch.get(), (BytesRef)SI_FILE));
                String fileName = this.readString(SimpleTextSegmentInfoFormat.SI_FILE.length, scratch);
                files.add(fileName);
            }
            SimpleTextUtil.readLine((DataInput)input, scratch);
            assert (StringHelper.startsWith((BytesRef)scratch.get(), (BytesRef)SI_ID));
            byte[] id = Arrays.copyOfRange(scratch.bytes(), SimpleTextSegmentInfoFormat.SI_ID.length, scratch.length());
            if (!Arrays.equals(segmentID, id)) {
                throw new CorruptIndexException("file mismatch, expected: " + StringHelper.idToString((byte[])segmentID) + ", got: " + StringHelper.idToString((byte[])id), (DataInput)input);
            }
            SimpleTextUtil.readLine((DataInput)input, scratch);
            assert (StringHelper.startsWith((BytesRef)scratch.get(), (BytesRef)SI_SORT));
            int numSortFields = Integer.parseInt(this.readString(SimpleTextSegmentInfoFormat.SI_SORT.length, scratch));
            SortField[] sortField = new SortField[numSortFields];
            for (int i = 0; i < numSortFields; ++i) {
                Object missingValue;
                SortField.Type type;
                SimpleTextUtil.readLine((DataInput)input, scratch);
                assert (StringHelper.startsWith((BytesRef)scratch.get(), (BytesRef)SI_SORT_FIELD));
                String field = this.readString(SimpleTextSegmentInfoFormat.SI_SORT_FIELD.length, scratch);
                SimpleTextUtil.readLine((DataInput)input, scratch);
                assert (StringHelper.startsWith((BytesRef)scratch.get(), (BytesRef)SI_SORT_TYPE));
                String typeAsString = this.readString(SimpleTextSegmentInfoFormat.SI_SORT_TYPE.length, scratch);
                SortedSetSelector.Type selectorSet = null;
                SortedNumericSelector.Type selectorNumeric = null;
                switch (typeAsString) {
                    case "string": {
                        type = SortField.Type.STRING;
                        break;
                    }
                    case "long": {
                        type = SortField.Type.LONG;
                        break;
                    }
                    case "int": {
                        type = SortField.Type.INT;
                        break;
                    }
                    case "double": {
                        type = SortField.Type.DOUBLE;
                        break;
                    }
                    case "float": {
                        type = SortField.Type.FLOAT;
                        break;
                    }
                    case "multi_valued_string": {
                        type = SortField.Type.STRING;
                        selectorSet = this.readSetSelector((IndexInput)input, scratch);
                        break;
                    }
                    case "multi_valued_long": {
                        type = SortField.Type.LONG;
                        selectorNumeric = this.readNumericSelector((IndexInput)input, scratch);
                        break;
                    }
                    case "multi_valued_int": {
                        type = SortField.Type.INT;
                        selectorNumeric = this.readNumericSelector((IndexInput)input, scratch);
                        break;
                    }
                    case "multi_valued_double": {
                        type = SortField.Type.DOUBLE;
                        selectorNumeric = this.readNumericSelector((IndexInput)input, scratch);
                        break;
                    }
                    case "multi_valued_float": {
                        type = SortField.Type.FLOAT;
                        selectorNumeric = this.readNumericSelector((IndexInput)input, scratch);
                        break;
                    }
                    default: {
                        throw new CorruptIndexException("unable to parse sort type string: " + typeAsString, (DataInput)input);
                    }
                }
                SimpleTextUtil.readLine((DataInput)input, scratch);
                assert (StringHelper.startsWith((BytesRef)scratch.get(), (BytesRef)SI_SORT_REVERSE));
                boolean reverse = Boolean.parseBoolean(this.readString(SimpleTextSegmentInfoFormat.SI_SORT_REVERSE.length, scratch));
                SimpleTextUtil.readLine((DataInput)input, scratch);
                assert (StringHelper.startsWith((BytesRef)scratch.get(), (BytesRef)SI_SORT_MISSING));
                String missingLastAsString = this.readString(SimpleTextSegmentInfoFormat.SI_SORT_MISSING.length, scratch);
                block29 : switch (type) {
                    case STRING: {
                        switch (missingLastAsString) {
                            case "null": {
                                missingValue = null;
                                break block29;
                            }
                            case "first": {
                                missingValue = SortField.STRING_FIRST;
                                break block29;
                            }
                            case "last": {
                                missingValue = SortField.STRING_LAST;
                                break block29;
                            }
                        }
                        throw new CorruptIndexException("unable to parse missing string: " + typeAsString, (DataInput)input);
                    }
                    case LONG: {
                        switch (missingLastAsString) {
                            case "null": {
                                missingValue = null;
                                break block29;
                            }
                        }
                        missingValue = Long.parseLong(missingLastAsString);
                        break;
                    }
                    case INT: {
                        switch (missingLastAsString) {
                            case "null": {
                                missingValue = null;
                                break block29;
                            }
                        }
                        missingValue = Integer.parseInt(missingLastAsString);
                        break;
                    }
                    case DOUBLE: {
                        switch (missingLastAsString) {
                            case "null": {
                                missingValue = null;
                                break block29;
                            }
                        }
                        missingValue = Double.parseDouble(missingLastAsString);
                        break;
                    }
                    case FLOAT: {
                        switch (missingLastAsString) {
                            case "null": {
                                missingValue = null;
                                break block29;
                            }
                        }
                        missingValue = Float.valueOf(Float.parseFloat(missingLastAsString));
                        break;
                    }
                    default: {
                        throw new AssertionError();
                    }
                }
                sortField[i] = selectorSet != null ? new SortedSetSortField(field, reverse) : (selectorNumeric != null ? new SortedNumericSortField(field, type, reverse) : new SortField(field, type, reverse));
                if (missingValue == null) continue;
                sortField[i].setMissingValue(missingValue);
            }
            Sort indexSort = sortField.length == 0 ? null : new Sort(sortField);
            SimpleTextUtil.checkFooter(input);
            SegmentInfo info = new SegmentInfo(directory, version, segmentName, docCount, isCompoundFile, null, Collections.unmodifiableMap(diagnostics), id, Collections.unmodifiableMap(attributes), indexSort);
            info.setFiles(files);
            SegmentInfo segmentInfo = info;
            return segmentInfo;
        }
    }

    private String readString(int offset, BytesRefBuilder scratch) {
        return new String(scratch.bytes(), offset, scratch.length() - offset, StandardCharsets.UTF_8);
    }

    private SortedSetSelector.Type readSetSelector(IndexInput input, BytesRefBuilder scratch) throws IOException {
        String selectorAsString;
        SimpleTextUtil.readLine((DataInput)input, scratch);
        assert (StringHelper.startsWith((BytesRef)scratch.get(), (BytesRef)SI_SELECTOR_TYPE));
        switch (selectorAsString = this.readString(SimpleTextSegmentInfoFormat.SI_SELECTOR_TYPE.length, scratch)) {
            case "min": {
                return SortedSetSelector.Type.MIN;
            }
            case "middle_min": {
                return SortedSetSelector.Type.MIDDLE_MIN;
            }
            case "middle_max": {
                return SortedSetSelector.Type.MIDDLE_MAX;
            }
            case "max": {
                return SortedSetSelector.Type.MAX;
            }
        }
        throw new CorruptIndexException("unable to parse SortedSetSelector type: " + selectorAsString, (DataInput)input);
    }

    private SortedNumericSelector.Type readNumericSelector(IndexInput input, BytesRefBuilder scratch) throws IOException {
        String selectorAsString;
        SimpleTextUtil.readLine((DataInput)input, scratch);
        assert (StringHelper.startsWith((BytesRef)scratch.get(), (BytesRef)SI_SELECTOR_TYPE));
        switch (selectorAsString = this.readString(SimpleTextSegmentInfoFormat.SI_SELECTOR_TYPE.length, scratch)) {
            case "min": {
                return SortedNumericSelector.Type.MIN;
            }
            case "max": {
                return SortedNumericSelector.Type.MAX;
            }
        }
        throw new CorruptIndexException("unable to parse SortedNumericSelector type: " + selectorAsString, (DataInput)input);
    }

    public void write(Directory dir, SegmentInfo si, IOContext ioContext) throws IOException {
        String segFileName = IndexFileNames.segmentFileName((String)si.name, (String)"", (String)SI_EXTENSION);
        try (IndexOutput output = dir.createOutput(segFileName, ioContext);){
            si.addFile(segFileName);
            BytesRefBuilder scratch = new BytesRefBuilder();
            SimpleTextUtil.write((DataOutput)output, SI_VERSION);
            SimpleTextUtil.write((DataOutput)output, si.getVersion().toString(), scratch);
            SimpleTextUtil.writeNewline((DataOutput)output);
            SimpleTextUtil.write((DataOutput)output, SI_DOCCOUNT);
            SimpleTextUtil.write((DataOutput)output, Integer.toString(si.maxDoc()), scratch);
            SimpleTextUtil.writeNewline((DataOutput)output);
            SimpleTextUtil.write((DataOutput)output, SI_USECOMPOUND);
            SimpleTextUtil.write((DataOutput)output, Boolean.toString(si.getUseCompoundFile()), scratch);
            SimpleTextUtil.writeNewline((DataOutput)output);
            Map diagnostics = si.getDiagnostics();
            int numDiagnostics = diagnostics == null ? 0 : diagnostics.size();
            SimpleTextUtil.write((DataOutput)output, SI_NUM_DIAG);
            SimpleTextUtil.write((DataOutput)output, Integer.toString(numDiagnostics), scratch);
            SimpleTextUtil.writeNewline((DataOutput)output);
            if (numDiagnostics > 0) {
                for (Map.Entry entry : diagnostics.entrySet()) {
                    SimpleTextUtil.write((DataOutput)output, SI_DIAG_KEY);
                    SimpleTextUtil.write((DataOutput)output, (String)entry.getKey(), scratch);
                    SimpleTextUtil.writeNewline((DataOutput)output);
                    SimpleTextUtil.write((DataOutput)output, SI_DIAG_VALUE);
                    SimpleTextUtil.write((DataOutput)output, (String)entry.getValue(), scratch);
                    SimpleTextUtil.writeNewline((DataOutput)output);
                }
            }
            Map attributes = si.getAttributes();
            SimpleTextUtil.write((DataOutput)output, SI_NUM_ATT);
            SimpleTextUtil.write((DataOutput)output, Integer.toString(attributes.size()), scratch);
            SimpleTextUtil.writeNewline((DataOutput)output);
            for (Map.Entry entry : attributes.entrySet()) {
                SimpleTextUtil.write((DataOutput)output, SI_ATT_KEY);
                SimpleTextUtil.write((DataOutput)output, (String)entry.getKey(), scratch);
                SimpleTextUtil.writeNewline((DataOutput)output);
                SimpleTextUtil.write((DataOutput)output, SI_ATT_VALUE);
                SimpleTextUtil.write((DataOutput)output, (String)entry.getValue(), scratch);
                SimpleTextUtil.writeNewline((DataOutput)output);
            }
            Set set = si.files();
            int n = set == null ? 0 : set.size();
            SimpleTextUtil.write((DataOutput)output, SI_NUM_FILES);
            SimpleTextUtil.write((DataOutput)output, Integer.toString(n), scratch);
            SimpleTextUtil.writeNewline((DataOutput)output);
            if (n > 0) {
                for (String fileName : set) {
                    SimpleTextUtil.write((DataOutput)output, SI_FILE);
                    SimpleTextUtil.write((DataOutput)output, fileName, scratch);
                    SimpleTextUtil.writeNewline((DataOutput)output);
                }
            }
            SimpleTextUtil.write((DataOutput)output, SI_ID);
            SimpleTextUtil.write((DataOutput)output, new BytesRef(si.getId()));
            SimpleTextUtil.writeNewline((DataOutput)output);
            Sort indexSort = si.getIndexSort();
            SimpleTextUtil.write((DataOutput)output, SI_SORT);
            int numSortFields = indexSort == null ? 0 : indexSort.getSort().length;
            SimpleTextUtil.write((DataOutput)output, Integer.toString(numSortFields), scratch);
            SimpleTextUtil.writeNewline((DataOutput)output);
            for (int i = 0; i < numSortFields; ++i) {
                String selectorString;
                SortedSetSelector.Type selector;
                String sortTypeString;
                boolean multiValued;
                SortField.Type sortType;
                SortField sortField = indexSort.getSort()[i];
                SimpleTextUtil.write((DataOutput)output, SI_SORT_FIELD);
                SimpleTextUtil.write((DataOutput)output, sortField.getField(), scratch);
                SimpleTextUtil.writeNewline((DataOutput)output);
                SimpleTextUtil.write((DataOutput)output, SI_SORT_TYPE);
                if (sortField instanceof SortedSetSortField) {
                    sortType = SortField.Type.STRING;
                    multiValued = true;
                } else if (sortField instanceof SortedNumericSortField) {
                    sortType = ((SortedNumericSortField)sortField).getNumericType();
                    multiValued = true;
                } else {
                    sortType = sortField.getType();
                    multiValued = false;
                }
                switch (sortType) {
                    case STRING: {
                        if (multiValued) {
                            sortTypeString = "multi_valued_string";
                            break;
                        }
                        sortTypeString = "string";
                        break;
                    }
                    case LONG: {
                        if (multiValued) {
                            sortTypeString = "multi_valued_long";
                            break;
                        }
                        sortTypeString = "long";
                        break;
                    }
                    case INT: {
                        if (multiValued) {
                            sortTypeString = "multi_valued_int";
                            break;
                        }
                        sortTypeString = "int";
                        break;
                    }
                    case DOUBLE: {
                        if (multiValued) {
                            sortTypeString = "multi_valued_double";
                            break;
                        }
                        sortTypeString = "double";
                        break;
                    }
                    case FLOAT: {
                        if (multiValued) {
                            sortTypeString = "multi_valued_float";
                            break;
                        }
                        sortTypeString = "float";
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Unexpected sort type: " + sortField.getType());
                    }
                }
                SimpleTextUtil.write((DataOutput)output, sortTypeString, scratch);
                SimpleTextUtil.writeNewline((DataOutput)output);
                if (sortField instanceof SortedSetSortField) {
                    selector = ((SortedSetSortField)sortField).getSelector();
                    if (selector == SortedSetSelector.Type.MIN) {
                        selectorString = "min";
                    } else if (selector == SortedSetSelector.Type.MIDDLE_MIN) {
                        selectorString = "middle_min";
                    } else if (selector == SortedSetSelector.Type.MIDDLE_MAX) {
                        selectorString = "middle_max";
                    } else if (selector == SortedSetSelector.Type.MAX) {
                        selectorString = "max";
                    } else {
                        throw new IllegalStateException("Unexpected SortedSetSelector type selector: " + selector);
                    }
                    SimpleTextUtil.write((DataOutput)output, SI_SELECTOR_TYPE);
                    SimpleTextUtil.write((DataOutput)output, selectorString, scratch);
                    SimpleTextUtil.writeNewline((DataOutput)output);
                } else if (sortField instanceof SortedNumericSortField) {
                    selector = ((SortedNumericSortField)sortField).getSelector();
                    if (selector == SortedNumericSelector.Type.MIN) {
                        selectorString = "min";
                    } else if (selector == SortedNumericSelector.Type.MAX) {
                        selectorString = "max";
                    } else {
                        throw new IllegalStateException("Unexpected SortedNumericSelector type selector: " + selector);
                    }
                    SimpleTextUtil.write((DataOutput)output, SI_SELECTOR_TYPE);
                    SimpleTextUtil.write((DataOutput)output, selectorString, scratch);
                    SimpleTextUtil.writeNewline((DataOutput)output);
                }
                SimpleTextUtil.write((DataOutput)output, SI_SORT_REVERSE);
                SimpleTextUtil.write((DataOutput)output, Boolean.toString(sortField.getReverse()), scratch);
                SimpleTextUtil.writeNewline((DataOutput)output);
                SimpleTextUtil.write((DataOutput)output, SI_SORT_MISSING);
                Object missingValue = sortField.getMissingValue();
                String missing = missingValue == null ? "null" : (missingValue == SortField.STRING_FIRST ? "first" : (missingValue == SortField.STRING_LAST ? "last" : missingValue.toString()));
                SimpleTextUtil.write((DataOutput)output, missing, scratch);
                SimpleTextUtil.writeNewline((DataOutput)output);
            }
            SimpleTextUtil.writeChecksum(output, scratch);
        }
    }
}

