/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.grouping;

import java.io.IOException;
import java.util.Collection;
import org.apache.lucene.search.SimpleCollector;
import org.apache.lucene.util.FixedBitSet;

public abstract class AllGroupHeadsCollector<T>
extends SimpleCollector {
    protected final int[] reversed;
    protected final int compIDXEnd;
    protected final TemporalResult temporalResult;

    protected AllGroupHeadsCollector(int numberOfSorts) {
        this.reversed = new int[numberOfSorts];
        this.compIDXEnd = numberOfSorts - 1;
        this.temporalResult = new TemporalResult();
    }

    public FixedBitSet retrieveGroupHeads(int maxDoc) {
        FixedBitSet bitSet = new FixedBitSet(maxDoc);
        Collection<GroupHead<T>> groupHeads = this.getCollectedGroupHeads();
        for (GroupHead<T> groupHead : groupHeads) {
            bitSet.set(groupHead.doc);
        }
        return bitSet;
    }

    public int[] retrieveGroupHeads() {
        Collection<GroupHead<T>> groupHeads = this.getCollectedGroupHeads();
        int[] docHeads = new int[groupHeads.size()];
        int i = 0;
        for (GroupHead<T> groupHead : groupHeads) {
            docHeads[i++] = groupHead.doc;
        }
        return docHeads;
    }

    public int groupHeadsSize() {
        return this.getCollectedGroupHeads().size();
    }

    protected abstract void retrieveGroupHeadAndAddIfNotExist(int var1) throws IOException;

    protected abstract Collection<? extends GroupHead<T>> getCollectedGroupHeads();

    public void collect(int doc) throws IOException {
        this.retrieveGroupHeadAndAddIfNotExist(doc);
        if (this.temporalResult.stop) {
            return;
        }
        GroupHead groupHead = this.temporalResult.groupHead;
        int compIDX = 0;
        while (true) {
            int c;
            if ((c = this.reversed[compIDX] * groupHead.compare(compIDX, doc)) < 0) {
                return;
            }
            if (c > 0) break;
            if (compIDX == this.compIDXEnd) {
                return;
            }
            ++compIDX;
        }
        groupHead.updateDocHead(doc);
    }

    public static abstract class GroupHead<T> {
        public final T groupValue;
        public int doc;

        protected GroupHead(T groupValue, int doc) {
            this.groupValue = groupValue;
            this.doc = doc;
        }

        protected abstract int compare(int var1, int var2) throws IOException;

        protected abstract void updateDocHead(int var1) throws IOException;
    }

    protected class TemporalResult {
        public GroupHead<T> groupHead;
        public boolean stop;

        protected TemporalResult() {
        }
    }
}

