/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.spatial.util;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.queries.function.FunctionValues;
import org.apache.lucene.queries.function.ValueSource;
import org.apache.lucene.spatial.util.ShapeFieldCache;
import org.apache.lucene.spatial.util.ShapeFieldCacheProvider;
import org.locationtech.spatial4j.context.SpatialContext;
import org.locationtech.spatial4j.distance.DistanceCalculator;
import org.locationtech.spatial4j.shape.Point;

public class ShapeFieldCacheDistanceValueSource
extends ValueSource {
    private final SpatialContext ctx;
    private final Point from;
    private final ShapeFieldCacheProvider<Point> provider;
    private final double multiplier;

    public ShapeFieldCacheDistanceValueSource(SpatialContext ctx, ShapeFieldCacheProvider<Point> provider, Point from, double multiplier) {
        this.ctx = ctx;
        this.from = from;
        this.provider = provider;
        this.multiplier = multiplier;
    }

    public String description() {
        return ((Object)((Object)this)).getClass().getSimpleName() + "(" + this.provider + ", " + this.from + ")";
    }

    public FunctionValues getValues(Map context, final LeafReaderContext readerContext) throws IOException {
        return new FunctionValues(){
            private final ShapeFieldCache<Point> cache;
            private final Point from;
            private final DistanceCalculator calculator;
            private final double nullValue;
            {
                this.cache = ShapeFieldCacheDistanceValueSource.this.provider.getCache(readerContext.reader());
                this.from = ShapeFieldCacheDistanceValueSource.this.from;
                this.calculator = ShapeFieldCacheDistanceValueSource.this.ctx.getDistCalc();
                this.nullValue = ShapeFieldCacheDistanceValueSource.this.ctx.isGeo() ? 180.0 * ShapeFieldCacheDistanceValueSource.this.multiplier : Double.MAX_VALUE;
            }

            public float floatVal(int doc) {
                return (float)this.doubleVal(doc);
            }

            public double doubleVal(int doc) {
                List<Point> vals = this.cache.getShapes(doc);
                if (vals != null) {
                    double v = this.calculator.distance(this.from, vals.get(0));
                    for (int i = 1; i < vals.size(); ++i) {
                        v = Math.min(v, this.calculator.distance(this.from, vals.get(i)));
                    }
                    return v * ShapeFieldCacheDistanceValueSource.this.multiplier;
                }
                return this.nullValue;
            }

            public String toString(int doc) {
                return ShapeFieldCacheDistanceValueSource.this.description() + "=" + this.floatVal(doc);
            }
        };
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        ShapeFieldCacheDistanceValueSource that = (ShapeFieldCacheDistanceValueSource)((Object)o);
        if (!this.ctx.equals(that.ctx)) {
            return false;
        }
        if (!this.from.equals(that.from)) {
            return false;
        }
        if (!this.provider.equals(that.provider)) {
            return false;
        }
        return this.multiplier == that.multiplier;
    }

    public int hashCode() {
        return this.from.hashCode();
    }
}

