/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.reteoo;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.drools.core.common.BaseNode;
import org.drools.core.common.DroolsObjectInputStream;
import org.drools.core.common.DroolsObjectOutputStream;
import org.drools.core.common.InternalWorkingMemory;
import org.drools.core.common.MemoryFactory;
import org.drools.core.common.NetworkNode;
import org.drools.core.definitions.rule.impl.RuleImpl;
import org.drools.core.impl.InternalKnowledgeBase;
import org.drools.core.phreak.AddRemoveRule;
import org.drools.core.reteoo.AbstractTerminalNode;
import org.drools.core.reteoo.AlphaNode;
import org.drools.core.reteoo.BetaNode;
import org.drools.core.reteoo.EvalConditionNode;
import org.drools.core.reteoo.LeftInputAdapterNode;
import org.drools.core.reteoo.LeftTupleNode;
import org.drools.core.reteoo.LeftTupleSink;
import org.drools.core.reteoo.NodeSet;
import org.drools.core.reteoo.NodeTypeEnums;
import org.drools.core.reteoo.ObjectSink;
import org.drools.core.reteoo.ObjectSource;
import org.drools.core.reteoo.PathEndNode;
import org.drools.core.reteoo.RuleBuilder;
import org.drools.core.reteoo.RuleRemovalContext;
import org.drools.core.reteoo.RuleTerminalNode;
import org.drools.core.reteoo.TerminalNode;
import org.drools.core.reteoo.WindowNode;
import org.drools.core.rule.WindowDeclaration;
import org.kie.api.definition.rule.Rule;

public class ReteooBuilder
implements Externalizable {
    private static final long serialVersionUID = 510L;
    private transient InternalKnowledgeBase kBase;
    private Map<String, BaseNode[]> rules;
    private Map<String, BaseNode[]> queries;
    private Map<String, WindowNode> namedWindows;
    private transient RuleBuilder ruleBuilder;
    private IdGenerator idGenerator;

    public ReteooBuilder() {
    }

    public ReteooBuilder(InternalKnowledgeBase kBase) {
        this.kBase = kBase;
        this.rules = new HashMap<String, BaseNode[]>();
        this.queries = new HashMap<String, BaseNode[]>();
        this.namedWindows = new HashMap<String, WindowNode>();
        this.idGenerator = new IdGenerator();
        this.ruleBuilder = kBase.getConfiguration().getComponentFactory().getRuleBuilderFactory().newRuleBuilder();
    }

    public synchronized void addRule(RuleImpl rule) {
        List<TerminalNode> terminals = this.ruleBuilder.addRule(rule, this.kBase);
        BaseNode[] nodes = terminals.toArray(new BaseNode[terminals.size()]);
        this.rules.put(rule.getFullyQualifiedName(), nodes);
        if (rule.isQuery()) {
            this.queries.put(rule.getName(), nodes);
        }
    }

    public void addEntryPoint(String id) {
        this.ruleBuilder.addEntryPoint(id, this.kBase);
    }

    public synchronized void addNamedWindow(WindowDeclaration window) {
        WindowNode wnode = this.ruleBuilder.addWindowNode(window, this.kBase);
        this.namedWindows.put(window.getName(), wnode);
    }

    public WindowNode getWindowNode(String name) {
        return this.namedWindows.get(name);
    }

    public IdGenerator getIdGenerator() {
        return this.idGenerator;
    }

    public synchronized BaseNode[] getTerminalNodes(RuleImpl rule) {
        return this.getTerminalNodes(rule.getFullyQualifiedName());
    }

    public synchronized BaseNode[] getTerminalNodes(String ruleName) {
        return this.rules.get(ruleName);
    }

    public synchronized BaseNode[] getTerminalNodesForQuery(String ruleName) {
        BaseNode[] nodes = this.queries.get(ruleName);
        return nodes != null ? nodes : this.getTerminalNodes(ruleName);
    }

    public synchronized Map<String, BaseNode[]> getTerminalNodes() {
        return this.rules;
    }

    public synchronized void removeRules(Collection<RuleImpl> rulesToBeRemoved) {
        Collection<InternalWorkingMemory> workingMemories = this.kBase.getWorkingMemories();
        for (RuleImpl rule : rulesToBeRemoved) {
            if (rule.hasChildren() && !rulesToBeRemoved.containsAll(rule.getChildren())) {
                throw new RuntimeException("Cannot remove parent rule " + rule + " without having removed all its chikdren");
            }
            RuleRemovalContext context = new RuleRemovalContext(rule);
            context.setKnowledgeBase(this.kBase);
            BaseNode[] rulesTerminalNodes = this.rules.remove(rule.getFullyQualifiedName());
            if (rulesTerminalNodes == null) continue;
            for (BaseNode node : rulesTerminalNodes) {
                this.removeTerminalNode(context, (TerminalNode)((Object)node), workingMemories);
            }
            if (rule.isQuery()) {
                this.queries.remove(rule.getName());
            }
            if (rule.getParent() == null || rulesToBeRemoved.contains(rule.getParent())) continue;
            rule.getParent().removeChild(rule);
        }
    }

    public void removeTerminalNode(RuleRemovalContext context, TerminalNode tn, Collection<InternalWorkingMemory> workingMemories) {
        AddRemoveRule.removeRule(tn, workingMemories, this.kBase);
        BaseNode node = (BaseNode)((Object)tn);
        this.removeNodeAssociation(node, (Rule)context.getRule(), new HashSet<Integer>());
        this.resetMasks(this.removeNodes((AbstractTerminalNode)tn, workingMemories, context));
    }

    private Collection<BaseNode> removeNodes(AbstractTerminalNode terminalNode, Collection<InternalWorkingMemory> wms, RuleRemovalContext context) {
        HashMap<Integer, BaseNode> stillInUse = new HashMap<Integer, BaseNode>();
        HashSet<ObjectSource> alphas = new HashSet<ObjectSource>();
        this.removePath(wms, context, stillInUse, alphas, terminalNode);
        HashSet<Integer> removedNodes = new HashSet<Integer>();
        for (ObjectSource alpha : alphas) {
            this.removeObjectSource(wms, stillInUse, removedNodes, alpha, context);
        }
        return stillInUse.values();
    }

    private void removePath(Collection<InternalWorkingMemory> wms, RuleRemovalContext context, Map<Integer, BaseNode> stillInUse, Collection<ObjectSource> alphas, PathEndNode endNode) {
        LeftTupleNode[] nodes = endNode.getPathNodes();
        for (int i = endNode.getPositionInPath(); i >= 0; --i) {
            BaseNode node = (BaseNode)((Object)nodes[i]);
            boolean removed = false;
            if (NodeTypeEnums.isLeftTupleNode(node)) {
                removed = this.removeLeftTupleNode(wms, context, stillInUse, node);
            }
            if (removed) {
                if (NodeTypeEnums.isBetaNode(node) && !((BetaNode)node).isRightInputIsRiaNode()) {
                    alphas.add(((BetaNode)node).getRightInput());
                } else if (node.getType() == 120) {
                    alphas.add(((LeftInputAdapterNode)node).getObjectSource());
                }
            }
            if (!NodeTypeEnums.isBetaNode(node) || !((BetaNode)node).isRightInputIsRiaNode()) continue;
            endNode = (PathEndNode)((Object)((BetaNode)node).getRightInput());
            this.removePath(wms, context, stillInUse, alphas, endNode);
            return;
        }
    }

    private boolean removeLeftTupleNode(Collection<InternalWorkingMemory> wms, RuleRemovalContext context, Map<Integer, BaseNode> stillInUse, BaseNode node) {
        boolean removed = node.remove(context, this);
        if (removed) {
            stillInUse.remove(node.getId());
            for (InternalWorkingMemory workingMemory : wms) {
                workingMemory.clearNodeMemory((MemoryFactory)((Object)node));
            }
        } else {
            stillInUse.put(node.getId(), node);
        }
        return removed;
    }

    private void removeObjectSource(Collection<InternalWorkingMemory> wms, Map<Integer, BaseNode> stillInUse, Set<Integer> removedNodes, ObjectSource node, RuleRemovalContext context) {
        if (removedNodes.contains(node.getId())) {
            return;
        }
        ObjectSource parent = node.getParentObjectSource();
        boolean removed = node.remove(context, this);
        if (!removed) {
            stillInUse.put(node.getId(), node);
        } else {
            stillInUse.remove(node.getId());
            removedNodes.add(node.getId());
            if (node.getType() != 30 && node.getType() != 40) {
                for (InternalWorkingMemory workingMemory : wms) {
                    workingMemory.clearNodeMemory((MemoryFactory)((Object)node));
                }
            }
            if (parent != null && parent.getType() != 10) {
                this.removeObjectSource(wms, stillInUse, removedNodes, parent, context);
            }
        }
    }

    private void removeNodeAssociation(BaseNode node, Rule rule, Set<Integer> removedNodes) {
        if (node == null || !removedNodes.add(node.getId()) || !node.removeAssociation(rule)) {
            return;
        }
        if (node instanceof LeftTupleNode) {
            this.removeNodeAssociation(((LeftTupleNode)((Object)node)).getLeftTupleSource(), rule, removedNodes);
        }
        if (NodeTypeEnums.isBetaNode(node)) {
            this.removeNodeAssociation(((BetaNode)node).getRightInput(), rule, removedNodes);
        } else if (node.getType() == 120) {
            this.removeNodeAssociation(((LeftInputAdapterNode)node).getObjectSource(), rule, removedNodes);
        } else if (node.getType() == 40) {
            this.removeNodeAssociation(((AlphaNode)node).getParentObjectSource(), rule, removedNodes);
        }
    }

    private void resetMasks(Collection<BaseNode> nodes) {
        NodeSet leafSet = new NodeSet();
        for (BaseNode node : nodes) {
            RuleTerminalNode rtNode;
            if (node.getType() == 40) {
                ObjectSource source = (AlphaNode)node;
                while (true) {
                    source.resetInferredMask();
                    ObjectSource parent = source.getParentObjectSource();
                    if (parent.getType() != 40) break;
                    source = parent;
                }
                this.updateLeafSet(source, leafSet);
                continue;
            }
            if (NodeTypeEnums.isBetaNode(node)) {
                BetaNode betaNode = (BetaNode)node;
                if (!betaNode.isInUse()) continue;
                leafSet.add(betaNode);
                continue;
            }
            if (!NodeTypeEnums.isTerminalNode(node) || !(rtNode = (RuleTerminalNode)node).isInUse()) continue;
            leafSet.add(rtNode);
        }
        for (BaseNode node : leafSet) {
            if (NodeTypeEnums.isTerminalNode(node)) {
                ((TerminalNode)((Object)node)).initInferredMask();
                continue;
            }
            ((BetaNode)node).initInferredMask();
        }
    }

    private void updateLeafSet(BaseNode baseNode, NodeSet leafSet) {
        if (baseNode.getType() == 40) {
            for (ObjectSink sink : ((AlphaNode)baseNode).getObjectSinkPropagator().getSinks()) {
                if (!((BaseNode)((Object)sink)).isInUse()) continue;
                this.updateLeafSet((BaseNode)((Object)sink), leafSet);
            }
        } else if (baseNode.getType() == 120) {
            for (LeftTupleSink sink : ((LeftInputAdapterNode)baseNode).getSinkPropagator().getSinks()) {
                if (sink.getType() == 101) {
                    leafSet.add((BaseNode)((Object)sink));
                    continue;
                }
                if (!((BaseNode)((Object)sink)).isInUse()) continue;
                this.updateLeafSet((BaseNode)((Object)sink), leafSet);
            }
        } else if (baseNode.getType() == 131) {
            for (LeftTupleSink sink : ((EvalConditionNode)baseNode).getSinkPropagator().getSinks()) {
                if (!((BaseNode)((Object)sink)).isInUse()) continue;
                this.updateLeafSet((BaseNode)((Object)sink), leafSet);
            }
        } else if (NodeTypeEnums.isBetaNode(baseNode) && baseNode.isInUse()) {
            leafSet.add(baseNode);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        DroolsObjectOutputStream droolsStream;
        ByteArrayOutputStream bytes;
        if (out instanceof DroolsObjectOutputStream) {
            bytes = null;
            droolsStream = (DroolsObjectOutputStream)out;
        } else {
            bytes = new ByteArrayOutputStream();
            droolsStream = new DroolsObjectOutputStream(bytes);
        }
        try {
            droolsStream.writeObject(this.rules);
            droolsStream.writeObject(this.queries);
            droolsStream.writeObject(this.namedWindows);
            droolsStream.writeObject(this.idGenerator);
        }
        finally {
            if (bytes != null) {
                droolsStream.flush();
                droolsStream.close();
                bytes.close();
                out.writeInt(bytes.size());
                out.writeObject(bytes.toByteArray());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        DroolsObjectInputStream droolsStream;
        ByteArrayInputStream bytes;
        if (in instanceof DroolsObjectInputStream) {
            bytes = null;
            droolsStream = (DroolsObjectInputStream)in;
        } else {
            bytes = new ByteArrayInputStream((byte[])in.readObject());
            droolsStream = new DroolsObjectInputStream(bytes);
        }
        try {
            this.rules = (Map)droolsStream.readObject();
            this.queries = (Map)droolsStream.readObject();
            this.namedWindows = (Map)droolsStream.readObject();
            this.idGenerator = (IdGenerator)droolsStream.readObject();
        }
        finally {
            if (bytes != null) {
                droolsStream.close();
                bytes.close();
            }
        }
    }

    public void setRuleBase(InternalKnowledgeBase kBase) {
        this.kBase = kBase;
        this.ruleBuilder = kBase.getConfiguration().getComponentFactory().getRuleBuilderFactory().newRuleBuilder();
    }

    private static class InternalIdGenerator
    implements Externalizable {
        private static final long serialVersionUID = 510L;
        private Queue<Integer> recycledIds;
        private int nextId;

        public InternalIdGenerator() {
        }

        public InternalIdGenerator(int firstId) {
            this.nextId = firstId;
            this.recycledIds = new LinkedList<Integer>();
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.recycledIds = (Queue)in.readObject();
            this.nextId = in.readInt();
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeObject(this.recycledIds);
            out.writeInt(this.nextId);
        }

        public synchronized int getNextId() {
            int n;
            Integer id = this.recycledIds.poll();
            if (id == null) {
                int n2 = this.nextId;
                n = n2;
                this.nextId = n2 + 1;
            } else {
                n = id;
            }
            return n;
        }

        public synchronized void releaseId(int id) {
            this.recycledIds.add(id);
        }

        public int getLastId() {
            return this.nextId - 1;
        }
    }

    public static class IdGenerator
    implements Externalizable {
        private InternalIdGenerator defaultGenerator = new InternalIdGenerator(1);
        private Map<String, InternalIdGenerator> generators = new ConcurrentHashMap<String, InternalIdGenerator>();

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.defaultGenerator = (InternalIdGenerator)in.readObject();
            this.generators = (Map)in.readObject();
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeObject(this.defaultGenerator);
            out.writeObject(this.generators);
        }

        public int getNextId() {
            return this.defaultGenerator.getNextId();
        }

        public int getNextId(String topic) {
            return this.generators.computeIfAbsent(topic, key -> new InternalIdGenerator(1)).getNextId();
        }

        public synchronized void releaseId(NetworkNode node) {
            this.defaultGenerator.releaseId(node.getId());
            if (node instanceof MemoryFactory) {
                this.generators.get("DEFAULT_RULE_UNIT").releaseId(((MemoryFactory)((Object)node)).getMemoryId());
            }
        }

        public int getLastId() {
            return this.defaultGenerator.getLastId();
        }

        public int getLastId(String topic) {
            InternalIdGenerator gen = this.generators.get(topic);
            return gen != null ? gen.getLastId() : 0;
        }
    }
}

