/*
 * Decompiled with CFR 0.152.
 */
package org.drools.decisiontable.parser;

import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.drools.template.model.Global;
import org.drools.template.model.Import;
import org.drools.template.parser.DecisionTableParseException;

public class RuleSheetParserUtil {
    private RuleSheetParserUtil() {
    }

    public static String getRuleName(String ruleRow) {
        String testVal = ruleRow.toLowerCase();
        int left = testVal.indexOf("ruletable");
        return ruleRow.substring(left + "ruletable".length()).trim();
    }

    private static void invalidRuleTableDef(String ruleRow) {
        throw new IllegalArgumentException("Invalid rule table header cell. Should be in the format of 'RuleTable YourRuleName'. It was: \n [" + ruleRow + "] \n");
    }

    public static List<Import> getImportList(List<String> importCells) {
        ArrayList<Import> importList = new ArrayList<Import>();
        if (importCells == null) {
            return importList;
        }
        for (String importCell : importCells) {
            StringTokenizer tokens = new StringTokenizer(importCell, ",");
            while (tokens.hasMoreTokens()) {
                Import imp = new Import();
                imp.setClassName(tokens.nextToken().trim());
                importList.add(imp);
            }
        }
        return importList;
    }

    public static List<Global> getVariableList(List<String> variableCells) {
        ArrayList<Global> variableList = new ArrayList<Global>();
        if (variableCells == null) {
            return variableList;
        }
        for (String variableCell : variableCells) {
            StringTokenizer tokens = new StringTokenizer(variableCell, ",");
            while (tokens.hasMoreTokens()) {
                String token = tokens.nextToken();
                Global vars = new Global();
                StringTokenizer paramTokens = new StringTokenizer(token, " ");
                vars.setClassName(paramTokens.nextToken());
                if (!paramTokens.hasMoreTokens()) {
                    throw new DecisionTableParseException("The format for global variables is incorrect. It should be: [Class name, Class otherName]. But it was: [" + variableCell + "]");
                }
                vars.setIdentifier(paramTokens.nextToken());
                variableList.add(vars);
            }
        }
        return variableList;
    }

    public static boolean isStringMeaningTrue(String property) {
        if (property == null) {
            return false;
        }
        if ((property = property.trim()).equalsIgnoreCase("true")) {
            return true;
        }
        if (property.startsWith("Y")) {
            return true;
        }
        if (property.startsWith("y")) {
            return true;
        }
        return property.equalsIgnoreCase("on");
    }

    public static String rc2name(int row, int col) {
        StringBuilder sb = new StringBuilder();
        int b = 26;
        int p = 1;
        if (col >= b) {
            col -= b;
            p *= b;
        }
        if (col >= b * b) {
            col -= b * b;
            p *= b;
        }
        while (p > 0) {
            sb.append((char)(col / p + 65));
            col %= p;
            p /= b;
        }
        sb.append(row + 1);
        return sb.toString();
    }
}

