/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.metadata.backend.infinispan.provider;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import org.apache.lucene.analysis.Analyzer;
import org.uberfire.ext.metadata.analyzer.ElasticSearchAnalyzerWrapper;
import org.uberfire.ext.metadata.backend.infinispan.proto.schema.Field;
import org.uberfire.ext.metadata.backend.infinispan.proto.schema.Message;
import org.uberfire.ext.metadata.backend.infinispan.proto.schema.ProtobufScope;
import org.uberfire.ext.metadata.backend.infinispan.proto.schema.ProtobufType;
import org.uberfire.ext.metadata.backend.infinispan.proto.schema.Schema;
import org.uberfire.ext.metadata.backend.infinispan.utils.AttributesUtil;
import org.uberfire.ext.metadata.model.KObject;
import org.uberfire.ext.metadata.model.KProperty;
import org.uberfire.ext.metadata.model.impl.KPropertyImpl;
import org.uberfire.java.nio.base.version.VersionHistory;
import org.uberfire.java.nio.base.version.VersionRecord;
import org.uberfire.java.nio.file.attribute.FileTime;

public class MappingProvider {
    public static final String ORG_KIE = "org.kie";
    private Analyzer analyzer;

    public MappingProvider(Analyzer analyzer) {
        this.analyzer = analyzer;
    }

    public Schema getMapping(KObject kObject) {
        return this.buildSchema(kObject);
    }

    private Schema buildSchema(KObject kObject) {
        return new Schema(kObject.getClusterId(), ORG_KIE, this.buildMessages(kObject));
    }

    public Schema buildSchema(KObject kObject, Set<Message> messages) {
        return new Schema(kObject.getClusterId(), ORG_KIE, messages);
    }

    public Set<Message> buildMessages(KObject kObject) {
        ArrayList<Field> fields = new ArrayList<Field>();
        fields.add(this.createField(ProtobufScope.OPTIONAL, ProtobufType.STRING, "id"));
        fields.add(this.createField(ProtobufScope.REQUIRED, ProtobufType.STRING, "type"));
        fields.add(this.createField(ProtobufScope.REQUIRED, ProtobufType.STRING, "cluster__id"));
        fields.add(this.createField(ProtobufScope.REQUIRED, ProtobufType.STRING, "segment__id"));
        fields.add(this.createField(ProtobufScope.REQUIRED, ProtobufType.STRING, "key"));
        fields.add(this.createField(ProtobufScope.OPTIONAL, ProtobufType.STRING, "fullText", true, true));
        for (KProperty prop : kObject.getProperties()) {
            fields.addAll(this.build(prop));
        }
        Message message = new Message(this.sanitize(kObject.getClusterId() + "_" + kObject.getType().getName()), new HashSet<Field>(fields));
        return Collections.singleton(message);
    }

    private String sanitize(String name) {
        return AttributesUtil.toProtobufFormat(name);
    }

    private Set<Field> build(KProperty<?> prop) {
        Class<?> aClass = prop.getValue().getClass();
        if (Enum.class.isAssignableFrom(aClass)) {
            return this.buildDefaultField(prop, ProtobufType.STRING);
        }
        if (aClass == String.class) {
            return this.buildDefaultField(prop, ProtobufType.STRING);
        }
        if (aClass == Boolean.class) {
            return this.buildDefaultField(prop, ProtobufType.BOOL);
        }
        if (aClass == Integer.class) {
            return this.buildDefaultField(prop, ProtobufType.INT32);
        }
        if (aClass == Double.class) {
            return this.buildDefaultField(prop, ProtobufType.DOUBLE);
        }
        if (aClass == Long.class) {
            return this.buildDefaultField(prop, ProtobufType.INT64);
        }
        if (aClass == Float.class) {
            return this.buildDefaultField(prop, ProtobufType.FLOAT);
        }
        if (FileTime.class.isAssignableFrom(aClass)) {
            return this.buildDefaultField(prop, ProtobufType.INT64);
        }
        if (Date.class.isAssignableFrom(aClass)) {
            return this.buildDefaultField(prop, ProtobufType.INT64);
        }
        if (VersionHistory.class.isAssignableFrom(aClass)) {
            return this.build((VersionHistory)prop.getValue());
        }
        if (Collection.class.isAssignableFrom(aClass)) {
            return this.buildDefaultField(prop, ProtobufType.STRING);
        }
        return this.buildDefaultField(prop, ProtobufType.STRING);
    }

    private Set<Field> buildDefaultField(KProperty<?> prop, ProtobufType int32) {
        return Collections.singleton(this.createField(ProtobufScope.OPTIONAL, int32, this.sanitize(prop.getName()), prop.isSortable(), prop.isSearchable()));
    }

    private Set<Field> build(VersionHistory versionHistory) {
        HashSet<Field> fields = new HashSet<Field>();
        if (versionHistory.records().size() != 0) {
            int lastIndex = versionHistory.records().size() - 1;
            fields.addAll(this.build((KProperty<?>)new KPropertyImpl("checkinComment", (Object)((VersionRecord)versionHistory.records().get(lastIndex)).comment(), true)));
            fields.addAll(this.build((KProperty<?>)new KPropertyImpl("createdBy", (Object)((VersionRecord)versionHistory.records().get(0)).author(), true)));
            fields.addAll(this.build((KProperty<?>)new KPropertyImpl("createdDate", (Object)((VersionRecord)versionHistory.records().get(0)).date(), true)));
            fields.addAll(this.build((KProperty<?>)new KPropertyImpl("lastModifiedBy", (Object)((VersionRecord)versionHistory.records().get(lastIndex)).author(), true)));
            fields.addAll(this.build((KProperty<?>)new KPropertyImpl("lastModifiedDate", (Object)((VersionRecord)versionHistory.records().get(lastIndex)).date(), true)));
        }
        return fields;
    }

    private String createAnalyzerField(Field field) {
        return this.createAnalyzerField(field.getName(), field.getType(), field.isSearchable());
    }

    private String createAnalyzerField(String name, String type, boolean isSearchable) {
        if (this.analyzer instanceof ElasticSearchAnalyzerWrapper) {
            if (ProtobufType.STRING.name().toLowerCase().equals(type.toLowerCase()) && isSearchable) {
                ElasticSearchAnalyzerWrapper elasticSearchAnalyzerWrapper = (ElasticSearchAnalyzerWrapper)this.analyzer;
                return elasticSearchAnalyzerWrapper.getFieldAnalyzer(name);
            }
        } else {
            throw new IllegalArgumentException("ElasticSearchAnalyzerWrapper is expected to be compatible with Elasticsearch");
        }
        return "";
    }

    private Field createField(ProtobufScope scope, ProtobufType type, String name) {
        return new Field(scope, type, name, this.createAnalyzerField(name, type.toString(), false));
    }

    private Field createField(ProtobufScope scope, ProtobufType type, String name, boolean sortable, boolean searchable) {
        return new Field(scope, type, name, sortable, searchable, this.createAnalyzerField(name, type.toString(), searchable));
    }
}

