/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.solver.termination;

import java.util.Arrays;
import org.optaplanner.core.api.score.Score;
import org.optaplanner.core.impl.phase.scope.AbstractPhaseScope;
import org.optaplanner.core.impl.score.ScoreUtils;
import org.optaplanner.core.impl.score.definition.ScoreDefinition;
import org.optaplanner.core.impl.solver.scope.DefaultSolverScope;
import org.optaplanner.core.impl.solver.termination.AbstractTermination;
import org.optaplanner.core.impl.solver.termination.Termination;
import org.optaplanner.core.impl.solver.thread.ChildThreadType;

public class BestScoreFeasibleTermination
extends AbstractTermination {
    private final int feasibleLevelsSize;
    private final double[] timeGradientWeightFeasibleNumbers;

    public BestScoreFeasibleTermination(ScoreDefinition scoreDefinition, double[] timeGradientWeightFeasibleNumbers) {
        this.feasibleLevelsSize = scoreDefinition.getFeasibleLevelsSize();
        this.timeGradientWeightFeasibleNumbers = timeGradientWeightFeasibleNumbers;
        if (timeGradientWeightFeasibleNumbers.length != this.feasibleLevelsSize - 1) {
            throw new IllegalStateException("The timeGradientWeightNumbers (" + Arrays.toString(timeGradientWeightFeasibleNumbers) + ")'s length (" + timeGradientWeightFeasibleNumbers.length + ") is not 1 less than the feasibleLevelsSize (" + scoreDefinition.getFeasibleLevelsSize() + ").");
        }
    }

    @Override
    public boolean isSolverTerminated(DefaultSolverScope solverScope) {
        return this.isTerminated(solverScope.getBestScore());
    }

    @Override
    public boolean isPhaseTerminated(AbstractPhaseScope phaseScope) {
        return this.isTerminated(phaseScope.getBestScore());
    }

    protected boolean isTerminated(Score bestScore) {
        return bestScore.isFeasible();
    }

    @Override
    public double calculateSolverTimeGradient(DefaultSolverScope solverScope) {
        return this.calculateFeasibilityTimeGradient(solverScope.getStartingInitializedScore(), solverScope.getBestScore());
    }

    @Override
    public double calculatePhaseTimeGradient(AbstractPhaseScope phaseScope) {
        return this.calculateFeasibilityTimeGradient(phaseScope.getStartingScore(), phaseScope.getBestScore());
    }

    protected double calculateFeasibilityTimeGradient(Score startScore, Score score) {
        if (startScore == null || !startScore.isSolutionInitialized()) {
            return 0.0;
        }
        Object totalDiff = startScore.negate();
        Number[] totalDiffNumbers = totalDiff.toLevelNumbers();
        Score scoreDiff = score.subtract(startScore);
        Number[] scoreDiffNumbers = scoreDiff.toLevelNumbers();
        if (scoreDiffNumbers.length != totalDiffNumbers.length) {
            throw new IllegalStateException("The startScore (" + startScore + ") and score (" + score + ") don't have the same levelsSize.");
        }
        return ScoreUtils.calculateTimeGradient(totalDiffNumbers, scoreDiffNumbers, this.timeGradientWeightFeasibleNumbers, this.feasibleLevelsSize);
    }

    @Override
    public Termination createChildThreadTermination(DefaultSolverScope solverScope, ChildThreadType childThreadType) {
        throw new UnsupportedOperationException("This terminationClass (" + this.getClass() + ") does not yet support being used in child threads of type (" + (Object)((Object)childThreadType) + ").");
    }

    public String toString() {
        return "BestScoreFeasible()";
    }
}

