/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.services.taskassigning.runtime.command;

import java.util.Arrays;
import org.jbpm.services.task.commands.DelegateTaskCommand;
import org.kie.api.runtime.Context;
import org.kie.api.task.model.OrganizationalEntity;
import org.kie.api.task.model.Status;
import org.kie.api.task.model.Task;
import org.kie.api.task.model.TaskData;
import org.kie.api.task.model.User;
import org.kie.server.api.model.taskassigning.PlanningExecutionResult;
import org.kie.server.api.model.taskassigning.PlanningItem;
import org.kie.server.services.taskassigning.runtime.command.PlanningCommand;
import org.kie.server.services.taskassigning.runtime.command.PlanningException;

public class DelegateAndSaveCommand
extends PlanningCommand {
    static final String TASK_MODIFIED_ERROR_MSG = "Task: %s was modified by an external action since the last executed plan, current status is %s but the expected should be in %s";

    public DelegateAndSaveCommand(PlanningItem planningItem, String userId) {
        super(planningItem);
        this.userId = userId;
    }

    @Override
    public Void execute(Context context) {
        OrganizationalEntity addedPotentialOwner;
        super.execute(context);
        Task task = this.taskContext.getPersistenceContext().findTask(this.planningItem.getTaskId());
        TaskData taskData = task.getTaskData();
        Status status = taskData.getStatus();
        if (Status.Ready != status && Status.Reserved != status) {
            throw new PlanningException(String.format(TASK_MODIFIED_ERROR_MSG, this.planningItem.getTaskId(), status, Arrays.toString(new Status[]{Status.Ready, Status.Reserved})), this.planningItem.getContainerId(), PlanningExecutionResult.ErrorCode.TASK_MODIFIED_SINCE_PLAN_CALCULATION_ERROR);
        }
        OrganizationalEntity existingPotentialOwner = DelegateAndSaveCommand.findPotentialOwner(task, this.planningItem.getPlanningTask().getAssignedUser());
        DelegateTaskCommand delegateTaskCommand = this.createDelegateCommand(this.planningItem.getTaskId(), this.getUserId(), this.planningItem.getPlanningTask().getAssignedUser());
        delegateTaskCommand.execute(context);
        if (existingPotentialOwner == null && (addedPotentialOwner = DelegateAndSaveCommand.findPotentialOwner(task, this.planningItem.getPlanningTask().getAssignedUser())) != null) {
            task.getPeopleAssignments().getPotentialOwners().remove(addedPotentialOwner);
        }
        this.saveOrUpdatePlanningTask(this.planningItem);
        return null;
    }

    DelegateTaskCommand createDelegateCommand(long taskId, String userId, String targetEntityId) {
        return new DelegateTaskCommand(taskId, userId, targetEntityId);
    }

    private static OrganizationalEntity findPotentialOwner(Task task, String potentialOwnerId) {
        if (task.getPeopleAssignments() != null && task.getPeopleAssignments().getPotentialOwners() != null) {
            return task.getPeopleAssignments().getPotentialOwners().stream().filter(organizationalEntity -> organizationalEntity.getId().equals(potentialOwnerId) && organizationalEntity instanceof User).findFirst().orElse(null);
        }
        return null;
    }
}

