/*
 * Decompiled with CFR 0.152.
 */
package org.kie.spring.persistence;

import javax.persistence.EntityManager;
import org.jbpm.services.task.persistence.JPATaskPersistenceContext;
import org.kie.api.runtime.Environment;
import org.kie.internal.task.api.TaskPersistenceContext;
import org.kie.internal.task.api.TaskPersistenceContextManager;
import org.kie.spring.persistence.AbstractKieSpringJpaManager;
import org.springframework.transaction.support.TransactionSynchronizationManager;

public class KieSpringTaskJpaManager
extends AbstractKieSpringJpaManager
implements TaskPersistenceContextManager {
    public KieSpringTaskJpaManager(Environment env) {
        super(env);
    }

    public TaskPersistenceContext getPersistenceContext() {
        return new JPATaskPersistenceContext((EntityManager)this.env.get("org.kie.api.persistence.jpa.CmdScopedEntityManager"), this.isJTA);
    }

    public void beginCommandScopedEntityManager() {
        EntityManager cmdScopedEntityManager = this.getCommandScopedEntityManager();
        if (this.isJTA) {
            this.getPersistenceContext().joinTransaction();
        }
    }

    @Override
    public void endCommandScopedEntityManager() {
        if (TransactionSynchronizationManager.hasResource((Object)"cmdEM")) {
            EntityManager cmdScopedEntityManager = (EntityManager)this.env.get("org.kie.api.persistence.jpa.CmdScopedEntityManager");
            if (cmdScopedEntityManager != null) {
                cmdScopedEntityManager.clear();
            }
            if (this.env.get("org.kie.api.persistence.jpa.CmdScopedEntityManager") != null) {
                this.getPersistenceContext().close();
            }
            TransactionSynchronizationManager.unbindResource((Object)"cmdEM");
        }
        if (TransactionSynchronizationManager.hasResource((Object)"org.kie.resources")) {
            TransactionSynchronizationManager.unbindResource((Object)"org.kie.resources");
        }
    }
}

