/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.metadata.backend.infinispan.provider;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.security.auth.callback.CallbackHandler;
import org.apache.commons.lang3.StringUtils;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.configuration.AuthenticationConfigurationBuilder;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.infinispan.client.hotrod.configuration.SaslQop;
import org.infinispan.client.hotrod.exceptions.HotRodClientException;
import org.infinispan.client.hotrod.impl.RemoteCacheImpl;
import org.infinispan.client.hotrod.marshall.ProtoStreamMarshaller;
import org.infinispan.commons.CacheConfigurationException;
import org.infinispan.commons.configuration.BasicConfiguration;
import org.infinispan.commons.marshall.Marshaller;
import org.infinispan.protostream.BaseMarshaller;
import org.infinispan.protostream.SerializationContext;
import org.infinispan.protostream.annotations.ProtoSchemaBuilder;
import org.kie.soup.commons.validation.PortablePreconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.commons.lifecycle.Disposable;
import org.uberfire.ext.metadata.backend.infinispan.exceptions.InfinispanException;
import org.uberfire.ext.metadata.backend.infinispan.proto.KObjectMarshaller;
import org.uberfire.ext.metadata.backend.infinispan.proto.schema.Schema;
import org.uberfire.ext.metadata.backend.infinispan.proto.schema.SchemaGenerator;
import org.uberfire.ext.metadata.backend.infinispan.provider.InfinispanConfiguration;
import org.uberfire.ext.metadata.backend.infinispan.provider.InfinispanPingService;
import org.uberfire.ext.metadata.backend.infinispan.provider.KieProtostreamMarshaller;
import org.uberfire.ext.metadata.backend.infinispan.provider.LoginHandler;
import org.uberfire.ext.metadata.backend.infinispan.utils.AttributesUtil;
import org.uberfire.ext.metadata.backend.infinispan.utils.Retry;
import org.uberfire.ext.metadata.model.KObject;

public class InfinispanContext
implements Disposable {
    private static final String PORT = "org.appformer.ext.metadata.infinispan.port";
    private static final String HOST = "org.appformer.ext.metadata.infinispan.host";
    private static final String USERNAME = "org.appformer.ext.metadata.infinispan.username";
    private static final String PASSWORD = "org.appformer.ext.metadata.infinispan.password";
    private static final String REALM = "org.appformer.ext.metadata.infinispan.realm";
    private static final String SERVER_NAME = "org.appformer.ext.metadata.infinispan.server.name";
    private static final String SASL_QOP = "org.appformer.ext.metadata.infinispan.sasl.qop";
    private static final String TYPES_CACHE = "types";
    private static final String SCHEMAS_CACHE = "schemas";
    private static final String PROTO_EXTENSION = ".proto";
    private static final String SCHEMA_PROTO = "schema.proto";
    private static final String ORG_KIE = "org.kie.";
    public static final String SASL_MECHANISM = "DIGEST-MD5";
    private static final String CACHE_PREFIX = "appformer_";
    private final InfinispanPingService pingService;
    private RemoteCacheManager cacheManager;
    private KieProtostreamMarshaller marshaller = new KieProtostreamMarshaller();
    private SchemaGenerator schemaGenerator;
    private InfinispanConfiguration infinispanConfiguration;
    private Logger logger = LoggerFactory.getLogger(InfinispanContext.class);
    private Optional<Runnable> initializationObserver = Optional.empty();

    public static InfinispanContext getInstance() {
        return LazyHolder.INSTANCE;
    }

    private InfinispanContext(Map<String, String> properties) {
        this.infinispanConfiguration = new InfinispanConfiguration();
        this.schemaGenerator = new SchemaGenerator();
        this.cacheManager = this.createRemoteCache(properties);
        this.pingService = new InfinispanPingService((RemoteCacheImpl)this.cacheManager.getCache());
        this.createBaseIndex();
        this.marshaller.registerMarshaller(new KieProtostreamMarshaller.KieMarshallerSupplier<KObject>(){

            @Override
            public String extractTypeFromEntity(KObject entity) {
                return InfinispanContext.ORG_KIE + AttributesUtil.toProtobufFormat(entity.getClusterId() + "_" + entity.getType().getName());
            }

            @Override
            public Class<KObject> getJavaClass() {
                return KObject.class;
            }

            @Override
            public BaseMarshaller<KObject> getMarshallerForType(String typeName) {
                return new KObjectMarshaller(typeName);
            }
        });
        SerializationContext serializationContext = ProtoStreamMarshaller.getSerializationContext((RemoteCacheManager)this.cacheManager);
        this.addProtobufClass(serializationContext, InfinispanContext.addCachePrefix(SCHEMA_PROTO), Schema.class);
        this.retrieveProbufSchemas();
    }

    private void createBaseIndex() {
        if (!this.getIndices().contains(SCHEMAS_CACHE)) {
            this.initializationObserver.orElse(() -> {}).run();
            this.cacheManager.administration().createCache(this.getSchemaCacheName(), (BasicConfiguration)this.infinispanConfiguration.getConfiguration(this.getSchemaCacheName()));
        }
    }

    public void retrieveProbufSchemas() {
        this.loadProtobufSchema(this.getProtobufCache());
    }

    private String getSchemaCacheName() {
        return InfinispanContext.addCachePrefix(SCHEMAS_CACHE);
    }

    private String getTypesCacheName() {
        return InfinispanContext.addCachePrefix(TYPES_CACHE);
    }

    private RemoteCacheManager createRemoteCache(Map<String, String> properties) {
        String host = properties.get(HOST);
        String port = properties.get(PORT);
        try {
            ConfigurationBuilder builder = this.getMaybeSecurityBuilder(properties).addServer().host(host).port(Integer.parseInt(port)).connectionTimeout(5).maxRetries(1).marshaller((Marshaller)new ProtoStreamMarshaller()).marshaller((Marshaller)this.marshaller);
            return new RemoteCacheManager(builder.build());
        }
        catch (Exception e) {
            throw new InfinispanException(MessageFormat.format("Error trying to connect to server <{0}:{1}>", host, port), e);
        }
    }

    private AuthenticationConfigurationBuilder getMaybeSecurityBuilder(Map<String, String> properties) {
        String username = properties.get(USERNAME);
        String password = properties.get(PASSWORD);
        String realm = properties.get(REALM);
        String saslQop = properties.get(SASL_QOP);
        String serverName = properties.get(SERVER_NAME);
        ConfigurationBuilder b = new ConfigurationBuilder();
        if (StringUtils.isNotEmpty((CharSequence)username)) {
            PortablePreconditions.checkNotEmpty((String)"password", (String)password);
            PortablePreconditions.checkNotEmpty((String)"realm", (String)realm);
            PortablePreconditions.checkNotEmpty((String)"qop", (String)saslQop);
            PortablePreconditions.checkNotEmpty((String)"serverName", (String)serverName);
            return b.security().authentication().enable().saslMechanism(SASL_MECHANISM).saslQop(InfinispanContext.buildSaslQop(saslQop)).serverName(serverName).callbackHandler((CallbackHandler)new LoginHandler(username, password.toCharArray(), realm));
        }
        return b.security().authentication().disable();
    }

    protected static SaslQop[] buildSaslQop(String saslQop) {
        return (SaslQop[])Arrays.asList(saslQop.split(",")).stream().map(InfinispanContext::toSaslQop).toArray(SaslQop[]::new);
    }

    protected static SaslQop toSaslQop(String value) {
        try {
            return SaslQop.valueOf((String)value.trim().replace('-', '_').toUpperCase());
        }
        catch (IllegalArgumentException e) {
            List values = Arrays.asList(SaslQop.values()).stream().map(SaslQop::toString).collect(Collectors.toList());
            throw new InfinispanException(MessageFormat.format("SaslQoP option <{0}> is not present in one of this possible values {1}", value, values), e);
        }
    }

    private void addProtobufClass(SerializationContext serializationContext, String protoName, Class<?> clazz) {
        try {
            ProtoSchemaBuilder protoSchemaBuilder = new ProtoSchemaBuilder();
            protoSchemaBuilder.fileName(protoName);
            protoSchemaBuilder.addClass(clazz);
            String schemaString = protoSchemaBuilder.build(serializationContext);
            this.getProtobufCache().put((Object)protoName, (Object)schemaString);
        }
        catch (IOException e) {
            throw new InfinispanException("Can't add protobuf class <" + protoName + "> to cache", e);
        }
    }

    private RemoteCache<String, String> getProtobufCache() {
        return this.cacheManager.getCache("___protobuf_metadata");
    }

    private static String addCachePrefix(String content) {
        return CACHE_PREFIX + content;
    }

    public RemoteCache<String, KObject> getCache(String index) {
        String cacheName = AttributesUtil.toProtobufFormat(index).toLowerCase();
        if (!this.getIndices().contains(cacheName)) {
            String appformerCacheName = InfinispanContext.addCachePrefix(cacheName);
            try {
                this.cacheManager.administration().createCache(appformerCacheName, (BasicConfiguration)this.infinispanConfiguration.getIndexedConfiguration(appformerCacheName));
            }
            catch (HotRodClientException | CacheConfigurationException ex) {
                this.logger.warn("Can't create cache with name <{}>", (Object)appformerCacheName);
                this.logger.warn("Cause:", ex);
            }
        }
        return this.cacheManager.getCache(InfinispanContext.addCachePrefix(cacheName));
    }

    public List<String> getTypes(String index) {
        return this.getSchema(index).map(schema -> schema.getMessages().stream().map(x -> x.getName()).collect(Collectors.toList())).orElse(Collections.emptyList());
    }

    public void addProtobufSchema(String clusterId, Schema schema) {
        try {
            String protoTypeName = AttributesUtil.toProtobufFormat(clusterId);
            RemoteCache<String, String> metadataCache = this.getProtobufCache();
            String proto = this.schemaGenerator.generate(schema);
            this.marshaller.registerSchema(protoTypeName, proto, KObject.class);
            metadataCache.put((Object)(protoTypeName + PROTO_EXTENSION), (Object)proto);
        }
        catch (IOException e) {
            throw new InfinispanException("Can't add protobuf schema <" + schema.getName() + "> to cache", e);
        }
    }

    public void loadProtobufSchema(RemoteCache<String, String> metadataCache) {
        new Retry(5, () -> metadataCache.entrySet().stream().filter(entry -> !((String)entry.getKey()).equals(InfinispanContext.addCachePrefix(SCHEMA_PROTO))).forEach(entry -> {
            int index = ((String)entry.getKey()).lastIndexOf(46);
            String protoTypeName = ((String)entry.getKey()).substring(0, index);
            String proto = (String)entry.getValue();
            try {
                this.marshaller.registerSchema(protoTypeName, proto, KObject.class);
            }
            catch (IOException e) {
                throw new InfinispanException("Can't add protobuf schema <" + protoTypeName + "> to cache", e);
            }
        })).run();
    }

    public void dispose() {
        if (this.cacheManager.isStarted()) {
            this.cacheManager.stop();
            this.pingService.stop();
        }
    }

    public List<String> getIndices() {
        return new ArrayList(this.cacheManager.getCacheNames()).stream().filter(s -> s.startsWith(CACHE_PREFIX)).map(s -> s.substring(CACHE_PREFIX.length())).collect(Collectors.toList());
    }

    public Optional<Schema> getSchema(String clusterId) {
        Schema schema = (Schema)this.getSchemaCache().get((Object)clusterId.toLowerCase());
        return Optional.ofNullable(schema);
    }

    public void addSchema(Schema schema) {
        this.getSchemaCache().put((Object)AttributesUtil.toProtobufFormat(schema.getName()).toLowerCase(), (Object)schema);
    }

    private RemoteCache<Object, Object> getSchemaCache() {
        this.createBaseIndex();
        return this.cacheManager.getCache(this.getSchemaCacheName());
    }

    public boolean isAlive() {
        RemoteCacheImpl remoteCache = (RemoteCacheImpl)this.cacheManager.getCache();
        try {
            boolean isStarted = remoteCache.ping().isSuccess();
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Infinispan server is not started");
            }
            return isStarted;
        }
        catch (Exception e) {
            if (this.logger.isDebugEnabled()) {
                this.logger.error("Infinispan server is not started");
            }
            if (this.logger.isTraceEnabled()) {
                this.logger.error("Infinispan server is not started", (Throwable)e);
            }
            return false;
        }
    }

    public void deleteCache(String index) {
        String cacheName = AttributesUtil.toProtobufFormat(index).toLowerCase();
        this.cacheManager.administration().removeCache(cacheName);
    }

    public void observeInitialization(Runnable runnable) {
        this.initializationObserver = Optional.of(runnable);
    }

    private static final class LazyHolder {
        static final Map<String, String> PROPERTIES = new HashMap<String, String>(){
            {
                this.put(InfinispanContext.HOST, System.getProperty(InfinispanContext.HOST, "127.0.0.1"));
                this.put(InfinispanContext.PORT, System.getProperty(InfinispanContext.PORT, "11222"));
                this.put(InfinispanContext.USERNAME, System.getProperty(InfinispanContext.USERNAME, ""));
                this.put(InfinispanContext.PASSWORD, System.getProperty(InfinispanContext.PASSWORD, ""));
                this.put(InfinispanContext.REALM, System.getProperty(InfinispanContext.REALM, "ApplicationRealm"));
                this.put(InfinispanContext.SERVER_NAME, System.getProperty(InfinispanContext.SERVER_NAME, ""));
                this.put(InfinispanContext.SASL_QOP, System.getProperty(InfinispanContext.SASL_QOP, ""));
            }
        };
        static final InfinispanContext INSTANCE = new InfinispanContext(PROPERTIES);

        private LazyHolder() {
        }
    }
}

