/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.client.views.pfly.menu.megamenu;

import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.Widget;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;
import org.jboss.errai.common.client.dom.Anchor;
import org.jboss.errai.common.client.dom.DOMUtil;
import org.jboss.errai.common.client.dom.Div;
import org.jboss.errai.common.client.dom.HTMLElement;
import org.jboss.errai.common.client.dom.Image;
import org.jboss.errai.common.client.dom.ListItem;
import org.jboss.errai.common.client.dom.Node;
import org.jboss.errai.common.client.dom.Span;
import org.jboss.errai.common.client.dom.UnorderedList;
import org.jboss.errai.ioc.client.api.ManagedInstance;
import org.jboss.errai.ui.client.local.api.IsElement;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.jboss.errai.ui.shared.api.annotations.DataField;
import org.jboss.errai.ui.shared.api.annotations.Templated;
import org.uberfire.client.workbench.widgets.menu.megamenu.WorkbenchMegaMenuPresenter;
import org.uberfire.client.workbench.widgets.menu.megamenu.base.BaseMenuItemPresenter;
import org.uberfire.client.workbench.widgets.menu.megamenu.base.HasChildren;
import org.uberfire.client.workbench.widgets.menu.megamenu.contextmenuitem.ChildContextMenuItemPresenter;
import org.uberfire.client.workbench.widgets.menu.megamenu.contextmenuitem.GroupContextMenuItemPresenter;
import org.uberfire.client.workbench.widgets.menu.megamenu.menuitem.ChildMenuItemPresenter;
import org.uberfire.client.workbench.widgets.menu.megamenu.menuitem.GroupMenuItemPresenter;
import org.uberfire.mvp.Command;

@Templated
public class WorkbenchMegaMenuView
implements WorkbenchMegaMenuPresenter.View,
IsElement {
    private WorkbenchMegaMenuPresenter presenter;
    @DataField(value="brand")
    private Div brand;
    @DataField(value="brand-image")
    private Image brandImage;
    @DataField(value="home-link")
    private Anchor homeLink;
    @DataField(value="menu-accessor-text")
    private Span menuAccessorText;
    @DataField(value="single-menu-items-container")
    private ListItem singleMenuItemsContainer;
    @DataField(value="single-menu-items")
    private UnorderedList singleMenuItems;
    @DataField(value="left-menu-items")
    private UnorderedList leftMenuItems;
    @DataField(value="right-menu-items")
    private UnorderedList rightMenuItems;
    @DataField(value="context-menu-items-container")
    private ListItem contextMenuItemsContainer;
    @DataField(value="context-menu-items")
    private UnorderedList contextMenuItems;
    private TranslationService translationService;
    private ManagedInstance<ChildMenuItemPresenter> childMenuItemPresenters;
    private ManagedInstance<GroupMenuItemPresenter> groupMenuItemPresenters;
    private ManagedInstance<ChildContextMenuItemPresenter> childContextMenuItemPresenters;
    private ManagedInstance<GroupContextMenuItemPresenter> groupContextMenuItemPresenters;
    Map<String, BaseMenuItemPresenter> menuItemByIdentifier = new HashMap<String, BaseMenuItemPresenter>();

    @Inject
    public WorkbenchMegaMenuView(Div brand, Image brandImage, Anchor homeLink, Span menuAccessorText, ListItem singleMenuItemsContainer, UnorderedList singleMenuItems, UnorderedList leftMenuItems, UnorderedList rightMenuItems, ListItem contextMenuItemsContainer, UnorderedList contextMenuItems, TranslationService translationService, ManagedInstance<ChildMenuItemPresenter> childMenuItemPresenters, ManagedInstance<GroupMenuItemPresenter> groupMenuItemPresenters, ManagedInstance<ChildContextMenuItemPresenter> childContextMenuItemPresenters, ManagedInstance<GroupContextMenuItemPresenter> groupContextMenuItemPresenters) {
        this.brand = brand;
        this.brandImage = brandImage;
        this.homeLink = homeLink;
        this.menuAccessorText = menuAccessorText;
        this.singleMenuItemsContainer = singleMenuItemsContainer;
        this.singleMenuItems = singleMenuItems;
        this.leftMenuItems = leftMenuItems;
        this.rightMenuItems = rightMenuItems;
        this.contextMenuItemsContainer = contextMenuItemsContainer;
        this.contextMenuItems = contextMenuItems;
        this.translationService = translationService;
        this.childMenuItemPresenters = childMenuItemPresenters;
        this.groupMenuItemPresenters = groupMenuItemPresenters;
        this.childContextMenuItemPresenters = childContextMenuItemPresenters;
        this.groupContextMenuItemPresenters = groupContextMenuItemPresenters;
    }

    public void init(WorkbenchMegaMenuPresenter presenter) {
        this.presenter = presenter;
        this.homeLink.setTitle(this.translationService.format("Home", new Object[0]));
    }

    public void clear() {
        this.singleMenuItems.setTextContent("");
        this.rightMenuItems.setTextContent("");
        for (int index = this.leftMenuItems.getChildNodes().getLength() - 1; index >= 0; --index) {
            Node child = this.leftMenuItems.getChildNodes().item(index);
            if (child.getChildNodes().getLength() <= 0 || child.equals(this.singleMenuItemsContainer)) continue;
            this.leftMenuItems.removeChild(child);
        }
        if (!this.singleMenuItemsContainer.getClassList().contains("empty")) {
            this.singleMenuItemsContainer.getClassList().add("empty");
        }
        this.menuItemByIdentifier = new HashMap<String, BaseMenuItemPresenter>();
    }

    public void clearContextMenu() {
        this.setContextMenuActive(false);
        this.contextMenuItems.setTextContent("");
    }

    public void setHomeLinkAction(Command command) {
        this.homeLink.setOnclick(event -> command.execute());
    }

    public void setBrandImageAction(Command command) {
        this.brandImage.setOnclick(event -> command.execute());
    }

    public String getDefaultMenuText() {
        return this.translationService.format("Menu", new Object[0]);
    }

    public void setBrandImage(String brandImageUrl) {
        this.brandImage.setSrc(brandImageUrl);
    }

    public void setBrandImageTitle(String brandImageLabel) {
        this.brandImage.setTitle(brandImageLabel);
    }

    public void hideBrand() {
        this.brand.setHidden(true);
    }

    public void setMenuAccessorText(String menuAccessorText) {
        this.menuAccessorText.setTextContent(menuAccessorText);
    }

    public void addMenuItemOnRight(ChildMenuItemPresenter itemPresenter) {
        this.rightMenuItems.appendChild((Node)itemPresenter.getView().getElement());
    }

    public void addMenuItemOnLeft(ChildMenuItemPresenter itemPresenter) {
        this.singleMenuItems.appendChild((Node)itemPresenter.getView().getElement());
        if (this.singleMenuItemsContainer.getClassList().contains("empty")) {
            this.singleMenuItemsContainer.getClassList().remove("empty");
        }
    }

    public void addMenuItemOnParent(ChildMenuItemPresenter itemPresenter, HasChildren parentPresenter) {
        parentPresenter.addChild((org.jboss.errai.common.client.api.IsElement)itemPresenter.getView());
    }

    public void addCustomMenuItem(org.jboss.errai.common.client.api.IsElement menu) {
        this.rightMenuItems.appendChild((Node)menu.getElement());
    }

    public void addCustomMenuItem(IsWidget menu) {
        this.appendWidgetToElement((HTMLElement)this.rightMenuItems, menu.asWidget());
    }

    public void addGroupMenuItem(GroupMenuItemPresenter itemPresenter) {
        this.leftMenuItems.appendChild((Node)itemPresenter.getView().getElement());
    }

    public void addContextMenuItem(GroupContextMenuItemPresenter itemPresenter) {
        this.contextMenuItems.appendChild((Node)itemPresenter.getView().getElement());
    }

    public void addContextMenuItem(ChildContextMenuItemPresenter itemPresenter) {
        this.contextMenuItems.appendChild((Node)itemPresenter.getView().getElement());
    }

    public void addContextMenuItemOnParent(ChildContextMenuItemPresenter itemPresenter, HasChildren parentPresenter) {
        parentPresenter.addChild((org.jboss.errai.common.client.api.IsElement)itemPresenter.getView());
    }

    void appendWidgetToElement(HTMLElement parent, Widget child) {
        DOMUtil.appendWidgetToElement((HTMLElement)parent, (Widget)child);
    }

    public void setContextMenuActive(boolean active) {
        if (active) {
            if (!this.contextMenuItemsContainer.getClassList().contains("active")) {
                this.contextMenuItemsContainer.getClassList().add("active");
            }
        } else if (this.contextMenuItemsContainer.getClassList().contains("active")) {
            this.contextMenuItemsContainer.getClassList().remove("active");
        }
    }
}

