/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.remote.rest.jbpm;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.Example;
import io.swagger.annotations.ExampleProperty;
import java.text.MessageFormat;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.Variant;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.dashbuilder.dataset.exception.DataSetLookupException;
import org.jbpm.services.api.query.QueryAlreadyRegisteredException;
import org.jbpm.services.api.query.QueryNotFoundException;
import org.kie.server.api.model.definition.QueryDefinition;
import org.kie.server.api.model.definition.QueryDefinitionList;
import org.kie.server.common.rest.HttpStatusCodeException;
import org.kie.server.remote.rest.common.Header;
import org.kie.server.remote.rest.common.util.RestUtils;
import org.kie.server.services.api.KieServerRegistry;
import org.kie.server.services.jbpm.QueryDataServiceBase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Api(value="Custom queries")
@Path(value="server/queries/definitions")
public class QueryDataResource {
    public static final Logger logger = LoggerFactory.getLogger(QueryDataResource.class);
    private QueryDataServiceBase queryDataServiceBase;
    private KieServerRegistry context;

    public QueryDataResource() {
    }

    public QueryDataResource(QueryDataServiceBase delegate, KieServerRegistry context) {
        this.queryDataServiceBase = delegate;
        this.context = context;
    }

    @ApiOperation(value="Returns all custom query definitions.", response=QueryDefinitionList.class, code=200)
    @ApiResponses(value={@ApiResponse(code=500, message="Unexpected error"), @ApiResponse(code=200, message="Successfull response", examples=@Example(value={@ExampleProperty(mediaType="application/json", value="{\n  \"queries\": [\n    {\n      \"query-name\": \"tasksMonitoring\",\n      \"query-source\": \"java:jboss/datasources/ExampleDS\",\n      \"query-expression\": \"select p.processName, p.externalId, t.taskId, t.taskName, t.status, t.createdDate, t.startDate, t.endDate, t.processInstanceId, t.userId, t.duration from ProcessInstanceLog p inner join BAMTaskSummary t on (t.processInstanceId = p.processInstanceId) inner join (select min(pk) as pk from BAMTaskSummary group by taskId) d on t.pk = d.pk\",\n      \"query-target\": \"CUSTOM\",\n      \"query-columns\": {}\n    },\n    {\n      \"query-name\": \"jbpmExecutionErrorList\",\n      \"query-source\": \"java:jboss/datasources/ExampleDS\",\n      \"query-expression\": \"select eri.ERROR_ACK, eri.ERROR_ACK_BY, eri.ERROR_ACK_AT, eri.ACTIVITY_ID, eri.ACTIVITY_NAME, eri.DEPLOYMENT_ID, eri.ERROR_DATE, eri.ERROR_ID, eri.ERROR_MSG, eri.JOB_ID, eri.PROCESS_ID, eri.PROCESS_INST_ID, eri.ERROR_TYPE from ExecutionErrorInfo eri\",\n      \"query-target\": \"CUSTOM\",\n      \"query-columns\": {}\n    },\n    {\n      \"query-name\": \"jbpmRequestList\",\n      \"query-source\": \"java:jboss/datasources/ExampleDS\",\n      \"query-expression\": \"select ri.id, ri.timestamp, ri.status, ri.commandName, ri.message, ri.businessKey, ri.retries, ri.executions, pil.processName, pil.processInstanceId, pil.processInstanceDescription, ri.deploymentId from RequestInfo ri left join ProcessInstanceLog pil on pil.processInstanceId=ri.processInstanceId\",\n      \"query-target\": \"CUSTOM\",\n      \"query-columns\": {}\n    }\n  ]\n}")}))})
    @GET
    @Produces(value={"application/json", "application/xml"})
    public Response getQueries(@Context HttpHeaders headers, @ApiParam(value="optional pagination - at which page to start, defaults to 0 (meaning first)", required=false) @QueryParam(value="page") @DefaultValue(value="0") Integer page, @ApiParam(value="optional pagination - size of the result, defaults to 10", required=false) @QueryParam(value="pageSize") @DefaultValue(value="10") Integer pageSize) {
        Header conversationIdHeader = RestUtils.buildConversationIdHeader((String)"", (KieServerRegistry)this.context, (HttpHeaders)headers);
        QueryDefinitionList result = this.queryDataServiceBase.getQueries(page, pageSize);
        logger.debug("Returning result of get queries definition: {}", (Object)result);
        return RestUtils.createCorrectVariant((Object)result, (HttpHeaders)headers, (Response.Status)Response.Status.OK, (Header[])new Header[]{conversationIdHeader});
    }

    @ApiOperation(value="Registers a custom query definition.", response=QueryDefinition.class, code=201)
    @ApiResponses(value={@ApiResponse(code=500, message="Unexpected error"), @ApiResponse(code=409, message="Query with given name already exists"), @ApiResponse(code=201, message="Successfull response", examples=@Example(value={@ExampleProperty(mediaType="application/json", value="{\n  \"query-name\": \"jbpmProcessInstancesWithVariables1\",\n  \"query-source\": \"java:jboss/datasources/ExampleDS\",\n  \"query-expression\": \"select vil.processInstanceId, vil.processId, vil.id, vil.variableId, vil.value from VariableInstanceLog vil where vil.id in (select MAX(v.id) from VariableInstanceLog v group by v.variableId, v.processInstanceId)\",\n  \"query-target\": \"CUSTOM\",\n  \"query-columns\": {\n    \"PROCESSINSTANCEID\": \"NUMBER\",\n    \"VARIABLEID\": \"LABEL\",\n    \"ID\": \"NUMBER\",\n    \"VALUE\": \"LABEL\",\n    \"PROCESSID\": \"LABEL\"\n  }\n}")}))})
    @POST
    @Path(value="{queryName}")
    @Consumes(value={"application/json", "application/xml"})
    @Produces(value={"application/json", "application/xml"})
    public Response createQueryDefinition(@Context HttpHeaders headers, @ApiParam(value="identifier of the query definition to be registered", required=true, example="customQuery") @PathParam(value="queryName") String queryName, @ApiParam(value="query definition represented as QueryDefinition", required=true, examples=@Example(value={@ExampleProperty(mediaType="application/json", value="{\n  \"query-name\" : \"allProcessInstances\",\n  \"query-source\" : \"jdbc/jbpm-ds\",\n  \"query-expression\" : \"select * from ProcessInstanceLog where status = 1\",\n  \"query-target\" : \"PROCESS\",\n  \"query-columns\" : null\n}"), @ExampleProperty(mediaType="application/xml", value="<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?>\n<query-definition>\n    <query-name>allProcessInstances</query-name>\n    <query-source>jdbc/jbpm-ds</query-source>\n    <query-expression>select * from ProcessInstanceLog where status = 1</query-expression>\n    <query-target>PROCESS</query-target>\n    <columns></columns>\n</query-definition>")})) String payload) {
        Variant v = RestUtils.getVariant((HttpHeaders)headers);
        String type = RestUtils.getContentType((HttpHeaders)headers);
        Header conversationIdHeader = RestUtils.buildConversationIdHeader((String)"", (KieServerRegistry)this.context, (HttpHeaders)headers);
        try {
            QueryDefinition def = this.queryDataServiceBase.registerQuery(queryName, payload, type);
            logger.debug("Returning CREATED response after registering query with name {}", (Object)queryName);
            return RestUtils.createCorrectVariant((Object)def, (HttpHeaders)headers, (Response.Status)Response.Status.CREATED, (Header[])new Header[]{conversationIdHeader});
        }
        catch (QueryAlreadyRegisteredException e) {
            return RestUtils.alreadyExists((String)MessageFormat.format("Query definition with name \"{0}\" already exists", queryName), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
        catch (Exception e) {
            logger.error("Unexpected error during processing {}", (Object)e.getMessage(), (Object)e);
            return RestUtils.internalServerError((String)RestUtils.errorMessage((Throwable)e), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
    }

    @ApiOperation(value="Replaces existing custom query definition or registers it as new if the query does not already exist.", response=QueryDefinition.class, code=201)
    @ApiResponses(value={@ApiResponse(code=500, message="Unexpected error"), @ApiResponse(code=201, message="Successfull response", examples=@Example(value={@ExampleProperty(mediaType="application/json", value="{\n  \"query-name\": \"jbpmProcessInstancesWithVariables1\",\n  \"query-source\": \"java:jboss/datasources/ExampleDS\",\n  \"query-expression\": \"select vil.processInstanceId, vil.processId, vil.id, vil.variableId, vil.value from VariableInstanceLog vil where vil.id in (select MAX(v.id) from VariableInstanceLog v group by v.variableId, v.processInstanceId)\",\n  \"query-target\": \"CUSTOM\",\n  \"query-columns\": {\n    \"PROCESSINSTANCEID\": \"NUMBER\",\n    \"VARIABLEID\": \"LABEL\",\n    \"ID\": \"NUMBER\",\n    \"VALUE\": \"LABEL\",\n    \"PROCESSID\": \"LABEL\"\n  }\n}")}))})
    @PUT
    @Path(value="{queryName}")
    @Consumes(value={"application/json", "application/xml"})
    @Produces(value={"application/json", "application/xml"})
    public Response replaceQueryDefinition(@Context HttpHeaders headers, @ApiParam(value="identifier of the query definition to be replaced", required=true, example="customQuery") @PathParam(value="queryName") String queryName, @ApiParam(value="query definition represented as QueryDefinition", required=true, examples=@Example(value={@ExampleProperty(mediaType="application/json", value="{\n  \"query-name\" : \"allProcessInstances\",\n  \"query-source\" : \"jdbc/jbpm-ds\",\n  \"query-expression\" : \"select * from ProcessInstanceLog where status = 1\",\n  \"query-target\" : \"PROCESS\",\n  \"query-columns\" : null\n}"), @ExampleProperty(mediaType="application/xml", value="<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?>\n<query-definition>\n    <query-name>allProcessInstances</query-name>\n    <query-source>jdbc/jbpm-ds</query-source>\n    <query-expression>select * from ProcessInstanceLog where status = 1</query-expression>\n    <query-target>PROCESS</query-target>\n    <columns></columns>\n</query-definition>")})) String payload) {
        Variant v = RestUtils.getVariant((HttpHeaders)headers);
        String type = RestUtils.getContentType((HttpHeaders)headers);
        Header conversationIdHeader = RestUtils.buildConversationIdHeader((String)"", (KieServerRegistry)this.context, (HttpHeaders)headers);
        try {
            QueryDefinition def = this.queryDataServiceBase.replaceQuery(queryName, payload, type);
            logger.debug("Returning CREATED response after registering query with name {}", (Object)queryName);
            return RestUtils.createCorrectVariant((Object)def, (HttpHeaders)headers, (Response.Status)Response.Status.CREATED, (Header[])new Header[]{conversationIdHeader});
        }
        catch (Exception e) {
            logger.error("Unexpected error during processing {}", (Object)e.getMessage(), (Object)e);
            return RestUtils.internalServerError((String)RestUtils.errorMessage((Throwable)e), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
    }

    @ApiOperation(value="Deletes a specified custom query.", response=Void.class, code=204)
    @ApiResponses(value={@ApiResponse(code=500, message="Unexpected error"), @ApiResponse(code=404, message="Query definition with given name not found")})
    @DELETE
    @Path(value="{queryName}")
    @Produces(value={"application/json", "application/xml"})
    public Response dropQueryDefinition(@Context HttpHeaders headers, @ApiParam(value="identifier of the query definition to be deleted", required=true, example="customQuery") @PathParam(value="queryName") String queryName) {
        Variant v = RestUtils.getVariant((HttpHeaders)headers);
        Header conversationIdHeader = RestUtils.buildConversationIdHeader((String)"", (KieServerRegistry)this.context, (HttpHeaders)headers);
        try {
            this.queryDataServiceBase.unregisterQuery(queryName);
            return RestUtils.noContent((Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
        catch (QueryNotFoundException e) {
            return RestUtils.notFound((String)MessageFormat.format("Could not find query definition with name \"{0}\"", queryName), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
        catch (Exception e) {
            logger.error("Unexpected error during processing {}", (Object)e.getMessage(), (Object)e);
            return RestUtils.internalServerError((String)RestUtils.errorMessage((Throwable)e), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
    }

    @ApiOperation(value="Returns information about a specified custom query.", response=QueryDefinition.class, code=200)
    @ApiResponses(value={@ApiResponse(code=500, message="Unexpected error"), @ApiResponse(code=404, message="Query definition with given name not found"), @ApiResponse(code=200, message="Successfull response", examples=@Example(value={@ExampleProperty(mediaType="application/json", value="{\n  \"query-name\": \"jbpmProcessInstancesWithVariables1\",\n  \"query-source\": \"java:jboss/datasources/ExampleDS\",\n  \"query-expression\": \"select vil.processInstanceId, vil.processId, vil.id, vil.variableId, vil.value from VariableInstanceLog vil where vil.id in (select MAX(v.id) from VariableInstanceLog v group by v.variableId, v.processInstanceId)\",\n  \"query-target\": \"CUSTOM\",\n  \"query-columns\": {\n    \"PROCESSINSTANCEID\": \"NUMBER\",\n    \"VARIABLEID\": \"LABEL\",\n    \"ID\": \"NUMBER\",\n    \"VALUE\": \"LABEL\",\n    \"PROCESSID\": \"LABEL\"\n  }\n}")}))})
    @GET
    @Path(value="{queryName}")
    @Produces(value={"application/json", "application/xml"})
    public Response getQuery(@Context HttpHeaders headers, @ApiParam(value="identifier of the query definition to be retrieved", required=true, example="customQuery") @PathParam(value="queryName") String queryName) {
        Variant v = RestUtils.getVariant((HttpHeaders)headers);
        Header conversationIdHeader = RestUtils.buildConversationIdHeader((String)"", (KieServerRegistry)this.context, (HttpHeaders)headers);
        try {
            QueryDefinition queryDefinition = this.queryDataServiceBase.getQuery(queryName);
            return RestUtils.createCorrectVariant((Object)queryDefinition, (HttpHeaders)headers, (Response.Status)Response.Status.OK, (Header[])new Header[]{conversationIdHeader});
        }
        catch (QueryNotFoundException e) {
            return RestUtils.notFound((String)MessageFormat.format("Could not find query definition with name \"{0}\"", queryName), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
        catch (Exception e) {
            logger.error("Unexpected error during processing {}", (Object)e.getMessage(), (Object)e);
            return RestUtils.internalServerError((String)RestUtils.errorMessage((Throwable)e), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
    }

    @ApiOperation(value="Returns the results of a specified custom query.", response=Object.class, responseContainer="List", code=200)
    @ApiResponses(value={@ApiResponse(code=500, message="Unexpected error"), @ApiResponse(code=404, message="Query definition with given name not found"), @ApiResponse(code=200, message="Successfull response", examples=@Example(value={@ExampleProperty(mediaType="application/json", value="{\n  \"process-instance\": [\n    {\n      \"process-instance-id\": 1,\n      \"process-id\": \"Employee_Rostering.Process1\",\n      \"process-name\": \"Process1\",\n      \"process-version\": \"1.0\",\n      \"process-instance-state\": 1,\n      \"container-id\": \"employee-rostering\",\n      \"initiator\": \"baAdmin\",\n      \"start-date\": {\n        \"java.util.Date\": 1539184095041\n      },\n      \"process-instance-desc\": \"Process1\",\n      \"correlation-key\": \"1\",\n      \"parent-instance-id\": -1,\n      \"sla-compliance\": 0,\n      \"sla-due-date\": null,\n      \"active-user-tasks\": null,\n      \"process-instance-variables\": null\n    },\n    {\n      \"process-instance-id\": 2,\n      \"process-id\": \"Employee_Rostering.Process2\",\n      \"process-name\": \"Process2\",\n      \"process-version\": \"1.0\",\n      \"process-instance-state\": 1,\n      \"container-id\": \"employee-rostering\",\n      \"initiator\": \"baAdmin\",\n      \"start-date\": {\n        \"java.util.Date\": 1539184303976\n      },\n      \"process-instance-desc\": \"Process2\",\n      \"correlation-key\": \"2\",\n      \"parent-instance-id\": -1,\n      \"sla-compliance\": 0,\n      \"sla-due-date\": null,\n      \"active-user-tasks\": null,\n      \"process-instance-variables\": null\n    }\n  ]\n}")}))})
    @GET
    @Path(value="{queryName}/data")
    @Produces(value={"application/json", "application/xml"})
    public Response runQuery(@Context HttpHeaders headers, @ApiParam(value="identifier of the query definition to be used for query", required=true, example="customQuery") @PathParam(value="queryName") String queryName, @ApiParam(value="identifier of the query mapper to be used when transforming results", required=true) @QueryParam(value="mapper") String mapper, @ApiParam(value="optional sort order", required=false) @QueryParam(value="orderBy") String orderBy, @ApiParam(value="optional pagination - at which page to start, defaults to 0 (meaning first)", required=false) @QueryParam(value="page") @DefaultValue(value="0") Integer page, @ApiParam(value="optional pagination - size of the result, defaults to 10", required=false) @QueryParam(value="pageSize") @DefaultValue(value="10") Integer pageSize) {
        Header conversationIdHeader = RestUtils.buildConversationIdHeader((String)"", (KieServerRegistry)this.context, (HttpHeaders)headers);
        Object result = this.queryDataServiceBase.query(queryName, mapper, orderBy, page, pageSize);
        logger.debug("Returning result of process instance search: {}", result);
        return RestUtils.createCorrectVariant((Object)result, (HttpHeaders)headers, (Response.Status)Response.Status.OK, (Header[])new Header[]{conversationIdHeader});
    }

    @ApiOperation(value="Returns the results of a specified custom query and filters the results based on a provided builder or filter request body.", response=Object.class, code=200)
    @ApiResponses(value={@ApiResponse(code=500, message="Unexpected error"), @ApiResponse(code=400, message="Query parameters or filter spec provide invalid conditions"), @ApiResponse(code=200, message="Successfull response", examples=@Example(value={@ExampleProperty(mediaType="application/json", value="{\n  \"process-instance\": [\n    {\n      \"process-instance-id\": 1,\n      \"process-id\": \"Employee_Rostering.Process1\",\n      \"process-name\": \"Process1\",\n      \"process-version\": \"1.0\",\n      \"process-instance-state\": 1,\n      \"container-id\": \"employee-rostering\",\n      \"initiator\": \"baAdmin\",\n      \"start-date\": {\n        \"java.util.Date\": 1539184095041\n      },\n      \"process-instance-desc\": \"Process1\",\n      \"correlation-key\": \"1\",\n      \"parent-instance-id\": -1,\n      \"sla-compliance\": 0,\n      \"sla-due-date\": null,\n      \"active-user-tasks\": null,\n      \"process-instance-variables\": null\n    },\n    {\n      \"process-instance-id\": 2,\n      \"process-id\": \"Employee_Rostering.Process2\",\n      \"process-name\": \"Process2\",\n      \"process-version\": \"1.0\",\n      \"process-instance-state\": 1,\n      \"container-id\": \"employee-rostering\",\n      \"initiator\": \"baAdmin\",\n      \"start-date\": {\n        \"java.util.Date\": 1539184303976\n      },\n      \"process-instance-desc\": \"Process2\",\n      \"correlation-key\": \"2\",\n      \"parent-instance-id\": -1,\n      \"sla-compliance\": 0,\n      \"sla-due-date\": null,\n      \"active-user-tasks\": null,\n      \"process-instance-variables\": null\n    }\n  ]\n}")}))})
    @POST
    @Path(value="{queryName}/filtered-data")
    @Consumes(value={"application/json", "application/xml"})
    @Produces(value={"application/json", "application/xml"})
    public Response runQueryFiltered(@Context HttpHeaders headers, @ApiParam(value="identifier of the query definition to be used for query", required=true, example="customQuery") @PathParam(value="queryName") String queryName, @ApiParam(value="identifier of the query mapper to be used when transforming results", required=true) @QueryParam(value="mapper") String mapper, @ApiParam(value="optional identifier of the query builder to be used for query conditions", required=false) @QueryParam(value="builder") String builder, @ApiParam(value="optional pagination - at which page to start, defaults to 0 (meaning first)", required=false) @QueryParam(value="page") @DefaultValue(value="0") Integer page, @ApiParam(value="optional pagination - size of the result, defaults to 10", required=false) @QueryParam(value="pageSize") @DefaultValue(value="10") Integer pageSize, @ApiParam(value="optional query filter specification represented as QueryFilterSpec", required=false, examples=@Example(value={@ExampleProperty(mediaType="application/json", value="{\n  \"order-by\" : null,\n  \"order-asc\" : false,\n  \"query-params\" : [ {\n    \"cond-column\" : \"processinstanceid\",\n    \"cond-operator\" : \"GREATER_THAN\",\n    \"cond-values\" : [ 9 ]\n  } ],\n  \"result-column-mapping\" : null,\n  \"order-by-clause\" : null\n}"), @ExampleProperty(mediaType="application/xml", value="<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?>\n<query-filter-spec>\n    <order-asc>false</order-asc>\n    <query-params>\n        <cond-column>processinstanceid</cond-column>\n        <cond-operator>GREATER_THAN</cond-operator>\n        <cond-values xsi:type=\"xs:long\" xmlns:xs=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">9</cond-values>\n    </query-params>\n</query-filter-spec>")})) String payload) {
        String type = RestUtils.getContentType((HttpHeaders)headers);
        Header conversationIdHeader = RestUtils.buildConversationIdHeader((String)"", (KieServerRegistry)this.context, (HttpHeaders)headers);
        Object result = null;
        try {
            result = builder != null && !builder.isEmpty() ? this.queryDataServiceBase.queryFilteredWithBuilder(queryName, mapper, builder, page, pageSize, payload, type) : this.queryDataServiceBase.queryFiltered(queryName, mapper, page, pageSize, payload, type);
            logger.debug("Returning result of process instance search: {}", result);
            return RestUtils.createCorrectVariant((Object)result, (HttpHeaders)headers, (Response.Status)Response.Status.OK, (Header[])new Header[]{conversationIdHeader});
        }
        catch (Exception e) {
            Throwable root = ExceptionUtils.getRootCause((Throwable)e);
            if (root == null) {
                root = e;
            }
            if (HttpStatusCodeException.BAD_REQUEST.contains(root.getClass()) || e instanceof DataSetLookupException) {
                logger.error("{}", (Object)MessageFormat.format("The request could not be understood by the server due to malformed syntax: {0}", root.getMessage()), (Object)e);
                return RestUtils.badRequest((String)MessageFormat.format("The request could not be understood by the server due to malformed syntax: {0}", root.getMessage()), (Variant)RestUtils.getVariant((HttpHeaders)headers), (Header[])new Header[]{conversationIdHeader});
            }
            logger.error("Unexpected error", (Throwable)e);
            return RestUtils.internalServerError((String)RestUtils.errorMessage((Throwable)e), (Variant)RestUtils.getVariant((HttpHeaders)headers), (Header[])new Header[]{conversationIdHeader});
        }
    }

    @ApiOperation(value="Returns the results of a specified custom query on a specified KIE container and filters the results based on a provided builder or filter request body.", response=Object.class, code=200)
    @ApiResponses(value={@ApiResponse(code=500, message="Unexpected error"), @ApiResponse(code=400, message="Query parameters or filter spec provide invalid conditions"), @ApiResponse(code=200, message="Successfull response", examples=@Example(value={@ExampleProperty(mediaType="application/json", value="{\n  \"process-instance\": [\n    {\n      \"process-instance-id\": 1,\n      \"process-id\": \"Employee_Rostering.Process1\",\n      \"process-name\": \"Process1\",\n      \"process-version\": \"1.0\",\n      \"process-instance-state\": 1,\n      \"container-id\": \"employee-rostering\",\n      \"initiator\": \"baAdmin\",\n      \"start-date\": {\n        \"java.util.Date\": 1539184095041\n      },\n      \"process-instance-desc\": \"Process1\",\n      \"correlation-key\": \"1\",\n      \"parent-instance-id\": -1,\n      \"sla-compliance\": 0,\n      \"sla-due-date\": null,\n      \"active-user-tasks\": null,\n      \"process-instance-variables\": null\n    },\n    {\n      \"process-instance-id\": 2,\n      \"process-id\": \"Employee_Rostering.Process2\",\n      \"process-name\": \"Process2\",\n      \"process-version\": \"1.0\",\n      \"process-instance-state\": 1,\n      \"container-id\": \"employee-rostering\",\n      \"initiator\": \"baAdmin\",\n      \"start-date\": {\n        \"java.util.Date\": 1539184303976\n      },\n      \"process-instance-desc\": \"Process2\",\n      \"correlation-key\": \"2\",\n      \"parent-instance-id\": -1,\n      \"sla-compliance\": 0,\n      \"sla-due-date\": null,\n      \"active-user-tasks\": null,\n      \"process-instance-variables\": null\n    }\n  ]\n}")}))})
    @POST
    @Path(value="containers/{containerId}/query/{queryName}/filtered-data")
    @Consumes(value={"application/json", "application/xml"})
    @Produces(value={"application/json", "application/xml"})
    public Response runQueryFilteredByDeploymentId(@Context HttpHeaders headers, @ApiParam(value="container id to filter queries", required=true, example="evaluation_1.0.0-SNAPSHOT") @PathParam(value="containerId") String containerId, @ApiParam(value="identifier of the query definition to be used for query", required=true, example="customQuery") @PathParam(value="queryName") String queryName, @ApiParam(value="identifier of the query mapper to be used when transforming results", required=true) @QueryParam(value="mapper") String mapper, @ApiParam(value="optional identifier of the query builder to be used for query conditions", required=false) @QueryParam(value="builder") String builder, @ApiParam(value="optional pagination - at which page to start, defaults to 0 (meaning first)", required=false) @QueryParam(value="page") @DefaultValue(value="0") Integer page, @ApiParam(value="optional pagination - size of the result, defaults to 10", required=false) @QueryParam(value="pageSize") @DefaultValue(value="10") Integer pageSize, @ApiParam(value="optional query filter specification represented as QueryFilterSpec", required=false, examples=@Example(value={@ExampleProperty(mediaType="application/json", value="{\n  \"order-by\" : null,\n  \"order-asc\" : false,\n  \"query-params\" : [ {\n    \"cond-column\" : \"processinstanceid\",\n    \"cond-operator\" : \"GREATER_THAN\",\n    \"cond-values\" : [ 9 ]\n  } ],\n  \"result-column-mapping\" : null,\n  \"order-by-clause\" : null\n}"), @ExampleProperty(mediaType="application/xml", value="<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?>\n<query-filter-spec>\n    <order-asc>false</order-asc>\n    <query-params>\n        <cond-column>processinstanceid</cond-column>\n        <cond-operator>GREATER_THAN</cond-operator>\n        <cond-values xsi:type=\"xs:long\" xmlns:xs=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">9</cond-values>\n    </query-params>\n</query-filter-spec>")})) String payload) {
        String type = RestUtils.getContentType((HttpHeaders)headers);
        Header conversationIdHeader = RestUtils.buildConversationIdHeader((String)containerId, (KieServerRegistry)this.context, (HttpHeaders)headers);
        Object result = null;
        try {
            result = builder != null && !builder.isEmpty() ? this.queryDataServiceBase.queryFilteredWithBuilder(containerId, queryName, mapper, builder, page, pageSize, payload, type) : this.queryDataServiceBase.queryFiltered(containerId, queryName, mapper, page, pageSize, payload, type);
            logger.debug("Returning result of process instance search: {}", result);
            return RestUtils.createCorrectVariant((Object)result, (HttpHeaders)headers, (Response.Status)Response.Status.OK, (Header[])new Header[]{conversationIdHeader});
        }
        catch (Exception e) {
            Throwable root = ExceptionUtils.getRootCause((Throwable)e);
            if (root == null) {
                root = e;
            }
            if (HttpStatusCodeException.BAD_REQUEST.contains(root.getClass()) || e instanceof DataSetLookupException) {
                logger.error("{}", (Object)MessageFormat.format("The request could not be understood by the server due to malformed syntax: {0}", root.getMessage()), (Object)e);
                return RestUtils.badRequest((String)MessageFormat.format("The request could not be understood by the server due to malformed syntax: {0}", root.getMessage()), (Variant)RestUtils.getVariant((HttpHeaders)headers), (Header[])new Header[]{conversationIdHeader});
            }
            logger.error("Unexpected error", (Throwable)e);
            return RestUtils.internalServerError((String)RestUtils.errorMessage((Throwable)e), (Variant)RestUtils.getVariant((HttpHeaders)headers), (Header[])new Header[]{conversationIdHeader});
        }
    }
}

