/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.services.taskassigning.core.model.solver.realtime;

import java.util.ArrayList;
import org.kie.server.services.taskassigning.core.TaskAssigningRuntimeException;
import org.kie.server.services.taskassigning.core.model.TaskAssigningSolution;
import org.kie.server.services.taskassigning.core.model.User;
import org.optaplanner.core.impl.score.director.ScoreDirector;
import org.optaplanner.core.impl.solver.ProblemFactChange;

public class AddUserProblemFactChange
implements ProblemFactChange<TaskAssigningSolution> {
    private User user;

    public AddUserProblemFactChange(User user) {
        this.user = user;
    }

    public User getUser() {
        return this.user;
    }

    public void doChange(ScoreDirector<TaskAssigningSolution> scoreDirector) {
        TaskAssigningSolution workingSolution = (TaskAssigningSolution)scoreDirector.getWorkingSolution();
        User workingUser = (User)scoreDirector.lookUpWorkingObjectOrReturnNull((Object)this.user);
        if (workingUser != null) {
            throw new TaskAssigningRuntimeException(String.format("A user with the given identifier id: %s already exists", this.user.getEntityId()));
        }
        workingSolution.setUserList(new ArrayList<User>(workingSolution.getUserList()));
        scoreDirector.beforeProblemFactAdded((Object)this.user);
        workingSolution.getUserList().add(this.user);
        scoreDirector.afterProblemFactAdded((Object)this.user);
        scoreDirector.triggerVariableListeners();
    }
}

