/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.metadata.backend.infinispan.ickl.converters;

import java.util.Iterator;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.uberfire.ext.metadata.backend.infinispan.ickl.IckleConverter;
import org.uberfire.ext.metadata.backend.infinispan.ickl.converters.QueryConverter;

public class BooleanQueryConverter
implements QueryConverter {
    private BooleanQuery booleanQuery;
    private IckleConverter icklConverter;

    public BooleanQueryConverter(BooleanQuery booleanQuery, IckleConverter icklConverter) {
        this.booleanQuery = booleanQuery;
        this.icklConverter = icklConverter;
    }

    @Override
    public String convert() {
        Iterator clauses = this.booleanQuery.clauses().iterator();
        StringBuilder queryString = new StringBuilder();
        while (clauses.hasNext()) {
            BooleanClause clause = (BooleanClause)clauses.next();
            String queryResult = this.icklConverter.convert(clause.getQuery());
            if (BooleanQuery.class.isAssignableFrom(clause.getQuery().getClass())) {
                queryResult = "(" + queryResult + ")";
            }
            if (clause.isProhibited()) {
                queryResult = "NOT " + queryResult;
            }
            if (clauses.hasNext()) {
                String operator = this.getBooleanOperator(clause);
                queryResult = queryResult + " " + operator + " ";
            }
            queryString.append(queryResult);
        }
        return queryString.toString().trim();
    }

    private String getBooleanOperator(BooleanClause booleanClause) {
        return booleanClause.isRequired() ? "AND" : "OR";
    }
}

